/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.addressing;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.org.glassfish.gmbal.ManagedAttribute;
import com.sun.org.glassfish.gmbal.ManagedData;
import com.sun.xml.internal.ws.api.FeatureConstructor;
import com.sun.xml.internal.ws.api.addressing.AddressingPropertySet;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.addressing.WSEndpointReference;
import java.net.URL;
import javax.xml.ws.WebServiceFeature;

@ManagedData
public class OneWayFeature
extends WebServiceFeature {
    public static final String ID = "http://java.sun.com/xml/ns/jaxws/addressing/oneway";
    private String messageId;
    private WSEndpointReference replyTo;
    private WSEndpointReference sslReplyTo;
    private WSEndpointReference from;
    private WSEndpointReference faultTo;
    private WSEndpointReference sslFaultTo;
    private String relatesToID;
    private boolean useAsyncWithSyncInvoke = false;

    public OneWayFeature() {
        this.enabled = true;
    }

    public OneWayFeature(boolean bl) {
        this.enabled = bl;
    }

    public OneWayFeature(boolean bl, WSEndpointReference wSEndpointReference) {
        this.enabled = bl;
        this.replyTo = wSEndpointReference;
    }

    @FeatureConstructor(value={"enabled", "replyTo", "from", "relatesTo"})
    public OneWayFeature(boolean bl, WSEndpointReference wSEndpointReference, WSEndpointReference wSEndpointReference2, String string) {
        this.enabled = bl;
        this.replyTo = wSEndpointReference;
        this.from = wSEndpointReference2;
        this.relatesToID = string;
    }

    public OneWayFeature(AddressingPropertySet addressingPropertySet, AddressingVersion addressingVersion) {
        this.enabled = true;
        this.messageId = addressingPropertySet.getMessageId();
        this.relatesToID = addressingPropertySet.getRelatesTo();
        this.replyTo = this.makeEPR(addressingPropertySet.getReplyTo(), addressingVersion);
        this.faultTo = this.makeEPR(addressingPropertySet.getFaultTo(), addressingVersion);
    }

    private WSEndpointReference makeEPR(String string, AddressingVersion addressingVersion) {
        if (string == null) {
            return null;
        }
        return new WSEndpointReference(string, addressingVersion);
    }

    public String getMessageId() {
        return this.messageId;
    }

    @Override
    @ManagedAttribute
    public String getID() {
        return ID;
    }

    public boolean hasSslEprs() {
        return this.sslReplyTo != null || this.sslFaultTo != null;
    }

    @ManagedAttribute
    public WSEndpointReference getReplyTo() {
        return this.replyTo;
    }

    public WSEndpointReference getReplyTo(boolean bl) {
        return bl && this.sslReplyTo != null ? this.sslReplyTo : this.replyTo;
    }

    public void setReplyTo(WSEndpointReference wSEndpointReference) {
        this.replyTo = wSEndpointReference;
    }

    public WSEndpointReference getSslReplyTo() {
        return this.sslReplyTo;
    }

    public void setSslReplyTo(WSEndpointReference wSEndpointReference) {
        this.sslReplyTo = wSEndpointReference;
    }

    @ManagedAttribute
    public WSEndpointReference getFrom() {
        return this.from;
    }

    public void setFrom(WSEndpointReference wSEndpointReference) {
        this.from = wSEndpointReference;
    }

    @ManagedAttribute
    public String getRelatesToID() {
        return this.relatesToID;
    }

    public void setRelatesToID(String string) {
        this.relatesToID = string;
    }

    public WSEndpointReference getFaultTo() {
        return this.faultTo;
    }

    public WSEndpointReference getFaultTo(boolean bl) {
        return bl && this.sslFaultTo != null ? this.sslFaultTo : this.faultTo;
    }

    public void setFaultTo(WSEndpointReference wSEndpointReference) {
        this.faultTo = wSEndpointReference;
    }

    public WSEndpointReference getSslFaultTo() {
        return this.sslFaultTo;
    }

    public void setSslFaultTo(WSEndpointReference wSEndpointReference) {
        this.sslFaultTo = wSEndpointReference;
    }

    public boolean isUseAsyncWithSyncInvoke() {
        return this.useAsyncWithSyncInvoke;
    }

    public void setUseAsyncWithSyncInvoke(boolean bl) {
        this.useAsyncWithSyncInvoke = bl;
    }

    public static WSEndpointReference enableSslForEpr(@NotNull WSEndpointReference wSEndpointReference, @Nullable String string, int n) {
        if (!wSEndpointReference.isAnonymous()) {
            URL uRL;
            String string2 = wSEndpointReference.getAddress();
            try {
                uRL = new URL(string2);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            String string3 = uRL.getProtocol();
            if (!string3.equalsIgnoreCase("https")) {
                string3 = "https";
                String string4 = uRL.getHost();
                if (string != null) {
                    string4 = string;
                }
                int n2 = uRL.getPort();
                if (n > 0) {
                    n2 = n;
                }
                try {
                    uRL = new URL(string3, string4, n2, uRL.getFile());
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
                string2 = uRL.toExternalForm();
                return new WSEndpointReference(string2, wSEndpointReference.getVersion());
            }
        }
        return wSEndpointReference;
    }
}

