/*
 * Decompiled with CFR 0.152.
 */
package pavocado.exoticbirds.entity.Birds;

import javax.annotation.Nullable;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import pavocado.exoticbirds.entity.Birds.EntityPeafowl;
import pavocado.exoticbirds.entity.Birds.EntityPhoenix;
import pavocado.exoticbirds.init.handlers.ConfigHandler;

public abstract class EntityBird
extends EntityAnimal {
    public int noOfTypes;
    public int timeUntilNextEgg = this.field_70146_Z.nextInt(6000) + ConfigHandler.egg_lay_rate;
    private Item eggType;
    public float startRotation;
    public float destPos;
    public float groundOffset;
    public float wingRotation;
    public float speedBuffer = 1.0f;
    public boolean canFloat;
    public boolean gendered;
    private static final DataParameter<Integer> BIRD_TYPE = EntityDataManager.func_187226_a(EntityBird.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityBird(World worldIn, Item egg, int types, boolean canFloat, boolean gender) {
        super(worldIn);
        this.eggType = egg;
        this.noOfTypes = types;
        this.canFloat = canFloat;
        this.gendered = gender;
    }

    public String getBirdName() {
        if (this.noOfTypes == 1 || this.gendered) {
            return new TextComponentTranslation("species.exoticbirds." + this.func_70022_Q().substring(12) + ".name", new Object[0]).func_150254_d();
        }
        return new TextComponentTranslation("species.exoticbirds." + this.func_70022_Q().substring(12) + this.getBirdType() + ".name", new Object[0]).func_150254_d();
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.wingRotation = this.startRotation;
        this.groundOffset = this.destPos;
        this.destPos = (float)((double)this.destPos + (double)(this.field_70122_E || this.field_70171_ac ? -1 : 4) * 0.3);
        if (this.destPos < 0.0f) {
            this.destPos = 0.0f;
        }
        if (this.destPos > 1.0f) {
            this.destPos = 1.0f;
        }
        if (this.canFloat) {
            if (!this.field_70122_E && this.speedBuffer < 1.0f) {
                this.speedBuffer = 1.0f;
            }
            this.speedBuffer = (float)((double)this.speedBuffer * 0.9);
            if (!this.field_70122_E && this.field_70181_x < 0.0) {
                this.field_70181_x *= 0.6;
            }
            this.startRotation += this.speedBuffer * 2.0f;
        }
        if (ConfigHandler.lay_eggs.booleanValue() && !this.field_70170_p.field_72995_K && !this.func_70631_g_() && --this.timeUntilNextEgg <= 0 && this.field_70122_E) {
            if (!(this instanceof EntityPhoenix) && (!this.gendered || this.gendered && this.getBirdType() == 1)) {
                this.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                this.func_145779_a(this.eggType, 1);
            } else if (this.getBirdType() == 2 && this instanceof EntityPeafowl) {
                this.func_145779_a(Items.field_151043_k, 1);
            }
            this.timeUntilNextEgg = this.field_70146_Z.nextInt(6000) + ConfigHandler.egg_lay_rate;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BIRD_TYPE, (Object)0);
    }

    protected boolean func_70692_ba() {
        return ConfigHandler.birds_despawn != false && this.field_70173_aa > 2400;
    }

    public void setBirdType(int birdID) {
        this.field_70180_af.func_187227_b(BIRD_TYPE, (Object)birdID);
    }

    public int getBirdType() {
        return (Integer)this.field_70180_af.func_187225_a(BIRD_TYPE);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("EggLayTime", this.timeUntilNextEgg);
        tagCompound.func_74768_a("Type", this.getBirdType());
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.timeUntilNextEgg = tagCompund.func_74762_e("EggLayTime");
        this.setBirdType(tagCompund.func_74762_e("Type"));
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.setBirdType(this.field_70170_p.field_73012_v.nextInt(this.noOfTypes));
        return livingdata;
    }

    public Item getEgg() {
        return this.eggType;
    }
}

