/*
 * Decompiled with CFR 0.152.
 */
package pavocado.exoticbirds.entity.Birds;

import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import pavocado.exoticbirds.entity.Birds.EntityBird;
import pavocado.exoticbirds.init.EnumBirdTypes;
import pavocado.exoticbirds.init.ExoticbirdsLootTables;
import pavocado.exoticbirds.init.ExoticbirdsSoundEvents;
import pavocado.exoticbirds.network.MessageCommenceWoodpeckerSounds;
import pavocado.exoticbirds.network.NetworkHandler;

public class EntityWoodpecker
extends EntityBird {
    private BlockPos spawnPosition;
    public boolean isPecking;
    private int timeUntilPeck;
    private int trillTime;
    private static final DataParameter<Boolean> HANGING = EntityDataManager.func_187226_a(EntityWoodpecker.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityWoodpecker(World worldIn) {
        super(worldIn, EnumBirdTypes.WOODPECKER.getBirdEgg(), EnumBirdTypes.WOODPECKER.getNumberOfTypes(), true, EnumBirdTypes.WOODPECKER.isGendered());
        this.func_70105_a(0.5f, 1.0f);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HANGING, (Object)true);
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.85f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(EnumBirdTypes.WOODPECKER.getMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.1);
    }

    protected SoundEvent func_184639_G() {
        if (!this.getHanging()) {
            return ExoticbirdsSoundEvents.ENTITY_WOODPECKER_AMBIENT;
        }
        return null;
    }

    public boolean getHanging() {
        return (Boolean)this.field_70180_af.func_187225_a(HANGING);
    }

    public void setHanging(boolean setStand) {
        this.field_70180_af.func_187227_b(HANGING, (Object)setStand);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getHanging()) {
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
            if (this.field_70170_p.field_72995_K) {
                --this.timeUntilPeck;
                if (this.timeUntilPeck <= 0) {
                    if (this.trillTime == 35) {
                        NetworkHandler.sendToServer(new MessageCommenceWoodpeckerSounds((Entity)this));
                    }
                    if (this.trillTime == 32) {
                        this.isPecking = true;
                    }
                    --this.trillTime;
                    if (this.trillTime <= 0) {
                        this.timeUntilPeck = 400 + this.field_70146_Z.nextInt(200);
                        this.trillTime = 35;
                        this.isPecking = false;
                    }
                }
            }
        }
    }

    public boolean checkforTree() {
        BlockPos blockpos = new BlockPos((Entity)this);
        BlockPos blockpos1 = blockpos.func_177978_c();
        BlockPos blockpos2 = blockpos.func_177974_f();
        BlockPos blockpos3 = blockpos.func_177968_d();
        BlockPos blockpos4 = blockpos.func_177976_e();
        BlockPos blockpos5 = blockpos.func_177977_b();
        return (this.field_70170_p.func_180495_p(blockpos1).func_185904_a() == Material.field_151575_d || this.field_70170_p.func_180495_p(blockpos2).func_185904_a() == Material.field_151575_d || this.field_70170_p.func_180495_p(blockpos3).func_185904_a() == Material.field_151575_d || this.field_70170_p.func_180495_p(blockpos4).func_185904_a() == Material.field_151575_d) && !this.field_70170_p.func_180495_p(blockpos5).func_185917_h();
    }

    public BlockPos treeLocation() {
        BlockPos blockpos = new BlockPos((Entity)this);
        BlockPos blockpos1 = blockpos.func_177978_c();
        BlockPos blockpos2 = blockpos.func_177974_f();
        BlockPos blockpos3 = blockpos.func_177968_d();
        BlockPos blockpos4 = blockpos.func_177976_e();
        BlockPos blockpos5 = blockpos.func_177977_b();
        if (this.field_70170_p.func_180495_p(blockpos1).func_185904_a() == Material.field_151575_d) {
            return blockpos1;
        }
        if (this.field_70170_p.func_180495_p(blockpos2).func_185904_a() == Material.field_151575_d) {
            return blockpos2;
        }
        if (this.field_70170_p.func_180495_p(blockpos3).func_185904_a() == Material.field_151575_d) {
            return blockpos3;
        }
        if (this.field_70170_p.func_180495_p(blockpos4).func_185904_a() == Material.field_151575_d) {
            return blockpos4;
        }
        return null;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        BlockPos blockpos = new BlockPos((Entity)this);
        BlockPos blockpos1 = blockpos.func_177978_c();
        BlockPos blockpos2 = blockpos.func_177974_f();
        BlockPos blockpos3 = blockpos.func_177968_d();
        BlockPos blockpos4 = blockpos.func_177976_e();
        if (this.getHanging()) {
            if (!this.checkforTree()) {
                this.setHanging(false);
                this.field_70170_p.func_180498_a((EntityPlayer)null, 1025, blockpos, 0);
            } else if (this.field_70170_p.func_72890_a((Entity)this, 3.0) != null) {
                this.setHanging(false);
                this.field_70170_p.func_180498_a((EntityPlayer)null, 1025, blockpos, 0);
            }
            if (this.treeLocation() != null) {
                this.func_70671_ap().func_75650_a((double)this.treeLocation().func_177958_n() + 0.5, (double)this.treeLocation().func_177956_o(), (double)this.treeLocation().func_177952_p() + 0.5, 10.0f, (float)this.func_70646_bf());
            }
        } else {
            if (!(this.spawnPosition == null || this.field_70170_p.func_175623_d(this.spawnPosition) && this.spawnPosition.func_177956_o() >= 1 && this.spawnPosition.func_177956_o() <= this.field_70170_p.func_175672_r(this.spawnPosition).func_177956_o() + 12)) {
                this.spawnPosition = null;
            }
            if (this.spawnPosition == null || this.field_70146_Z.nextInt(30) == 0 || this.spawnPosition.func_177954_c((double)((int)this.field_70165_t), (double)((int)this.field_70163_u), (double)((int)this.field_70161_v)) < 4.0) {
                this.spawnPosition = new BlockPos((int)this.field_70165_t + this.field_70146_Z.nextInt(7) - this.field_70146_Z.nextInt(7), (int)this.field_70163_u + this.field_70146_Z.nextInt(6) - 2, (int)this.field_70161_v + this.field_70146_Z.nextInt(7) - this.field_70146_Z.nextInt(7));
            }
            double d0 = (double)this.spawnPosition.func_177958_n() + 0.5 - this.field_70165_t;
            double d1 = (double)this.spawnPosition.func_177956_o() + 0.1 - this.field_70163_u;
            double d2 = (double)this.spawnPosition.func_177952_p() + 0.5 - this.field_70161_v;
            this.field_70159_w += (d0 * 0.5 - this.field_70159_w) * (double)0.1f * 0.6;
            this.field_70181_x += (d1 * (double)0.7f - this.field_70181_x) * (double)0.1f;
            this.field_70179_y += (d2 * 0.5 - this.field_70179_y) * (double)0.1f * 0.6;
            float f = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) - 90.0f;
            float f1 = MathHelper.func_76142_g((float)f);
            this.field_191988_bg = 0.5f;
            this.field_70177_z = f1;
            if (!this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(50) == 0 && this.checkforTree()) {
                this.setHanging(true);
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74757_a("Hanging", this.getHanging());
        tagCompound.func_74768_a("PeckingTime", this.timeUntilPeck);
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setHanging(tagCompund.func_74767_n("Hanging"));
        this.timeUntilPeck = tagCompund.func_74762_e("PeckingTime");
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        EntityWoodpecker entitywoodpecker = new EntityWoodpecker(this.field_70170_p);
        entitywoodpecker.setBirdType(this.getBirdType());
        return entitywoodpecker;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return ExoticbirdsLootTables.ENTITIES_WOODPECKER;
    }
}

