/*
 * Decompiled with CFR 0.152.
 */
package pavocado.exoticbirds.render;

import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import pavocado.exoticbirds.entity.Birds.EntityPelican;
import pavocado.exoticbirds.models.ModelPelican;
import pavocado.exoticbirds.render.RenderBird;
import pavocado.exoticbirds.render.layer.LayerPelicanRing;

public class RenderPelican
extends RenderBird<EntityPelican> {
    private static final ResourceLocation birdTexture1 = new ResourceLocation("exoticbirds:textures/entity/pelican/pelican_american.png");
    private static final ResourceLocation birdTexture2 = new ResourceLocation("exoticbirds:textures/entity/pelican/pelican_australian.png");

    public RenderPelican(RenderManager manager) {
        super(manager, new ModelPelican(), 0.4f);
        this.func_177094_a(new LayerPelicanRing(this));
    }

    protected float handleRotationFloat(EntityPelican livingBase, float partialTicks) {
        float f1 = livingBase.wingRotation + (livingBase.startRotation - livingBase.wingRotation) * partialTicks;
        float f2 = livingBase.groundOffset + (livingBase.destPos - livingBase.groundOffset) * partialTicks;
        return (MathHelper.func_76126_a((float)f1) + 1.0f) * f2;
    }

    protected ResourceLocation getEntityTexture(EntityPelican entity) {
        return this.getEntityTextureForId(entity.getBirdType());
    }

    @Override
    public ResourceLocation getEntityTextureForId(int birdId) {
        switch (birdId) {
            case 0: {
                return birdTexture1;
            }
            case 1: {
                return birdTexture2;
            }
        }
        return birdTexture1;
    }
}

