/*
 * Decompiled with CFR 0.152.
 */
package pavocado.exoticbirds.render;

import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import pavocado.exoticbirds.entity.Birds.EntityToucan;
import pavocado.exoticbirds.models.ModelToucan;
import pavocado.exoticbirds.render.RenderBird;

public class RenderToucan
extends RenderBird<EntityToucan> {
    private static final ResourceLocation birdTexture1 = new ResourceLocation("exoticbirds:textures/entity/toucan/toucan_keelbilled.png");
    private static final ResourceLocation birdTexture2 = new ResourceLocation("exoticbirds:textures/entity/toucan/toucan_toco.png");
    private static final ResourceLocation birdTexture3 = new ResourceLocation("exoticbirds:textures/entity/toucan/toucan_blackmandibled.png");

    public RenderToucan(RenderManager manager) {
        super(manager, new ModelToucan(), 0.2f);
    }

    protected float handleRotationFloat(EntityToucan livingBase, float partialTicks) {
        float f1 = livingBase.wingRotation + (livingBase.startRotation - livingBase.wingRotation) * partialTicks;
        float f2 = livingBase.groundOffset + (livingBase.destPos - livingBase.groundOffset) * partialTicks;
        return (MathHelper.func_76126_a((float)f1) + 1.0f) * f2;
    }

    protected ResourceLocation getEntityTexture(EntityToucan entity) {
        return this.getEntityTextureForId(entity.getBirdType());
    }

    @Override
    public ResourceLocation getEntityTextureForId(int birdId) {
        switch (birdId) {
            case 0: {
                return birdTexture1;
            }
            case 1: {
                return birdTexture2;
            }
            case 2: {
                return birdTexture3;
            }
        }
        return birdTexture1;
    }
}

