/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.packet.PacketSyncSettings;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.MagicDamage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public final class Settings {
    public static final String SPELLS_CATEGORY = "spells";
    public static final String RESISTANCES_CATEGORY = "resistances";
    public static final String CLIENT_CATEGORY = "client";
    public static final String COMMANDS_CATEGORY = "commands";
    public static final String WORLDGEN_CATEGORY = "worldgen";
    public static final String GAMEPLAY_CATEGORY = "gameplay";
    private Configuration config;
    public int towerRarity = 8;
    public int[] oreDimensions = new int[]{0};
    public int[] flowerDimensions = new int[]{0};
    public int[] towerDimensions = new int[]{0};
    public boolean generateLoot = true;
    public int spellBookDropChance = 3;
    public boolean teleportThroughUnbreakableBlocks = false;
    public boolean friendlyFire = true;
    public boolean telekineticDisarmament = true;
    public boolean minionRevengeTargeting = true;
    public ResourceLocation[] summonedCreatureTargetsWhitelist = new ResourceLocation[0];
    public ResourceLocation[] summonedCreatureTargetsBlacklist = new ResourceLocation[]{new ResourceLocation("creeper")};
    public ResourceLocation[] mindControlTargetsBlacklist = new ResourceLocation[0];
    public double playerDamageScale = 1.0;
    public double npcDamageScale = 1.0;
    public int[] evilWizardDimensions = new int[]{0};
    public double maxSpellCommandMultiplier = 20.0;
    public String castCommandName = "cast";
    public String discoverspellCommandName = "discoverspell";
    public String allyCommandName = "ally";
    public String alliesCommandName = "allies";
    public boolean discoveryMode = true;
    public boolean enableShiftScrolling = true;
    public boolean showSummonedCreatureNames = true;
    public GuiPosition spellHUDPosition = GuiPosition.BOTTOM_LEFT;

    void initConfig(FMLPreInitializationEvent event) {
        this.config = new Configuration(event.getSuggestedConfigurationFile());
        this.config.load();
        Wizardry.logger.info("Setting up main config");
        this.setupGeneralConfig();
        this.setupWorldgenConfig();
        this.setupClientConfig();
        this.setupCommandsConfig();
        this.config.save();
    }

    void initConfigExtras() {
        Wizardry.logger.info("Setting up spells config for " + Spell.getTotalSpellCount() + " spells");
        this.setupSpellsConfig();
        Wizardry.logger.info("Setting up resistances config");
        this.setupResistancesConfig();
        this.config.save();
    }

    void saveConfigChanges() {
        Wizardry.logger.info("Saving in-game config changes");
        this.setupGeneralConfig();
        this.setupWorldgenConfig();
        this.setupClientConfig();
        this.setupCommandsConfig();
        this.setupSpellsConfig();
        this.setupResistancesConfig();
        this.config.save();
    }

    public void sync(EntityPlayerMP player) {
        Wizardry.logger.info("Synchronising config settings for " + player.func_70005_c_());
        PacketSyncSettings.Message message = new PacketSyncSettings.Message(this);
        WizardryPacketHandler.net.sendTo((IMessage)message, player);
    }

    public ConfigCategory getConfigCategory(String name) {
        return this.config.getCategory(name);
    }

    private void setupSpellsConfig() {
        this.config.addCustomCategoryComment(SPELLS_CATEGORY, "Set a spell to false to disable it. Disabled spells will still have their associated spell book (mainly so the spell books don't all change) and can still be bound to wands, but cannot be cast in game, will not appear in any subsequently generated chests or wizard trades and will not drop from mobs. Disable a spell if it is causing problems, conflicts with another mod or creates an unintended exploit.");
        for (Spell spell : Spell.getSpells(Spell.allSpells)) {
            Property property = this.config.get(SPELLS_CATEGORY, spell.getRegistryName().toString(), true, I18n.func_74838_a((String)("spell." + spell.getUnlocalisedName() + ".desc")));
            property.setLanguageKey("spell." + spell.getUnlocalisedName());
            spell.setEnabled(property.getBoolean());
        }
    }

    private void setupGeneralConfig() {
        ArrayList<String> propOrder = new ArrayList<String>();
        this.config.addCustomCategoryComment(GAMEPLAY_CATEGORY, "Global settings that affect game mechanics. In multiplayer, the server/LAN host settings will apply. Please note that changing some of these settings may make the mod very difficult to play.");
        Property property = this.config.get(GAMEPLAY_CATEGORY, "discoveryMode", true, "For those who like a sense of mystery! When set to true, spells you haven't cast yet will be unreadable until you cast them (on a per-world basis). Has no effect when in creative mode. Spells of identification will be unobtainable in survival mode if this is false.");
        property.setLanguageKey("config.ebwizardry.discovery_mode");
        property.setRequiresWorldRestart(true);
        this.discoveryMode = property.getBoolean();
        propOrder.add(property.getName());
        property = this.config.get(GAMEPLAY_CATEGORY, "friendlyFire", true, "Whether to allow players to damage their designated allies using magic.");
        property.setLanguageKey("config.ebwizardry.friendly_fire");
        this.friendlyFire = property.getBoolean();
        propOrder.add(property.getName());
        property = this.config.get(GAMEPLAY_CATEGORY, "spellBookDropChance", 3, "The chance for mobs to drop a spell book when killed. The greater this number, the more often they will drop. Set to 0 to disable spell book drops. Set to 200 for guaranteed drops.", 0, 200);
        property.setLanguageKey("config.ebwizardry.spell_book_drop_chance");
        Wizardry.proxy.setToNumberSliderEntry(property);
        this.spellBookDropChance = property.getInt();
        propOrder.add(property.getName());
        property = this.config.get(GAMEPLAY_CATEGORY, "evilWizardDimensions", new int[]{0}, "List of dimension ids in which evil wizards can spawn.");
        property.setLanguageKey("config.ebwizardry.evil_wizard_dimensions");
        property.setRequiresMcRestart(true);
        this.evilWizardDimensions = property.getIntList();
        propOrder.add(property.getName());
        property = this.config.get(GAMEPLAY_CATEGORY, "playerDamageScaling", 1.0, "Global damage scaling factor for the damage dealt by players casting spells, relative to 1.", 0.0, 20.0);
        property.setLanguageKey("config.ebwizardry.player_damage_scaling");
        this.playerDamageScale = property.getDouble();
        propOrder.add(property.getName());
        property = this.config.get(GAMEPLAY_CATEGORY, "npcDamageScaling", 1.0, "Global damage scaling factor for the damage dealt by NPCs casting spells, relative to 1.", 0.0, 20.0);
        property.setLanguageKey("config.ebwizardry.npc_damage_scaling");
        this.npcDamageScale = property.getDouble();
        propOrder.add(property.getName());
        property = this.config.get(GAMEPLAY_CATEGORY, "minionRevengeTargeting", true, "Whether summoned creatures can revenge attack their owner if their owner attacks them.");
        property.setLanguageKey("config.ebwizardry.minion_revenge_targeting");
        property.setRequiresWorldRestart(false);
        this.minionRevengeTargeting = property.getBoolean();
        propOrder.add(property.getName());
        property = this.config.get(GAMEPLAY_CATEGORY, "summonedCreatureTargetsWhitelist", new String[0], "List of names of entities which summoned creatures and wizards are allowed to attack, in addition to the defaults. Add mod creatures to this list if you want summoned creatures to attack them and they aren't already doing so. Entity names are not case sensitive. For mod entities, prefix with the mod ID (e.g. ebwizardry:wizard).");
        property.setLanguageKey("config.ebwizardry.summoned_creature_targets_whitelist");
        property.setRequiresWorldRestart(true);
        this.summonedCreatureTargetsWhitelist = (ResourceLocation[])Arrays.stream(property.getStringList()).map(s -> new ResourceLocation(s.toLowerCase(Locale.ROOT).trim())).toArray(ResourceLocation[]::new);
        propOrder.add(property.getName());
        property = this.config.get(GAMEPLAY_CATEGORY, "summonedCreatureTargetsBlacklist", new String[]{"creeper"}, "List of names of entities which summoned creatures and wizards are specifically not allowed to attack, overriding the defaults and the whitelist. Add creatures to this list if allowing them to be attacked causes problems or is too destructive (removing creepers from this list is done at your own risk!). Entity names are not case sensitive. For mod entities, prefix with the mod ID (e.g. ebwizardry:wizard).");
        property.setLanguageKey("config.ebwizardry.summoned_creature_targets_blacklist");
        property.setRequiresWorldRestart(true);
        this.summonedCreatureTargetsBlacklist = (ResourceLocation[])Arrays.stream(property.getStringList()).map(s -> new ResourceLocation(s.toLowerCase(Locale.ROOT).trim())).toArray(ResourceLocation[]::new);
        propOrder.add(property.getName());
        property = this.config.get(GAMEPLAY_CATEGORY, "telekineticDisarmament", true, "Whether to allow players to disarm other players using the telekinesis spell. Set to false to prevent stealing of items.");
        property.setLanguageKey("config.ebwizardry.telekinetic_disarmament");
        this.telekineticDisarmament = property.getBoolean();
        propOrder.add(property.getName());
        property = this.config.get(GAMEPLAY_CATEGORY, "teleportThroughUnbreakableBlocks", false, "Whether players are allowed to teleport through unbreakable blocks (e.g. bedrock) using the phase step spell.");
        property.setLanguageKey("config.ebwizardry.teleport_through_unbreakable_blocks");
        this.teleportThroughUnbreakableBlocks = property.getBoolean();
        propOrder.add(property.getName());
        property = this.config.get(GAMEPLAY_CATEGORY, "mindControlTargetsBlacklist", new String[0], "List of names of entities which cannot be mind controlled, in addition to the defaults. Add creatures to this list if allowing them to be mind-controlled causes problems or could be exploited. Entity names are not case sensitive. For mod entities, prefix with the mod ID (e.g. ebwizardry:wizard).");
        property.setLanguageKey("config.ebwizardry.mind_control_targets_blacklist");
        property.setRequiresWorldRestart(true);
        this.mindControlTargetsBlacklist = (ResourceLocation[])Arrays.stream(property.getStringList()).map(s -> new ResourceLocation(s.toLowerCase(Locale.ROOT).trim())).toArray(ResourceLocation[]::new);
        propOrder.add(property.getName());
        this.config.setCategoryPropertyOrder(GAMEPLAY_CATEGORY, propOrder);
    }

    private void setupWorldgenConfig() {
        ArrayList<String> propOrder = new ArrayList<String>();
        this.config.addCustomCategoryComment(WORLDGEN_CATEGORY, "Settings that affect world generation. In multiplayer, the server/LAN host settings will apply.");
        Property property = this.config.get(WORLDGEN_CATEGORY, "towerRarity", 8, "Rarity of wizard towers. Higher numbers are rarer. Set to 0 to disable wizard towers completely.", 0, 50);
        property.setLanguageKey("config.ebwizardry.tower_rarity");
        property.setRequiresWorldRestart(true);
        Wizardry.proxy.setToNumberSliderEntry(property);
        this.towerRarity = property.getInt();
        propOrder.add(property.getName());
        property = this.config.get(WORLDGEN_CATEGORY, "towerDimensions", new int[]{0}, "List of dimension ids in which wizard towers will generate.");
        property.setLanguageKey("config.ebwizardry.tower_dimensions");
        property.setRequiresWorldRestart(true);
        this.towerDimensions = property.getIntList();
        propOrder.add(property.getName());
        property = this.config.get(WORLDGEN_CATEGORY, "oreDimensions", new int[]{0}, "List of dimension ids in which crystal ore will generate. Note that removing the overworld (id 0) from this list will make the mod VERY difficult to play!");
        property.setLanguageKey("config.ebwizardry.ore_dimensions");
        property.setRequiresWorldRestart(true);
        this.oreDimensions = property.getIntList();
        propOrder.add(property.getName());
        property = this.config.get(WORLDGEN_CATEGORY, "flowerDimensions", new int[]{0}, "List of dimension ids in which crystal flowers will generate.");
        property.setLanguageKey("config.ebwizardry.flower_dimensions");
        property.setRequiresWorldRestart(true);
        this.flowerDimensions = property.getIntList();
        propOrder.add(property.getName());
        property = this.config.get(WORLDGEN_CATEGORY, "generateLoot", true, "Whether to inject wizardry loot (as specified in loot_tables/chests/dungeon_additions.json) into the loot tables for vanilla dungeon chests.");
        property.setLanguageKey("config.ebwizardry.generate_loot");
        property.setRequiresWorldRestart(true);
        this.generateLoot = property.getBoolean();
        propOrder.add(property.getName());
        this.config.setCategoryPropertyOrder(WORLDGEN_CATEGORY, propOrder);
    }

    private void setupClientConfig() {
        ArrayList<String> propOrder = new ArrayList<String>();
        this.config.addCustomCategoryComment(CLIENT_CATEGORY, "Client-side settings that only affect the local minecraft game. If this file is on a dedicated server, these settings will have no effect; in multiplayer, each player obeys their own settings.");
        Property property = this.config.get(CLIENT_CATEGORY, "enableShiftScrolling", true, "Whether you can switch between spells on a wand by scrolling with the mouse wheel while sneaking. Note that this will only affect you; other players connected to the same server obey their own settings.");
        property.setLanguageKey("config.ebwizardry.enable_shift_scrolling");
        property.setRequiresWorldRestart(false);
        this.enableShiftScrolling = property.getBoolean();
        propOrder.add(property.getName());
        property = this.config.get(CLIENT_CATEGORY, "spellHUDPosition", GuiPosition.BOTTOM_LEFT.name, "The position of the spell HUD.", GuiPosition.names);
        property.setLanguageKey("config.ebwizardry.spell_hud_position");
        this.spellHUDPosition = GuiPosition.fromName(property.getString());
        propOrder.add(property.getName());
        property = this.config.get(CLIENT_CATEGORY, "showSummonedCreatureNames", true, "Whether to show summoned creatures' names and owners above their heads.");
        property.setLanguageKey("config.ebwizardry.show_summoned_creature_names");
        this.showSummonedCreatureNames = property.getBoolean();
        propOrder.add(property.getName());
        this.config.setCategoryPropertyOrder(CLIENT_CATEGORY, propOrder);
    }

    private void setupCommandsConfig() {
        ArrayList<String> propOrder = new ArrayList<String>();
        this.config.addCustomCategoryComment(COMMANDS_CATEGORY, "Settings for the commands added by Wizardry. In multiplayer, the server/LAN host settings will apply.");
        Property property = this.config.get(COMMANDS_CATEGORY, "castCommandMultiplierLimit", 20.0, "Upper limit for the multipliers passed into the /cast command. This is here to stop players from accidentally breaking a world/server. Large blast mutipliers can cause extreme lag - you have been warned!", 1.0, 255.0);
        property.setLanguageKey("config.ebwizardry.cast_command_multiplier_limit");
        this.maxSpellCommandMultiplier = property.getDouble();
        propOrder.add(property.getName());
        property = this.config.get(COMMANDS_CATEGORY, "castCommandName", "cast", "The name of the /cast command. This is what you type directly after the /; for example if this was set to 'magic' then instead of typing /cast you would type /magic instead.");
        property.setLanguageKey("config.ebwizardry.cast_command_name");
        property.setRequiresWorldRestart(true);
        this.castCommandName = property.getString();
        propOrder.add(property.getName());
        property = this.config.get(COMMANDS_CATEGORY, "discoverspellCommandName", "discoverspell", "The name of the /discoverspell command. This is what you type directly after the /; for example if this was set to 'magic' then instead of typing /discoverspell you would type /magic instead.");
        property.setLanguageKey("config.ebwizardry.discoverspell_command_name");
        property.setRequiresWorldRestart(true);
        this.discoverspellCommandName = property.getString();
        propOrder.add(property.getName());
        property = this.config.get(COMMANDS_CATEGORY, "allyCommandName", "ally", "The name of the /ally command. This is what you type directly after the /; for example if this was set to 'magic' then instead of typing /ally you would type /magic instead.");
        property.setLanguageKey("config.ebwizardry.ally_command_name");
        property.setRequiresWorldRestart(true);
        this.allyCommandName = property.getString();
        propOrder.add(property.getName());
        property = this.config.get(COMMANDS_CATEGORY, "alliesCommandName", "allies", "The name of the /allies command. This is what you type directly after the /; for example if this was set to 'magic' then instead of typing /allies you would type /magic instead.");
        property.setLanguageKey("config.ebwizardry.allies_command_name");
        property.setRequiresWorldRestart(true);
        this.alliesCommandName = property.getString();
        propOrder.add(property.getName());
        this.config.setCategoryPropertyOrder(COMMANDS_CATEGORY, propOrder);
    }

    private void setupResistancesConfig() {
        int i;
        ArrayList<String> propOrder = new ArrayList<String>();
        this.config.addCustomCategoryComment(RESISTANCES_CATEGORY, "Settings which allow entities to be made immune to certain types of magic. In multiplayer, the server/LAN host settings will apply.");
        Property property = this.config.get(RESISTANCES_CATEGORY, "mobsImmuneToFire", new String[0], "List of names of entities that are immune to fire, in addition to the defaults. Add mod creatures to this list if you want them to be immune to fire magic and they aren't already. Entity names are not case sensitive. For mod entities, prefix with the mod ID (e.g. ebwizardry:wizard).");
        property.setLanguageKey("config.ebwizardry.mobs_immune_to_fire");
        property.setRequiresMcRestart(true);
        for (i = 0; i < property.getStringList().length; ++i) {
            property.getStringList()[i] = property.getStringList()[i].toLowerCase(Locale.ROOT).trim();
            MagicDamage.addEntityImmunity(EntityList.getClass((ResourceLocation)new ResourceLocation(property.getStringList()[i])), MagicDamage.DamageType.FIRE);
        }
        propOrder.add(property.getName());
        property = this.config.get(RESISTANCES_CATEGORY, "mobsImmuneToIce", new String[0], "List of names of entities that are immune to ice, in addition to the defaults. Add mod creatures to this list if you want them to be immune to ice magic and they aren't already. Entity names are not case sensitive. For mod entities, prefix with the mod ID (e.g. ebwizardry:wizard).");
        property.setLanguageKey("config.ebwizardry.mobs_immune_to_ice");
        property.setRequiresMcRestart(true);
        for (i = 0; i < property.getStringList().length; ++i) {
            property.getStringList()[i] = property.getStringList()[i].toLowerCase(Locale.ROOT).trim();
            MagicDamage.addEntityImmunity(EntityList.getClass((ResourceLocation)new ResourceLocation(property.getStringList()[i])), MagicDamage.DamageType.FROST);
        }
        propOrder.add(property.getName());
        property = this.config.get(RESISTANCES_CATEGORY, "mobsImmuneToLightning", new String[0], "List of names of entities that are immune to lightning, in addition to the defaults. Add mod creatures to this list if you want them to be immune to lightning magic and they aren't already. Entity names are not case sensitive. For mod entities, prefix with the mod ID (e.g. ebwizardry:wizard).");
        property.setLanguageKey("config.ebwizardry.mobs_immune_to_lightning");
        property.setRequiresMcRestart(true);
        for (i = 0; i < property.getStringList().length; ++i) {
            property.getStringList()[i] = property.getStringList()[i].toLowerCase(Locale.ROOT).trim();
            MagicDamage.addEntityImmunity(EntityList.getClass((ResourceLocation)new ResourceLocation(property.getStringList()[i])), MagicDamage.DamageType.SHOCK);
        }
        propOrder.add(property.getName());
        property = this.config.get(RESISTANCES_CATEGORY, "mobsImmuneToWither", new String[0], "List of names of entities that are immune to wither effects, in addition to the defaults. Add mod creatures to this list if you want them to be immune to withering magic and they aren't already. Entity names are not case sensitive. For mod entities, prefix with the mod ID (e.g. ebwizardry:wizard).");
        property.setLanguageKey("config.ebwizardry.mobs_immune_to_wither");
        property.setRequiresMcRestart(true);
        for (i = 0; i < property.getStringList().length; ++i) {
            property.getStringList()[i] = property.getStringList()[i].toLowerCase(Locale.ROOT).trim();
            MagicDamage.addEntityImmunity(EntityList.getClass((ResourceLocation)new ResourceLocation(property.getStringList()[i])), MagicDamage.DamageType.WITHER);
        }
        propOrder.add(property.getName());
        property = this.config.get(RESISTANCES_CATEGORY, "mobsImmuneToPoison", new String[0], "List of names of entities that are immune to poison, in addition to the defaults. Add mod creatures to this list if you want them to be immune to poison magic and they aren't already. Entity names are not case sensitive. For mod entities, prefix with the mod ID (e.g. ebwizardry:wizard).");
        property.setLanguageKey("config.ebwizardry.mobs_immune_to_poison");
        property.setRequiresMcRestart(true);
        for (i = 0; i < property.getStringList().length; ++i) {
            property.getStringList()[i] = property.getStringList()[i].toLowerCase(Locale.ROOT).trim();
            MagicDamage.addEntityImmunity(EntityList.getClass((ResourceLocation)new ResourceLocation(property.getStringList()[i])), MagicDamage.DamageType.POISON);
        }
        propOrder.add(property.getName());
        this.config.setCategoryPropertyOrder(RESISTANCES_CATEGORY, propOrder);
    }

    public static enum GuiPosition {
        BOTTOM_LEFT("Bottom left"),
        TOP_LEFT("Top left"),
        TOP_RIGHT("Top right"),
        BOTTOM_RIGHT("Bottom right");

        public static final String[] names;
        public final String name;

        private GuiPosition(String name) {
            this.name = name;
        }

        public static GuiPosition fromName(String name) {
            for (GuiPosition position : GuiPosition.values()) {
                if (!position.name.equalsIgnoreCase(name)) continue;
                return position;
            }
            Wizardry.logger.info("Invalid string for the spell HUD position. Using default (bottom left) instead.");
            return BOTTOM_LEFT;
        }

        static {
            names = new String[GuiPosition.values().length];
            for (GuiPosition position : GuiPosition.values()) {
                GuiPosition.names[position.ordinal()] = position.name;
            }
        }
    }
}

