/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry;

import electroblob.wizardry.constants.Element;
import electroblob.wizardry.enchantment.Imbuement;
import electroblob.wizardry.entity.EntityShield;
import electroblob.wizardry.entity.living.ISummonedCreature;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.packet.PacketCastContinuousSpell;
import electroblob.wizardry.packet.PacketPlayerSync;
import electroblob.wizardry.packet.PacketTransportation;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryAdvancementTriggers;
import electroblob.wizardry.spell.None;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber
public class WizardData
implements INBTSerializable<NBTTagCompound> {
    @CapabilityInject(value=WizardData.class)
    private static final Capability<WizardData> WIZARD_DATA_CAPABILITY = null;
    private final EntityPlayer player;
    private Map<Imbuement, Integer> imbuementDurations;
    public boolean hasSpiritWolf;
    public boolean hasSpiritHorse;
    private Spell currentlyCasting;
    private int castingTick;
    private SpellModifiers spellModifiers;
    private BlockPos stoneCircleLocation;
    private int stoneCircleDimension;
    private int tpCountdown;
    private BlockPos clairvoyanceLocation;
    private int clairvoyanceDimension;
    public EntityShield shield;
    public WeakReference<ISummonedCreature> selectedMinion;
    public Set<Spell> spellsDiscovered;
    private Set<UUID> allies;
    public Set<String> allyNames;
    private Set<UUID> soulboundCreatures;

    public WizardData() {
        this(null);
    }

    public WizardData(EntityPlayer player) {
        this.player = player;
        this.imbuementDurations = new HashMap<Imbuement, Integer>();
        this.spellsDiscovered = new HashSet<Spell>();
        this.spellsDiscovered.add(Spells.magic_missile);
        this.hasSpiritWolf = false;
        this.hasSpiritHorse = false;
        this.currentlyCasting = Spells.none;
        this.spellModifiers = new SpellModifiers();
        this.castingTick = 0;
        this.stoneCircleDimension = 0;
        this.clairvoyanceDimension = 0;
        this.setTpCountdown(0);
        this.allies = new HashSet<UUID>();
        this.allyNames = new HashSet<String>();
        this.soulboundCreatures = new HashSet<UUID>();
    }

    public boolean hasSpellBeenDiscovered(Spell spell) {
        return this.spellsDiscovered.contains(spell) || spell instanceof None;
    }

    public boolean discoverSpell(Spell spell) {
        if (this.spellsDiscovered == null) {
            this.spellsDiscovered = new HashSet<Spell>();
        }
        if (spell instanceof None) {
            return false;
        }
        if (!this.spellsDiscovered.add(spell)) {
            return false;
        }
        if (this.spellsDiscovered.containsAll(Spell.getSpells(Spell::isEnabled))) {
            WizardryAdvancementTriggers.all_spells.triggerFor(this.player);
        }
        for (Element element : Element.values()) {
            if (element == Element.MAGIC || !this.spellsDiscovered.containsAll(Spell.getSpells(new Spell.TierElementFilter(null, element)))) continue;
            WizardryAdvancementTriggers.element_master.triggerFor(this.player);
        }
        return true;
    }

    public void setStoneCircleLocation(BlockPos pos, int dimensionID) {
        this.stoneCircleLocation = pos;
        this.stoneCircleDimension = dimensionID;
    }

    public BlockPos getStoneCircleLocation() {
        return this.stoneCircleLocation;
    }

    public int getStoneCircleDimension() {
        return this.stoneCircleDimension;
    }

    public int getTpCountdown() {
        return this.tpCountdown;
    }

    public void setTpCountdown(int tpCountdown) {
        this.tpCountdown = tpCountdown;
    }

    public void setClairvoyancePoint(BlockPos pos, int dimensionID) {
        this.clairvoyanceLocation = pos;
        this.clairvoyanceDimension = dimensionID;
    }

    public BlockPos getClairvoyanceLocation() {
        return this.clairvoyanceLocation;
    }

    public int getClairvoyanceDimension() {
        return this.clairvoyanceDimension;
    }

    public void setImbuementDuration(Enchantment enchantment, int duration) {
        if (!(enchantment instanceof Imbuement)) {
            throw new IllegalArgumentException("Attempted to set an imbuement duration for something that isn't an Imbuement! (This exception has been thrown now to prevent a ClassCastException from occurring later.)");
        }
        this.imbuementDurations.put((Imbuement)enchantment, duration);
    }

    public int getImbuementDuration(Enchantment enchantment) {
        Integer i = this.imbuementDurations.get(enchantment);
        return i == null ? 0 : i;
    }

    private void updateImbuedItems() {
        HashSet<Imbuement> activeImbuements = new HashSet<Imbuement>();
        for (ItemStack stack : this.player.field_71071_by.field_70462_a) {
            if (!stack.func_77948_v()) continue;
            NBTTagList enchantmentList = stack.func_77973_b() == Items.field_151134_bR ? ItemEnchantedBook.func_92110_g((ItemStack)stack) : stack.func_77986_q();
            Iterator iterator = enchantmentList.iterator();
            while (iterator.hasNext()) {
                NBTTagCompound enchantmentTag = (NBTTagCompound)iterator.next();
                Enchantment enchantment = Enchantment.func_185262_c((int)enchantmentTag.func_74765_d("id"));
                if (!(enchantment instanceof Imbuement)) continue;
                int duration = this.getImbuementDuration(enchantment);
                if (duration > 0) {
                    this.imbuementDurations.put((Imbuement)enchantment, duration - 1);
                    activeImbuements.add((Imbuement)enchantment);
                    continue;
                }
                iterator.remove();
            }
        }
        this.imbuementDurations.keySet().retainAll(activeImbuements);
    }

    public boolean toggleAlly(EntityPlayer player) {
        if (this.isPlayerAlly(player)) {
            this.allies.remove(player.func_110124_au());
            this.allyNames.remove(player.func_70005_c_());
            return false;
        }
        this.allies.add(player.func_110124_au());
        this.allyNames.add(player.func_70005_c_());
        return true;
    }

    public boolean isPlayerAlly(EntityPlayer player) {
        return this.allies.contains(player.func_110124_au()) || this.player.func_184191_r((Entity)player);
    }

    public boolean soulbind(EntityLivingBase target) {
        return this.soulboundCreatures.add(target.func_110124_au());
    }

    public boolean isCreatureSoulbound(EntityPlayer target) {
        return this.soulboundCreatures.contains(target.func_110124_au());
    }

    public void damageAllSoulboundCreatures(float damage) {
        Iterator<UUID> iterator = this.soulboundCreatures.iterator();
        while (iterator.hasNext()) {
            Entity entity = WizardryUtilities.getEntityByUUID(this.player.field_70170_p, iterator.next());
            if (entity == null) {
                iterator.remove();
            }
            if (!(entity instanceof EntityLivingBase) || !entity.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)this.player, MagicDamage.DamageType.MAGIC, true), damage)) continue;
            this.player.func_184185_a(SoundEvents.field_187851_gB, 1.0f, this.player.field_70170_p.field_73012_v.nextFloat() * 0.2f + 1.0f);
        }
    }

    public void startCastingContinuousSpell(Spell spell, SpellModifiers modifiers) {
        this.currentlyCasting = spell;
        this.spellModifiers = modifiers;
        if (!this.player.field_70170_p.field_72995_K) {
            PacketCastContinuousSpell.Message message = new PacketCastContinuousSpell.Message(this.player.func_145782_y(), spell.id(), this.spellModifiers);
            WizardryPacketHandler.net.sendToDimension((IMessage)message, this.player.field_70170_p.field_73011_w.getDimension());
        }
    }

    public void stopCastingContinuousSpell() {
        this.currentlyCasting = Spells.none;
        this.castingTick = 0;
        this.spellModifiers.reset();
        if (!this.player.field_70170_p.field_72995_K) {
            PacketCastContinuousSpell.Message message = new PacketCastContinuousSpell.Message(this.player.func_145782_y(), Spells.none.id(), this.spellModifiers);
            WizardryPacketHandler.net.sendToDimension((IMessage)message, this.player.field_70170_p.field_73011_w.getDimension());
        }
    }

    public void updateContinuousSpellCasting() {
        if (this.currentlyCasting != null && this.currentlyCasting.isContinuous) {
            if (MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Tick((EntityLivingBase)this.player, this.currentlyCasting, this.spellModifiers, SpellCastEvent.Source.COMMAND, this.castingTick))) {
                this.stopCastingContinuousSpell();
                return;
            }
            if (this.currentlyCasting.cast(this.player.field_70170_p, this.player, EnumHand.MAIN_HAND, this.castingTick, this.spellModifiers) && this.castingTick == 0) {
                MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post((EntityLivingBase)this.player, this.currentlyCasting, this.spellModifiers, SpellCastEvent.Source.COMMAND));
            }
            ++this.castingTick;
        } else {
            this.castingTick = 0;
        }
    }

    public boolean isCasting() {
        return this.currentlyCasting != null && this.currentlyCasting != Spells.none;
    }

    public Spell currentlyCasting() {
        return this.currentlyCasting;
    }

    private void update() {
        if (this.selectedMinion != null && this.selectedMinion.get() == null) {
            this.selectedMinion = null;
        }
        this.updateImbuedItems();
        if (!this.player.field_70170_p.field_72995_K) {
            if (this.getTpCountdown() == 1) {
                this.player.func_70634_a((double)this.stoneCircleLocation.func_177958_n() + 0.5, (double)this.stoneCircleLocation.func_177956_o(), (double)this.stoneCircleLocation.func_177952_p() + 0.5);
                this.player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 50, 0));
                PacketTransportation.Message msg = new PacketTransportation.Message(this.player.func_145782_y());
                WizardryPacketHandler.net.sendToDimension((IMessage)msg, this.player.field_70170_p.field_73011_w.getDimension());
            }
            if (this.getTpCountdown() > 0) {
                this.setTpCountdown(this.getTpCountdown() - 1);
            }
        }
        this.updateContinuousSpellCasting();
    }

    public static final WizardData get(EntityPlayer player) {
        return (WizardData)player.getCapability(WIZARD_DATA_CAPABILITY, null);
    }

    public void copyFrom(WizardData data, boolean respawn) {
        this.hasSpiritHorse = data.hasSpiritHorse;
        this.hasSpiritWolf = data.hasSpiritWolf;
        this.allies = data.allies;
        this.allyNames = data.allyNames;
        this.clairvoyanceDimension = data.clairvoyanceDimension;
        this.clairvoyanceLocation = data.clairvoyanceLocation;
        this.selectedMinion = data.selectedMinion;
        if (!respawn) {
            this.soulboundCreatures = data.soulboundCreatures;
        }
        this.spellsDiscovered = data.spellsDiscovered;
        this.stoneCircleDimension = data.stoneCircleDimension;
        this.stoneCircleLocation = data.stoneCircleLocation;
    }

    public void sync() {
        if (this.player instanceof EntityPlayerMP) {
            int id = -1;
            if (this.selectedMinion != null && this.selectedMinion.get() instanceof Entity) {
                id = ((Entity)this.selectedMinion.get()).func_145782_y();
            }
            PacketPlayerSync.Message msg = new PacketPlayerSync.Message(this.spellsDiscovered, id);
            WizardryPacketHandler.net.sendTo((IMessage)msg, (EntityPlayerMP)this.player);
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound properties = new NBTTagCompound();
        properties.func_74782_a("imbuements", (NBTBase)WizardryUtilities.mapToNBT(this.imbuementDurations, imbuement -> new NBTTagInt(Enchantment.func_185258_b((Enchantment)((Enchantment)imbuement))), NBTTagInt::new));
        properties.func_74757_a("hasSpiritWolf", this.hasSpiritWolf);
        properties.func_74757_a("hasSpiritHorse", this.hasSpiritHorse);
        if (this.stoneCircleLocation != null) {
            properties.func_74772_a("stoneCircleLocation", this.stoneCircleLocation.func_177986_g());
        }
        properties.func_74768_a("stoneCircleDimension", this.stoneCircleDimension);
        properties.func_74768_a("tpCountdown", this.tpCountdown);
        if (this.clairvoyanceLocation != null) {
            properties.func_74772_a("clairvoyanceLocation", this.clairvoyanceLocation.func_177986_g());
        }
        properties.func_74768_a("clairvoyanceDimension", this.getClairvoyanceDimension());
        properties.func_74782_a("allies", (NBTBase)WizardryUtilities.listToNBT(this.allies, WizardryUtilities::UUIDtoTagCompound));
        properties.func_74782_a("allyNames", (NBTBase)WizardryUtilities.listToNBT(this.allyNames, NBTTagString::new));
        properties.func_74782_a("soulboundCreatures", (NBTBase)WizardryUtilities.listToNBT(this.soulboundCreatures, WizardryUtilities::UUIDtoTagCompound));
        int[] spells = new int[this.spellsDiscovered.size()];
        int i = 0;
        for (Spell spell : this.spellsDiscovered) {
            spells[i] = spell.id();
            ++i;
        }
        properties.func_74783_a("discoveredSpells", spells);
        return properties;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt != null) {
            this.imbuementDurations = WizardryUtilities.NBTToMap(nbt.func_150295_c("imbuements", 10), tag -> (Imbuement)Enchantment.func_185262_c((int)tag.func_150287_d()), NBTTagInt::func_150287_d);
            this.hasSpiritWolf = nbt.func_74767_n("hasSpiritWolf");
            this.hasSpiritHorse = nbt.func_74767_n("hasSpiritHorse");
            this.stoneCircleLocation = BlockPos.func_177969_a((long)nbt.func_74763_f("stoneCircleLocation"));
            this.stoneCircleDimension = nbt.func_74762_e("stoneCircleDimension");
            this.tpCountdown = nbt.func_74762_e("tpCountdown");
            this.clairvoyanceLocation = BlockPos.func_177969_a((long)nbt.func_74763_f("clairvoyanceLocation"));
            this.clairvoyanceDimension = nbt.func_74762_e("clairvoyanceDimension");
            this.allies = new HashSet<UUID>(WizardryUtilities.NBTToList(nbt.func_150295_c("allies", 10), WizardryUtilities::tagCompoundToUUID));
            this.allyNames = new HashSet<String>(WizardryUtilities.NBTToList(nbt.func_150295_c("allyNames", 8), NBTTagString::func_150285_a_));
            this.soulboundCreatures = new HashSet<UUID>(WizardryUtilities.NBTToList(nbt.func_150295_c("soulboundCreatures", 10), WizardryUtilities::tagCompoundToUUID));
            this.spellsDiscovered = new HashSet<Spell>();
            for (int id : nbt.func_74759_k("discoveredSpells")) {
                this.spellsDiscovered.add(Spell.get(id));
            }
        }
    }

    @SubscribeEvent
    public static void onCapabilityLoad(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(new ResourceLocation("ebwizardry", "WizardData"), (ICapabilityProvider)new Provider((EntityPlayer)event.getObject()));
        }
    }

    @SubscribeEvent
    public static void onPlayerCloneEvent(PlayerEvent.Clone event) {
        WizardData newData = WizardData.get(event.getEntityPlayer());
        WizardData oldData = WizardData.get(event.getOriginal());
        newData.copyFrom(oldData, event.isWasDeath());
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        WizardData data;
        if (!event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof EntityPlayerMP && (data = WizardData.get((EntityPlayer)event.getEntity())) != null) {
            data.sync();
        }
    }

    @SubscribeEvent
    public static void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        EntityPlayer player;
        if (event.getEntityLiving() instanceof EntityPlayer && WizardData.get(player = (EntityPlayer)event.getEntityLiving()) != null) {
            WizardData.get(player).update();
        }
    }

    public static class Provider
    implements ICapabilitySerializable<NBTTagCompound> {
        private final WizardData data;

        public Provider(EntityPlayer player) {
            this.data = new WizardData(player);
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == WIZARD_DATA_CAPABILITY;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (capability == WIZARD_DATA_CAPABILITY) {
                return (T)WIZARD_DATA_CAPABILITY.cast((Object)this.data);
            }
            return null;
        }

        public NBTTagCompound serializeNBT() {
            return this.data.serializeNBT();
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.data.deserializeNBT(nbt);
        }
    }
}

