/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry;

import electroblob.wizardry.CommonProxy;
import electroblob.wizardry.Settings;
import electroblob.wizardry.WizardData;
import electroblob.wizardry.WizardryGuiHandler;
import electroblob.wizardry.WizardryWorldGenerator;
import electroblob.wizardry.command.CommandCastSpell;
import electroblob.wizardry.command.CommandDiscoverSpell;
import electroblob.wizardry.command.CommandSetAlly;
import electroblob.wizardry.command.CommandViewAllies;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.registry.WizardryAdvancementTriggers;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryRegistry;
import electroblob.wizardry.registry.WizardryTabs;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;

@Mod(modid="ebwizardry", name="Electroblob's Wizardry", version="4.1.4", guiFactory="electroblob.wizardry.WizardryGuiFactory", acceptedMinecraftVersions="[1.12.2]")
public class Wizardry {
    public static final String MODID = "ebwizardry";
    public static final String NAME = "Electroblob's Wizardry";
    public static final String VERSION = "4.1.4";
    public static final Settings settings = new Settings();
    public static Logger logger;
    WizardryWorldGenerator generator = new WizardryWorldGenerator();
    @Mod.Instance(value="ebwizardry")
    public static Wizardry instance;
    @SidedProxy(clientSide="electroblob.wizardry.client.ClientProxy", serverSide="electroblob.wizardry.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        settings.initConfig(event);
        CapabilityManager.INSTANCE.register(WizardData.class, (Capability.IStorage)new Capability.IStorage<WizardData>(){

            public NBTBase writeNBT(Capability<WizardData> capability, WizardData instance, EnumFacing side) {
                return null;
            }

            public void readNBT(Capability<WizardData> capability, WizardData instance, EnumFacing side, NBTBase nbt) {
            }
        }, WizardData::new);
        WizardryRegistry.registerTileEntities();
        WizardryRegistry.registerEntities();
        WizardryRegistry.registerLoot();
        WizardryAdvancementTriggers.register();
        proxy.registerRenderers();
        proxy.registerKeyBindings();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        settings.initConfigExtras();
        GameRegistry.registerWorldGenerator((IWorldGenerator)this.generator, (int)0);
        MinecraftForge.EVENT_BUS.register((Object)instance);
        proxy.registerSpellHUD();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new WizardryGuiHandler());
        WizardryPacketHandler.initPackets();
        proxy.initGuiBits();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.initialiseLayers();
        WizardryTabs.sort();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandCastSpell());
        event.registerServerCommand((ICommand)new CommandSetAlly());
        event.registerServerCommand((ICommand)new CommandViewAllies());
        event.registerServerCommand((ICommand)new CommandDiscoverSpell());
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MODID)) {
            settings.saveConfigChanges();
        }
    }

    @SubscribeEvent
    public static void onMissingMappingEvent(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            if (!mapping.key.func_110624_b().equals(MODID)) continue;
            Item replacement = null;
            switch (mapping.key.func_110623_a()) {
                case "wand_basic": {
                    replacement = WizardryItems.magic_wand;
                    break;
                }
                case "wand_basic_fire": {
                    replacement = WizardryItems.basic_fire_wand;
                    break;
                }
                case "wand_basic_ice": {
                    replacement = WizardryItems.basic_ice_wand;
                    break;
                }
                case "wand_basic_lightning": {
                    replacement = WizardryItems.basic_lightning_wand;
                    break;
                }
                case "wand_basic_necromancy": {
                    replacement = WizardryItems.basic_necromancy_wand;
                    break;
                }
                case "wand_basic_earth": {
                    replacement = WizardryItems.basic_earth_wand;
                    break;
                }
                case "wand_basic_sorcery": {
                    replacement = WizardryItems.basic_sorcery_wand;
                    break;
                }
                case "wand_basic_healing": {
                    replacement = WizardryItems.basic_healing_wand;
                    break;
                }
                case "wand_apprentice": {
                    replacement = WizardryItems.apprentice_wand;
                    break;
                }
                case "wand_apprentice_fire": {
                    replacement = WizardryItems.apprentice_fire_wand;
                    break;
                }
                case "wand_apprentice_ice": {
                    replacement = WizardryItems.apprentice_ice_wand;
                    break;
                }
                case "wand_apprentice_lightning": {
                    replacement = WizardryItems.apprentice_lightning_wand;
                    break;
                }
                case "wand_apprentice_necromancy": {
                    replacement = WizardryItems.apprentice_necromancy_wand;
                    break;
                }
                case "wand_apprentice_earth": {
                    replacement = WizardryItems.apprentice_earth_wand;
                    break;
                }
                case "wand_apprentice_sorcery": {
                    replacement = WizardryItems.apprentice_sorcery_wand;
                    break;
                }
                case "wand_apprentice_healing": {
                    replacement = WizardryItems.apprentice_healing_wand;
                    break;
                }
                case "wand_advanced": {
                    replacement = WizardryItems.advanced_wand;
                    break;
                }
                case "wand_advanced_fire": {
                    replacement = WizardryItems.advanced_fire_wand;
                    break;
                }
                case "wand_advanced_ice": {
                    replacement = WizardryItems.advanced_ice_wand;
                    break;
                }
                case "wand_advanced_lightning": {
                    replacement = WizardryItems.advanced_lightning_wand;
                    break;
                }
                case "wand_advanced_necromancy": {
                    replacement = WizardryItems.advanced_necromancy_wand;
                    break;
                }
                case "wand_advanced_earth": {
                    replacement = WizardryItems.advanced_earth_wand;
                    break;
                }
                case "wand_advanced_sorcery": {
                    replacement = WizardryItems.advanced_sorcery_wand;
                    break;
                }
                case "wand_advanced_healing": {
                    replacement = WizardryItems.advanced_healing_wand;
                    break;
                }
                case "wand_master": {
                    replacement = WizardryItems.master_wand;
                    break;
                }
                case "wand_master_fire": {
                    replacement = WizardryItems.master_fire_wand;
                    break;
                }
                case "wand_master_ice": {
                    replacement = WizardryItems.master_ice_wand;
                    break;
                }
                case "wand_master_lightning": {
                    replacement = WizardryItems.master_lightning_wand;
                    break;
                }
                case "wand_master_necromancy": {
                    replacement = WizardryItems.master_necromancy_wand;
                    break;
                }
                case "wand_master_earth": {
                    replacement = WizardryItems.master_earth_wand;
                    break;
                }
                case "wand_master_sorcery": {
                    replacement = WizardryItems.master_sorcery_wand;
                    break;
                }
                case "wand_master_healing": {
                    replacement = WizardryItems.master_healing_wand;
                    break;
                }
                case "upgrade_storage": {
                    replacement = WizardryItems.storage_upgrade;
                    break;
                }
                case "upgrade_siphon": {
                    replacement = WizardryItems.siphon_upgrade;
                    break;
                }
                case "upgrade_condenser": {
                    replacement = WizardryItems.condenser_upgrade;
                    break;
                }
                case "upgrade_range": {
                    replacement = WizardryItems.range_upgrade;
                    break;
                }
                case "upgrade_duration": {
                    replacement = WizardryItems.duration_upgrade;
                    break;
                }
                case "upgrade_cooldown": {
                    replacement = WizardryItems.cooldown_upgrade;
                    break;
                }
                case "upgrade_blast": {
                    replacement = WizardryItems.blast_upgrade;
                    break;
                }
                case "upgrade_attunement": {
                    replacement = WizardryItems.attunement_upgrade;
                    break;
                }
                default: {
                    return;
                }
            }
            mapping.remap((IForgeRegistryEntry)replacement);
        }
    }
}

