/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.client.ClientProxy;
import electroblob.wizardry.client.GuiButtonInvisible;
import electroblob.wizardry.client.GuiButtonTurnPage;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.util.WizardryUtilities;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Keyboard;

public class GuiWizardHandbook
extends GuiScreen {
    private int xSize = 288;
    private int ySize = 180;
    private int pageNumber = 0;
    private static final int PAGE_WIDTH = 120;
    private static final int BLACK = 1;
    public static final ResourceLocation regularHandbook = new ResourceLocation("ebwizardry", "textures/gui/handbook.png");
    public static final ResourceLocation ore = new ResourceLocation("ebwizardry", "textures/gui/ore_picture.png");
    public static final ResourceLocation crystal = new ResourceLocation("ebwizardry", "textures/items/magic_crystal.png");
    public static final ResourceLocation workbenchGui = new ResourceLocation("ebwizardry", "textures/gui/arcane_workbench.png");
    public static final ResourceLocation craftingGrids = new ResourceLocation("ebwizardry", "textures/gui/handbook_recipes.png");
    private List<ArrayList<String>> text;
    private List<Section> sections;
    private static final List<Pair<ItemStack, NonNullList<NonNullList<ItemStack>>>> RECIPES = new ArrayList<Pair<ItemStack, NonNullList<NonNullList<ItemStack>>>>();
    private int guiPage;
    private int imagePage;

    public void func_73863_a(int mouseX, int mouseY, float par3) {
        int recipePage;
        ArrayList list;
        int xPos = this.field_146294_l / 2 - this.xSize / 2;
        int yPos = this.field_146295_m / 2 - this.ySize / 2;
        if (this.pageNumber >= (this.sections.get((int)(this.sections.size() - 1)).pageNumber - 1) / 2 && this.pageNumber < (this.sections.get((int)(this.sections.size() - 1)).pageNumber - 1) / 2 + 4) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(craftingGrids);
        } else {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(regularHandbook);
        }
        WizardryUtilities.drawTexturedRect(xPos, yPos, 0, 0, this.xSize, this.ySize, this.xSize, 256);
        if (this.pageNumber == (this.guiPage - 1) / 2) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(workbenchGui);
            this.func_73729_b(this.guiPage % 2 == 1 ? xPos + 17 : this.field_146294_l / 2 + 7, yPos + 14, 28, 12, 120, 118);
        }
        if (this.pageNumber == (this.imagePage - 1) / 2) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(ore);
            WizardryUtilities.drawTexturedRect(this.imagePage % 2 == 1 ? xPos + 17 : this.field_146294_l / 2 + 7, yPos + 80, 0, 0, 64, 64, 64, 64);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(crystal);
            GuiWizardHandbook.drawTexturedStretchedRect(this.imagePage % 2 == 1 ? xPos + 17 + 64 : this.field_146294_l / 2 + 7 + 62, yPos + 80, 0, 0, 64, 64, 1, 1);
        }
        this.field_146289_q.func_78276_b("" + (this.pageNumber * 2 + 1), xPos + this.xSize / 4 - 3, yPos + this.ySize - 20, 0);
        this.field_146289_q.func_78276_b("" + (this.pageNumber * 2 + 2), xPos + 3 * this.xSize / 4 - 5, yPos + this.ySize - 20, 0);
        super.func_73863_a(mouseX, mouseY, par3);
        int lineNumber = 0;
        if (this.pageNumber == 1) {
            for (Section s : this.sections) {
                s.drawContents();
            }
        } else {
            for (Section s : this.sections) {
                s.hideButton();
            }
        }
        for (String paragraph : this.text.get(this.pageNumber * 2)) {
            this.field_146289_q.func_78279_b(paragraph, xPos + 17, yPos + 14 + lineNumber * this.field_146289_q.field_78288_b, 120, 1);
            list = new ArrayList(this.field_146289_q.func_78271_c(paragraph, 120));
            lineNumber += list.size();
        }
        lineNumber = 0;
        if (this.text.size() > this.pageNumber * 2 + 1) {
            for (String paragraph : this.text.get(this.pageNumber * 2 + 1)) {
                if (this.pageNumber == 0) {
                    int startX = this.field_146294_l / 2 + 7 + 60 - this.field_146289_q.func_78256_a(paragraph) / 2;
                    this.field_146289_q.func_78279_b(paragraph, startX, yPos + 14 + lineNumber * this.field_146289_q.field_78288_b, 120, 1);
                } else {
                    this.field_146289_q.func_78279_b(paragraph, this.field_146294_l / 2 + 7, yPos + 14 + lineNumber * this.field_146289_q.field_78288_b, 120, 1);
                }
                list = new ArrayList(this.field_146289_q.func_78271_c(paragraph, 120));
                lineNumber += list.size();
            }
        }
        if ((recipePage = this.pageNumber - (this.sections.get((int)(this.sections.size() - 1)).pageNumber - 1) / 2) >= 0 && recipePage < 4) {
            this.renderCraftingRecipe(xPos + 23, yPos + 39, mouseX, mouseY, (NonNullList<NonNullList<ItemStack>>)((NonNullList)RECIPES.get(recipePage * 4).getRight()), (ItemStack)RECIPES.get(recipePage * 4).getLeft());
            this.renderCraftingRecipe(xPos + 23, yPos + 98, mouseX, mouseY, (NonNullList<NonNullList<ItemStack>>)((NonNullList)RECIPES.get(recipePage * 4 + 1).getRight()), (ItemStack)RECIPES.get(recipePage * 4 + 1).getLeft());
            this.renderCraftingRecipe(xPos + 156, yPos + 39, mouseX, mouseY, (NonNullList<NonNullList<ItemStack>>)((NonNullList)RECIPES.get(recipePage * 4 + 2).getRight()), (ItemStack)RECIPES.get(recipePage * 4 + 2).getLeft());
            this.renderCraftingRecipe(xPos + 156, yPos + 98, mouseX, mouseY, (NonNullList<NonNullList<ItemStack>>)((NonNullList)RECIPES.get(recipePage * 4 + 3).getRight()), (ItemStack)RECIPES.get(recipePage * 4 + 3).getLeft());
            this.renderCraftingTooltips(xPos + 23, yPos + 39, mouseX, mouseY, (NonNullList<NonNullList<ItemStack>>)((NonNullList)RECIPES.get(recipePage * 4).getRight()), (ItemStack)RECIPES.get(recipePage * 4).getLeft());
            this.renderCraftingTooltips(xPos + 23, yPos + 98, mouseX, mouseY, (NonNullList<NonNullList<ItemStack>>)((NonNullList)RECIPES.get(recipePage * 4 + 1).getRight()), (ItemStack)RECIPES.get(recipePage * 4 + 1).getLeft());
            this.renderCraftingTooltips(xPos + 156, yPos + 39, mouseX, mouseY, (NonNullList<NonNullList<ItemStack>>)((NonNullList)RECIPES.get(recipePage * 4 + 2).getRight()), (ItemStack)RECIPES.get(recipePage * 4 + 2).getLeft());
            this.renderCraftingTooltips(xPos + 156, yPos + 98, mouseX, mouseY, (NonNullList<NonNullList<ItemStack>>)((NonNullList)RECIPES.get(recipePage * 4 + 3).getRight()), (ItemStack)RECIPES.get(recipePage * 4 + 3).getLeft());
        }
    }

    private void renderCraftingRecipe(int xPos, int yPos, int mouseX, int mouseY, NonNullList<NonNullList<ItemStack>> craftingGrid, ItemStack craftingResult) {
        GlStateManager.func_179094_E();
        RenderHelper.func_74520_c();
        GlStateManager.func_179140_f();
        GlStateManager.func_179091_B();
        GlStateManager.func_179142_g();
        GlStateManager.func_179145_e();
        this.field_146296_j.field_77023_b = 100.0f;
        for (int i = 0; i < craftingGrid.size(); ++i) {
            for (int j = 0; j < ((NonNullList)craftingGrid.get(i)).size(); ++j) {
                ItemStack stack = (ItemStack)((NonNullList)craftingGrid.get(i)).get(j);
                if (stack.func_190926_b()) continue;
                this.field_146296_j.func_180450_b(stack, xPos + 18 * i, yPos + 18 * j);
                this.field_146296_j.func_175030_a(this.field_146289_q, stack, xPos + 18 * i, yPos + 18 * j);
            }
        }
        if (!craftingResult.func_190926_b()) {
            this.field_146296_j.func_180450_b(craftingResult, xPos + 86, yPos + 18);
            this.field_146296_j.func_175030_a(this.field_146289_q, craftingResult, xPos + 86, yPos + 18);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        RenderHelper.func_74519_b();
    }

    private void renderCraftingTooltips(int xPos, int yPos, int mouseX, int mouseY, NonNullList<NonNullList<ItemStack>> craftingGrid, ItemStack craftingResult) {
        int guiLeft = this.field_146294_l / 2 - this.xSize / 2;
        int guiTop = this.field_146295_m / 2 - this.ySize / 2;
        GlStateManager.func_179094_E();
        RenderHelper.func_74520_c();
        GlStateManager.func_179140_f();
        GlStateManager.func_179091_B();
        GlStateManager.func_179142_g();
        this.field_146296_j.field_77023_b = 0.0f;
        GlStateManager.func_179140_f();
        for (int i = 0; i < craftingGrid.size(); ++i) {
            for (int j = 0; j < ((NonNullList)craftingGrid.get(i)).size(); ++j) {
                ItemStack stack = (ItemStack)((NonNullList)craftingGrid.get(i)).get(j);
                if (stack.func_190926_b() || !this.isPointInRegion(xPos + 18 * i, yPos + 18 * j, 16, 16, mouseX + guiLeft, mouseY + guiTop)) continue;
                this.func_146285_a(stack, mouseX, mouseY);
            }
        }
        if (!craftingResult.func_190926_b() && this.isPointInRegion(xPos + 86, yPos + 18, 16, 16, mouseX + guiLeft, mouseY + guiTop)) {
            this.func_146285_a(craftingResult, mouseX, mouseY);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        RenderHelper.func_74519_b();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        int nextButtonId = 0;
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButtonTurnPage(nextButtonId++, this.field_146294_l / 2 + this.xSize / 2 - 22 - 23, this.field_146295_m / 2 + this.ySize / 2 - 10 - 13, true));
        this.field_146292_n.add(new GuiButtonTurnPage(nextButtonId++, this.field_146294_l / 2 - this.xSize / 2 + 21, this.field_146295_m / 2 + this.ySize / 2 - 10 - 13, false));
        this.text = new ArrayList<ArrayList<String>>(1);
        this.sections = new ArrayList<Section>(1);
        BufferedReader bufferedreader = null;
        String textFilepath = "ebwizardry:texts/handbook_" + Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a() + ".txt";
        try {
            bufferedreader = new BufferedReader(new InputStreamReader(this.field_146297_k.func_110442_L().func_110536_a(new ResourceLocation(textFilepath)).func_110527_b(), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            Wizardry.logger.info("Wizard handbook text file missing for the current language. Using default (English - US) instead.");
            textFilepath = "ebwizardry:texts/handbook_en_us.txt";
            try {
                bufferedreader = new BufferedReader(new InputStreamReader(this.field_146297_k.func_110442_L().func_110536_a(new ResourceLocation(textFilepath)).func_110527_b(), StandardCharsets.UTF_8));
            }
            catch (IOException x) {
                Wizardry.logger.error("Couldn't find file: ebwizardry/assets/texts/handbook_en_us.txt. The file may bemissing; please try re-downloading and reinstalling Wizardry.", (Throwable)x);
            }
        }
        if (bufferedreader != null) {
            try {
                String paragraph = bufferedreader.readLine();
                ArrayList<String> page = new ArrayList<String>(1);
                int linesPerPage = 16;
                int lineNumber = 0;
                while (paragraph != null) {
                    if (paragraph.contains("PAGEBREAK") || lineNumber >= linesPerPage) {
                        this.text.add(page);
                        page = new ArrayList(1);
                        lineNumber = 0;
                        if (!paragraph.contains("PAGEBREAK")) continue;
                        paragraph = bufferedreader.readLine();
                        continue;
                    }
                    if (paragraph.contains("LINEBREAK")) {
                        ++lineNumber;
                        page.add("");
                        paragraph = bufferedreader.readLine();
                        continue;
                    }
                    if (paragraph.contains("SECTION")) {
                        this.sections.add(new Section(paragraph.replace("SECTION ", ""), this.text.size() + 1, this.field_146294_l / 2 + 7, this.field_146295_m / 2 - this.ySize / 2 + 14 + (this.sections.size() + 2) * this.field_146289_q.field_78288_b, nextButtonId++));
                        paragraph = bufferedreader.readLine();
                        continue;
                    }
                    if (paragraph.contains("IMAGE")) {
                        if (paragraph.contains("WORKBENCH")) {
                            this.guiPage = this.text.size() + 1;
                        } else if (paragraph.contains("CRYSTAL")) {
                            this.imagePage = this.text.size() + 1;
                        }
                        paragraph = bufferedreader.readLine();
                        continue;
                    }
                    paragraph = paragraph.replaceAll("NEXT_SPELL_KEY", ClientProxy.NEXT_SPELL.getDisplayName());
                    paragraph = paragraph.replaceAll("PREVIOUS_SPELL_KEY", ClientProxy.PREVIOUS_SPELL.getDisplayName());
                    paragraph = paragraph.replaceAll("MANA_PER_CRYSTAL_MINUS_30", "70");
                    paragraph = paragraph.replaceAll("MANA_PER_CRYSTAL", "100");
                    paragraph = paragraph.replaceAll("BASIC_MAX_CHARGE", "" + Tier.BASIC.maxCharge);
                    paragraph = paragraph.replaceAll("APPRENTICE_MAX_CHARGE", "" + Tier.APPRENTICE.maxCharge);
                    paragraph = paragraph.replaceAll("ADVANCED_MAX_CHARGE", "" + Tier.ADVANCED.maxCharge);
                    paragraph = paragraph.replaceAll("MASTER_MAX_CHARGE", "" + Tier.MASTER.maxCharge);
                    paragraph = paragraph.replaceAll("BASIC_COLOUR", "\u00a77");
                    paragraph = paragraph.replaceAll("APPRENTICE_COLOUR", Tier.APPRENTICE.getFormattingCode());
                    paragraph = paragraph.replaceAll("ADVANCED_COLOUR", Tier.ADVANCED.getFormattingCode());
                    paragraph = paragraph.replaceAll("MASTER_COLOUR", Tier.MASTER.getFormattingCode());
                    paragraph = paragraph.replaceAll("FIRE_COLOUR", Element.FIRE.getFormattingCode());
                    paragraph = paragraph.replaceAll("ICE_COLOUR", Element.ICE.getFormattingCode());
                    paragraph = paragraph.replaceAll("LIGHTNING_COLOUR", Element.LIGHTNING.getFormattingCode());
                    paragraph = paragraph.replaceAll("NECROMANCY_COLOUR", Element.NECROMANCY.getFormattingCode());
                    paragraph = paragraph.replaceAll("EARTH_COLOUR", Element.EARTH.getFormattingCode());
                    paragraph = paragraph.replaceAll("SORCERY_COLOUR", Element.SORCERY.getFormattingCode());
                    paragraph = paragraph.replaceAll("HEALING_COLOUR", Element.HEALING.getFormattingCode());
                    paragraph = paragraph.replaceAll("RESET_COLOUR", "\u00a70");
                    paragraph = paragraph.replaceAll("MCVERSION", "1.12.2");
                    paragraph = paragraph.replaceAll("VERSION", "4.1.4");
                    int linesInParagraph = this.field_146289_q.func_78271_c(paragraph, 120).size();
                    if (paragraph.isEmpty() && lineNumber == 0) {
                        paragraph = bufferedreader.readLine();
                        continue;
                    }
                    if (lineNumber + linesInParagraph <= linesPerPage) {
                        page.add(paragraph);
                        lineNumber += linesInParagraph;
                        paragraph = bufferedreader.readLine();
                        continue;
                    }
                    int linesInFirstPart = linesPerPage - lineNumber;
                    String paragraphFirstPart = "";
                    String paragraphLastPart = "";
                    int i = 0;
                    List strings = this.field_146289_q.func_78271_c(paragraph, 120);
                    for (Object s : strings) {
                        if (i < linesInFirstPart) {
                            paragraphFirstPart = paragraphFirstPart.concat((String)s + " ");
                        } else {
                            paragraphLastPart = paragraphLastPart.concat((String)s + " ");
                        }
                        ++i;
                    }
                    page.add(paragraphFirstPart);
                    lineNumber += linesInFirstPart;
                    paragraph = paragraphLastPart;
                }
                this.text.add(page);
            }
            catch (IOException e) {
                Wizardry.logger.error("Something went wrong reading file: " + textFilepath + ". The file may be damaged; please try re-downloading and reinstalling wizardry.", (Throwable)e);
            }
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_146284_a(GuiButton par1GuiButton) {
        if (par1GuiButton.field_146124_l) {
            if (par1GuiButton.field_146127_k == 0) {
                if (this.pageNumber < (this.text.size() - 1) / 2) {
                    ++this.pageNumber;
                }
            } else if (par1GuiButton.field_146127_k == 1) {
                if (this.pageNumber > 0) {
                    --this.pageNumber;
                }
            } else if (this.pageNumber == 1) {
                this.pageNumber = (this.sections.get((int)(par1GuiButton.field_146127_k - 2)).pageNumber - 1) / 2;
            }
        }
    }

    protected boolean isPointInRegion(int par1, int par2, int par3, int par4, int par5, int par6) {
        int k1 = this.field_146294_l / 2 - this.xSize / 2;
        int l1 = this.field_146295_m / 2 - this.ySize / 2;
        return (par5 -= k1) >= par1 - 1 && par5 < par1 + par3 + 1 && (par6 -= l1) >= par2 - 1 && par6 < par2 + par4 + 1;
    }

    public static void drawTexturedStretchedRect(int x, int y, int u, int v, int finalWidth, int finalHeight, int width, int height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)x, (double)(y + finalHeight), 0.0).func_187315_a((double)u, (double)(v + height)).func_181675_d();
        buffer.func_181662_b((double)(x + finalWidth), (double)(y + finalHeight), 0.0).func_187315_a((double)(u + width), (double)(v + height)).func_181675_d();
        buffer.func_181662_b((double)(x + finalWidth), (double)y, 0.0).func_187315_a((double)(u + width), (double)v).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)u, (double)v).func_181675_d();
        tessellator.func_78381_a();
    }

    private static NonNullList<NonNullList<ItemStack>> createGrid() {
        NonNullList grid = NonNullList.func_191197_a((int)3, (Object)NonNullList.func_191196_a());
        for (int i = 0; i < 3; ++i) {
            grid.set(i, (Object)NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a));
        }
        return grid;
    }

    public static void initDisplayRecipes() {
        NonNullList<NonNullList<ItemStack>> craftingGrid = GuiWizardHandbook.createGrid();
        ((NonNullList)craftingGrid.get(0)).set(0, (Object)new ItemStack(Items.field_151074_bl));
        ((NonNullList)craftingGrid.get(1)).set(0, (Object)new ItemStack(Blocks.field_150404_cg, 1, 10));
        ((NonNullList)craftingGrid.get(2)).set(0, (Object)new ItemStack(Items.field_151074_bl));
        ((NonNullList)craftingGrid.get(0)).set(1, (Object)new ItemStack(WizardryItems.magic_crystal));
        ((NonNullList)craftingGrid.get(1)).set(1, (Object)new ItemStack(Blocks.field_150368_y));
        ((NonNullList)craftingGrid.get(2)).set(1, (Object)new ItemStack(WizardryItems.magic_crystal));
        ((NonNullList)craftingGrid.get(0)).set(2, (Object)new ItemStack(Blocks.field_150348_b));
        ((NonNullList)craftingGrid.get(1)).set(2, (Object)new ItemStack(Blocks.field_150348_b));
        ((NonNullList)craftingGrid.get(2)).set(2, (Object)new ItemStack(Blocks.field_150348_b));
        ItemStack craftingResult = new ItemStack(WizardryBlocks.arcane_workbench);
        RECIPES.add((Pair<ItemStack, NonNullList<NonNullList<ItemStack>>>)ImmutablePair.of((Object)craftingResult, craftingGrid));
        craftingGrid = GuiWizardHandbook.createGrid();
        ((NonNullList)craftingGrid.get(2)).set(0, (Object)new ItemStack(WizardryItems.magic_crystal));
        ((NonNullList)craftingGrid.get(1)).set(1, (Object)new ItemStack(Items.field_151055_y));
        ((NonNullList)craftingGrid.get(0)).set(2, (Object)new ItemStack(Items.field_151074_bl));
        craftingResult = new ItemStack(WizardryItems.magic_wand);
        RECIPES.add((Pair<ItemStack, NonNullList<NonNullList<ItemStack>>>)ImmutablePair.of((Object)craftingResult, craftingGrid));
        craftingGrid = GuiWizardHandbook.createGrid();
        ((NonNullList)craftingGrid.get(1)).set(0, (Object)new ItemStack(WizardryItems.magic_crystal));
        ((NonNullList)craftingGrid.get(0)).set(1, (Object)new ItemStack(WizardryItems.magic_crystal));
        ((NonNullList)craftingGrid.get(1)).set(1, (Object)new ItemStack(Items.field_151122_aG));
        ((NonNullList)craftingGrid.get(1)).set(2, (Object)new ItemStack(WizardryItems.magic_crystal));
        ((NonNullList)craftingGrid.get(2)).set(1, (Object)new ItemStack(WizardryItems.magic_crystal));
        craftingResult = new ItemStack(WizardryItems.spell_book, 1, 1);
        RECIPES.add((Pair<ItemStack, NonNullList<NonNullList<ItemStack>>>)ImmutablePair.of((Object)craftingResult, craftingGrid));
        craftingGrid = GuiWizardHandbook.createGrid();
        ((NonNullList)craftingGrid.get(0)).set(0, (Object)new ItemStack(Items.field_151122_aG));
        ((NonNullList)craftingGrid.get(1)).set(0, (Object)new ItemStack(WizardryItems.magic_crystal));
        craftingResult = new ItemStack(WizardryItems.wizard_handbook);
        RECIPES.add((Pair<ItemStack, NonNullList<NonNullList<ItemStack>>>)ImmutablePair.of((Object)craftingResult, craftingGrid));
        craftingGrid = GuiWizardHandbook.createGrid();
        ((NonNullList)craftingGrid.get(0)).set(0, (Object)new ItemStack(WizardryBlocks.crystal_flower));
        craftingResult = new ItemStack(WizardryItems.magic_crystal, 2);
        RECIPES.add((Pair<ItemStack, NonNullList<NonNullList<ItemStack>>>)ImmutablePair.of((Object)craftingResult, craftingGrid));
        craftingGrid = GuiWizardHandbook.createGrid();
        ((NonNullList)craftingGrid.get(0)).set(0, (Object)new ItemStack(WizardryItems.magic_crystal));
        ((NonNullList)craftingGrid.get(1)).set(0, (Object)new ItemStack(WizardryItems.magic_crystal));
        ((NonNullList)craftingGrid.get(2)).set(0, (Object)new ItemStack(WizardryItems.magic_crystal));
        ((NonNullList)craftingGrid.get(0)).set(1, (Object)new ItemStack(WizardryItems.magic_crystal));
        ((NonNullList)craftingGrid.get(1)).set(1, (Object)new ItemStack(Items.field_151069_bo));
        ((NonNullList)craftingGrid.get(2)).set(1, (Object)new ItemStack(WizardryItems.magic_crystal));
        ((NonNullList)craftingGrid.get(0)).set(2, (Object)new ItemStack(WizardryItems.magic_crystal));
        ((NonNullList)craftingGrid.get(1)).set(2, (Object)new ItemStack(WizardryItems.magic_crystal));
        ((NonNullList)craftingGrid.get(2)).set(2, (Object)new ItemStack(WizardryItems.magic_crystal));
        craftingResult = new ItemStack(WizardryItems.mana_flask);
        RECIPES.add((Pair<ItemStack, NonNullList<NonNullList<ItemStack>>>)ImmutablePair.of((Object)craftingResult, craftingGrid));
        craftingGrid = GuiWizardHandbook.createGrid();
        ((NonNullList)craftingGrid.get(1)).set(0, (Object)new ItemStack(Blocks.field_150348_b));
        ((NonNullList)craftingGrid.get(0)).set(1, (Object)new ItemStack(Blocks.field_150348_b));
        ((NonNullList)craftingGrid.get(1)).set(1, (Object)new ItemStack(WizardryItems.magic_crystal));
        ((NonNullList)craftingGrid.get(1)).set(2, (Object)new ItemStack(Blocks.field_150348_b));
        ((NonNullList)craftingGrid.get(2)).set(1, (Object)new ItemStack(Blocks.field_150348_b));
        craftingResult = new ItemStack(WizardryBlocks.transportation_stone, 2);
        RECIPES.add((Pair<ItemStack, NonNullList<NonNullList<ItemStack>>>)ImmutablePair.of((Object)craftingResult, craftingGrid));
        craftingGrid = GuiWizardHandbook.createGrid();
        ((NonNullList)craftingGrid.get(1)).set(0, (Object)new ItemStack(Items.field_151007_F));
        ((NonNullList)craftingGrid.get(0)).set(1, (Object)new ItemStack(Items.field_151007_F));
        ((NonNullList)craftingGrid.get(1)).set(1, (Object)new ItemStack(WizardryItems.magic_crystal));
        ((NonNullList)craftingGrid.get(1)).set(2, (Object)new ItemStack(Items.field_151007_F));
        ((NonNullList)craftingGrid.get(2)).set(1, (Object)new ItemStack(Items.field_151007_F));
        craftingResult = new ItemStack(WizardryItems.magic_silk, 2);
        RECIPES.add((Pair<ItemStack, NonNullList<NonNullList<ItemStack>>>)ImmutablePair.of((Object)craftingResult, craftingGrid));
        craftingGrid = GuiWizardHandbook.createGrid();
        ((NonNullList)craftingGrid.get(0)).set(0, (Object)new ItemStack(WizardryItems.magic_silk));
        ((NonNullList)craftingGrid.get(1)).set(0, (Object)new ItemStack(WizardryItems.magic_silk));
        ((NonNullList)craftingGrid.get(2)).set(0, (Object)new ItemStack(WizardryItems.magic_silk));
        ((NonNullList)craftingGrid.get(0)).set(1, (Object)new ItemStack(WizardryItems.magic_silk));
        ((NonNullList)craftingGrid.get(2)).set(1, (Object)new ItemStack(WizardryItems.magic_silk));
        craftingResult = new ItemStack(WizardryItems.wizard_hat);
        RECIPES.add((Pair<ItemStack, NonNullList<NonNullList<ItemStack>>>)ImmutablePair.of((Object)craftingResult, craftingGrid));
        craftingGrid = GuiWizardHandbook.createGrid();
        ((NonNullList)craftingGrid.get(0)).set(0, (Object)new ItemStack(WizardryItems.magic_silk));
        ((NonNullList)craftingGrid.get(2)).set(0, (Object)new ItemStack(WizardryItems.magic_silk));
        ((NonNullList)craftingGrid.get(0)).set(1, (Object)new ItemStack(WizardryItems.magic_silk));
        ((NonNullList)craftingGrid.get(1)).set(1, (Object)new ItemStack(WizardryItems.magic_silk));
        ((NonNullList)craftingGrid.get(2)).set(1, (Object)new ItemStack(WizardryItems.magic_silk));
        ((NonNullList)craftingGrid.get(0)).set(2, (Object)new ItemStack(WizardryItems.magic_silk));
        ((NonNullList)craftingGrid.get(1)).set(2, (Object)new ItemStack(WizardryItems.magic_silk));
        ((NonNullList)craftingGrid.get(2)).set(2, (Object)new ItemStack(WizardryItems.magic_silk));
        craftingResult = new ItemStack(WizardryItems.wizard_robe);
        RECIPES.add((Pair<ItemStack, NonNullList<NonNullList<ItemStack>>>)ImmutablePair.of((Object)craftingResult, craftingGrid));
        craftingGrid = GuiWizardHandbook.createGrid();
        ((NonNullList)craftingGrid.get(0)).set(0, (Object)new ItemStack(WizardryItems.magic_silk));
        ((NonNullList)craftingGrid.get(1)).set(0, (Object)new ItemStack(WizardryItems.magic_silk));
        ((NonNullList)craftingGrid.get(2)).set(0, (Object)new ItemStack(WizardryItems.magic_silk));
        ((NonNullList)craftingGrid.get(0)).set(1, (Object)new ItemStack(WizardryItems.magic_silk));
        ((NonNullList)craftingGrid.get(2)).set(1, (Object)new ItemStack(WizardryItems.magic_silk));
        ((NonNullList)craftingGrid.get(0)).set(2, (Object)new ItemStack(WizardryItems.magic_silk));
        ((NonNullList)craftingGrid.get(2)).set(2, (Object)new ItemStack(WizardryItems.magic_silk));
        craftingResult = new ItemStack(WizardryItems.wizard_leggings);
        RECIPES.add((Pair<ItemStack, NonNullList<NonNullList<ItemStack>>>)ImmutablePair.of((Object)craftingResult, craftingGrid));
        craftingGrid = GuiWizardHandbook.createGrid();
        ((NonNullList)craftingGrid.get(0)).set(0, (Object)new ItemStack(WizardryItems.magic_silk));
        ((NonNullList)craftingGrid.get(2)).set(0, (Object)new ItemStack(WizardryItems.magic_silk));
        ((NonNullList)craftingGrid.get(0)).set(1, (Object)new ItemStack(WizardryItems.magic_silk));
        ((NonNullList)craftingGrid.get(2)).set(1, (Object)new ItemStack(WizardryItems.magic_silk));
        craftingResult = new ItemStack(WizardryItems.wizard_boots);
        RECIPES.add((Pair<ItemStack, NonNullList<NonNullList<ItemStack>>>)ImmutablePair.of((Object)craftingResult, craftingGrid));
        craftingGrid = GuiWizardHandbook.createGrid();
        ((NonNullList)craftingGrid.get(0)).set(0, (Object)new ItemStack(Items.field_151121_aF));
        ((NonNullList)craftingGrid.get(1)).set(0, (Object)new ItemStack(Items.field_151007_F));
        craftingResult = new ItemStack(WizardryItems.blank_scroll);
        RECIPES.add((Pair<ItemStack, NonNullList<NonNullList<ItemStack>>>)ImmutablePair.of((Object)craftingResult, craftingGrid));
        craftingGrid = GuiWizardHandbook.createGrid();
        ((NonNullList)craftingGrid.get(0)).set(0, (Object)new ItemStack(Items.field_151065_br));
        ((NonNullList)craftingGrid.get(1)).set(0, (Object)new ItemStack(Items.field_151065_br));
        ((NonNullList)craftingGrid.get(0)).set(1, (Object)new ItemStack(Items.field_151069_bo));
        ((NonNullList)craftingGrid.get(1)).set(1, (Object)new ItemStack(Items.field_151016_H));
        craftingResult = new ItemStack(WizardryItems.firebomb, 3);
        RECIPES.add((Pair<ItemStack, NonNullList<NonNullList<ItemStack>>>)ImmutablePair.of((Object)craftingResult, craftingGrid));
        craftingGrid = GuiWizardHandbook.createGrid();
        ((NonNullList)craftingGrid.get(0)).set(0, (Object)new ItemStack(Items.field_151070_bp));
        ((NonNullList)craftingGrid.get(1)).set(0, (Object)new ItemStack(Items.field_151070_bp));
        ((NonNullList)craftingGrid.get(0)).set(1, (Object)new ItemStack(Items.field_151069_bo));
        ((NonNullList)craftingGrid.get(1)).set(1, (Object)new ItemStack(Items.field_151016_H));
        craftingResult = new ItemStack(WizardryItems.poison_bomb, 3);
        RECIPES.add((Pair<ItemStack, NonNullList<NonNullList<ItemStack>>>)ImmutablePair.of((Object)craftingResult, craftingGrid));
        craftingGrid = GuiWizardHandbook.createGrid();
        ((NonNullList)craftingGrid.get(0)).set(0, (Object)new ItemStack(Items.field_151044_h));
        ((NonNullList)craftingGrid.get(1)).set(0, (Object)new ItemStack(Items.field_151044_h));
        ((NonNullList)craftingGrid.get(0)).set(1, (Object)new ItemStack(Items.field_151069_bo));
        ((NonNullList)craftingGrid.get(1)).set(1, (Object)new ItemStack(Items.field_151016_H));
        craftingResult = new ItemStack(WizardryItems.smoke_bomb, 3);
        RECIPES.add((Pair<ItemStack, NonNullList<NonNullList<ItemStack>>>)ImmutablePair.of((Object)craftingResult, craftingGrid));
    }

    private class Section {
        private static final int HIGHLIGHT_COLOUR = 14502941;
        String name;
        int pageNumber;
        int x;
        int y;
        int buttonId;

        Section(String name, int pageNumber, int x, int y, int id) {
            this.name = name;
            this.pageNumber = pageNumber;
            this.x = x;
            this.y = y;
            this.buttonId = id;
            GuiWizardHandbook.this.field_146292_n.add(new GuiButtonInvisible(id, x, y, 120, ((GuiWizardHandbook)GuiWizardHandbook.this).field_146289_q.field_78288_b));
        }

        void hideButton() {
            ((GuiButton)((GuiWizardHandbook)GuiWizardHandbook.this).field_146292_n.get((int)this.buttonId)).field_146125_m = false;
        }

        void drawContents() {
            ((GuiButton)((GuiWizardHandbook)GuiWizardHandbook.this).field_146292_n.get((int)this.buttonId)).field_146125_m = true;
            GuiWizardHandbook.this.field_146289_q.func_78276_b(this.name, this.x, this.y, ((GuiButton)GuiWizardHandbook.this.field_146292_n.get(this.buttonId)).func_146115_a() ? 14502941 : 1);
            int nameWidth = GuiWizardHandbook.this.field_146289_q.func_78256_a(this.name);
            String dotsAndNumber = " " + this.pageNumber;
            while (GuiWizardHandbook.this.field_146289_q.func_78256_a(dotsAndNumber) < 120 - nameWidth - 2) {
                dotsAndNumber = "." + dotsAndNumber;
            }
            GuiWizardHandbook.this.field_146289_q.func_78276_b(dotsAndNumber, this.x + 120 - GuiWizardHandbook.this.field_146289_q.func_78256_a(dotsAndNumber), this.y, 1);
        }
    }
}

