/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.command;

import electroblob.wizardry.WizardData;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.event.DiscoverSpellEvent;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.spell.Spell;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class CommandDiscoverSpell
extends CommandBase {
    public String func_71517_b() {
        return Wizardry.settings.discoverspellCommandName;
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.ebwizardry:discoverspell.usage";
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] arguments, BlockPos pos) {
        switch (arguments.length) {
            case 1: {
                return CommandDiscoverSpell.func_175762_a((String[])arguments, Spell.getSpellNames());
            }
            case 2: {
                return CommandDiscoverSpell.func_71530_a((String[])arguments, (String[])server.func_71213_z());
            }
        }
        return super.func_184883_a(server, sender, arguments, pos);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] arguments) throws CommandException {
        EntityPlayerMP entityplayermp;
        if (arguments.length < 1) {
            throw new WrongUsageException("commands.ebwizardry:discoverspell.usage", new Object[]{Wizardry.settings.discoverspellCommandName});
        }
        int i = 0;
        boolean clear = false;
        boolean all = false;
        EntityPlayerMP player = null;
        try {
            player = CommandDiscoverSpell.func_71521_c((ICommandSender)sender);
        }
        catch (PlayerNotFoundException playerNotFoundException) {
            // empty catch block
        }
        Spell spell = Spells.none;
        if (arguments[i].equals("clear")) {
            clear = true;
            ++i;
        } else if (arguments[i].equals("all")) {
            all = true;
            ++i;
        } else if ((spell = Spell.get(arguments[i++])) == null) {
            throw new NumberInvalidException("commands.ebwizardry:discoverspell.not_found", new Object[]{arguments[i - 1]});
        }
        if (i < arguments.length && player != (entityplayermp = CommandDiscoverSpell.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)arguments[i++]))) {
            player = entityplayermp;
        }
        if (player == null) {
            throw new PlayerNotFoundException("You must specify which player you wish to perform this action on.");
        }
        WizardData properties = WizardData.get((EntityPlayer)player);
        if (properties != null) {
            if (clear) {
                properties.spellsDiscovered.clear();
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.ebwizardry:discoverspell.clear", new Object[]{player.func_70005_c_()}));
            } else if (all) {
                properties.spellsDiscovered.addAll(Spell.getSpells(Spell.allSpells));
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.ebwizardry:discoverspell.all", new Object[]{player.func_70005_c_()}));
            } else if (properties.hasSpellBeenDiscovered(spell)) {
                properties.spellsDiscovered.remove(spell);
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.ebwizardry:discoverspell.removespell", new Object[]{spell.getNameForTranslationFormatted(), player.func_70005_c_()}));
            } else if (!MinecraftForge.EVENT_BUS.post((Event)new DiscoverSpellEvent((EntityPlayer)player, spell, DiscoverSpellEvent.Source.COMMAND))) {
                properties.discoverSpell(spell);
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.ebwizardry:discoverspell.addspell", new Object[]{spell.getNameForTranslationFormatted(), player.func_70005_c_()}));
            }
            properties.sync();
        }
    }
}

