/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.constants;

import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum Element {
    MAGIC(new Style().func_150238_a(TextFormatting.GRAY), "simple", "ebwizardry"),
    FIRE(new Style().func_150238_a(TextFormatting.DARK_RED), "fire", "ebwizardry"),
    ICE(new Style().func_150238_a(TextFormatting.AQUA), "ice", "ebwizardry"),
    LIGHTNING(new Style().func_150238_a(TextFormatting.DARK_AQUA), "lightning", "ebwizardry"),
    NECROMANCY(new Style().func_150238_a(TextFormatting.DARK_PURPLE), "necromancy", "ebwizardry"),
    EARTH(new Style().func_150238_a(TextFormatting.DARK_GREEN), "earth", "ebwizardry"),
    SORCERY(new Style().func_150238_a(TextFormatting.GREEN), "sorcery", "ebwizardry"),
    HEALING(new Style().func_150238_a(TextFormatting.YELLOW), "healing", "ebwizardry");

    private final Style colour;
    private final String unlocalisedName;
    private final ResourceLocation icon;

    private Element(Style colour, String name, String modid) {
        this.colour = colour;
        this.unlocalisedName = name;
        this.icon = new ResourceLocation(modid, "textures/gui/element_icon_" + this.unlocalisedName + ".png");
    }

    @SideOnly(value=Side.CLIENT)
    public String getDisplayName() {
        return I18n.func_135052_a((String)("element." + this.getUnlocalisedName()), (Object[])new Object[0]);
    }

    public Style getColour() {
        return this.colour;
    }

    public String getFormattingCode() {
        return this.colour.func_150218_j();
    }

    public ITextComponent getWizardName() {
        return new TextComponentTranslation("element." + this.getUnlocalisedName() + ".wizard", new Object[0]);
    }

    public String getUnlocalisedName() {
        return this.unlocalisedName;
    }

    public ResourceLocation getIcon() {
        return this.icon;
    }
}

