/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.entity.living;

import com.google.common.base.Predicate;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.entity.living.EntityAIAttackSpell;
import electroblob.wizardry.entity.living.ISpellCaster;
import electroblob.wizardry.entity.living.ISummonedCreature;
import electroblob.wizardry.item.ItemSpellBook;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryAdvancementTriggers;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WandHelper;
import electroblob.wizardry.util.WildcardTradeList;
import electroblob.wizardry.util.WizardryParticleType;
import electroblob.wizardry.util.WizardryUtilities;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber
public class EntityWizard
extends EntityCreature
implements INpc,
IMerchant,
ISpellCaster,
IEntityAdditionalSpawnData {
    private EntityAIAttackSpell spellCastingAI = new EntityAIAttackSpell(this, 0.5, 14.0f, 30, 50);
    public int textureIndex = 0;
    protected Predicate<Entity> targetSelector;
    private MerchantRecipeList trades;
    @Nullable
    private EntityPlayer customer;
    private int timeUntilReset;
    private boolean updateRecipes;
    private static final DataParameter<Integer> HEAL_COOLDOWN = EntityDataManager.func_187226_a(EntityWizard.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> ELEMENT = EntityDataManager.func_187226_a(EntityWizard.class, (DataSerializer)DataSerializers.field_187192_b);
    private List<Spell> spells = new ArrayList<Spell>(4);
    private Spell continuousSpell;
    private Set<BlockPos> towerBlocks;

    public EntityWizard(World world) {
        super(world);
        this.func_110177_bN();
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.spellCastingAI);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HEAL_COOLDOWN, (Object)-1);
        this.field_70180_af.func_187214_a(ELEMENT, (Object)0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAITradePlayer(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAILookAtTradePlayer(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityWizard.class, 5.0f, 0.02f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
        this.targetSelector = new Predicate<Entity>(){

            public boolean apply(Entity entity) {
                return entity != null && !entity.func_82150_aj() && WizardryUtilities.isValidTarget((Entity)EntityWizard.this, entity) && (entity instanceof IMob || entity instanceof ISummonedCreature || Arrays.asList(Wizardry.settings.summonedCreatureTargetsWhitelist).contains(EntityList.func_191306_a(entity.getClass()))) && !Arrays.asList(Wizardry.settings.summonedCreatureTargetsBlacklist).contains(EntityList.func_191306_a(entity.getClass()));
            }
        };
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 0, false, true, this.targetSelector));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
    }

    private int getHealCooldown() {
        return (Integer)this.field_70180_af.func_187225_a(HEAL_COOLDOWN);
    }

    private void setHealCooldown(int cooldown) {
        this.field_70180_af.func_187227_b(HEAL_COOLDOWN, (Object)cooldown);
    }

    public Element getElement() {
        return Element.values()[(Integer)this.field_70180_af.func_187225_a(ELEMENT)];
    }

    public void setElement(Element element) {
        this.field_70180_af.func_187227_b(ELEMENT, (Object)element.ordinal());
    }

    @Override
    public List<Spell> getSpells() {
        return this.spells;
    }

    @Override
    public SpellModifiers getModifiers() {
        return new SpellModifiers();
    }

    @Override
    public void setContinuousSpell(Spell spell) {
        this.continuousSpell = spell;
    }

    @Override
    public Spell getContinuousSpell() {
        return this.continuousSpell;
    }

    public void func_70932_a_(EntityPlayer player) {
        this.customer = player;
    }

    public EntityPlayer func_70931_l_() {
        return this.customer;
    }

    public boolean isTrading() {
        return this.func_70931_l_() != null;
    }

    public void func_110297_a_(ItemStack stack) {
        if (!this.field_70170_p.field_72995_K && this.field_70757_a > -this.func_70627_aG() + 20) {
            this.field_70757_a = -this.func_70627_aG();
            this.func_184185_a(stack.func_190926_b() ? SoundEvents.field_187913_gm : SoundEvents.field_187915_go, this.func_70599_aP(), this.func_70647_i());
        }
    }

    public World func_190670_t_() {
        return this.field_70170_p;
    }

    public BlockPos func_190671_u_() {
        return new BlockPos((Entity)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70930_a(MerchantRecipeList recipeList) {
    }

    public ITextComponent func_145748_c_() {
        return this.getElement().getWizardName();
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void func_70636_d() {
        super.func_70636_d();
        int healCooldown = this.getHealCooldown();
        if (healCooldown == 0 && this.func_110143_aJ() < this.func_110138_aP() && this.func_110143_aJ() > 0.0f && !this.func_70644_a(WizardryPotions.arcane_jammer)) {
            this.func_70691_i(this.getElement() == Element.HEALING ? 8.0f : 4.0f);
            this.setHealCooldown(-1);
        } else if (healCooldown == -1 && this.field_70725_aQ == 0) {
            if (this.field_70170_p.field_72995_K) {
                for (int i = 0; i < 10; ++i) {
                    double d0 = (float)this.field_70165_t + this.field_70146_Z.nextFloat() * 2.0f - 1.0f;
                    double d1 = (float)this.field_70163_u - 0.5f + this.field_70146_Z.nextFloat();
                    double d2 = (float)this.field_70161_v + this.field_70146_Z.nextFloat() * 2.0f - 1.0f;
                    Wizardry.proxy.spawnParticle(WizardryParticleType.SPARKLE, this.field_70170_p, d0, d1, d2, 0.0, 0.1f, 0.0, 48 + this.field_70146_Z.nextInt(12), 1.0f, 1.0f, 0.3f);
                }
            } else {
                if (this.func_110143_aJ() < 10.0f) {
                    this.setHealCooldown(150);
                } else {
                    this.setHealCooldown(400);
                }
                this.func_184185_a(WizardrySounds.SPELL_HEAL, 0.7f, this.field_70146_Z.nextFloat() * 0.4f + 1.0f);
            }
        }
        if (healCooldown > 0) {
            this.setHealCooldown(healCooldown - 1);
        }
    }

    protected void func_70619_bc() {
        if (!this.isTrading() && this.timeUntilReset > 0) {
            --this.timeUntilReset;
            if (this.timeUntilReset <= 0) {
                if (this.updateRecipes) {
                    for (MerchantRecipe merchantrecipe : this.trades) {
                        if (!merchantrecipe.func_82784_g()) continue;
                        merchantrecipe.func_82783_a(this.field_70146_Z.nextInt(6) + this.field_70146_Z.nextInt(6) + 2);
                    }
                    if (this.trades.size() < 12) {
                        this.addRandomRecipes(1);
                    }
                    this.updateRecipes = false;
                }
                this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 200, 0));
            }
        }
        super.func_70619_bc();
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.field_71075_bZ.field_75098_d && stack.func_77973_b() instanceof ItemSpellBook && this.spells.size() >= 4 && Spell.get(stack.func_77952_i()).canBeCastByNPCs()) {
            this.spells.set(this.field_70146_Z.nextInt(3) + 1, Spell.get(stack.func_77952_i()));
            return true;
        }
        if (this.func_70089_S() && !this.isTrading() && !this.func_70631_g_() && !player.func_70093_af() && this.func_70638_az() != player) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_70932_a_(player);
                player.func_180472_a((IMerchant)this);
            }
            return true;
        }
        return false;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.trades != null) {
            nbt.func_74782_a("trades", (NBTBase)this.trades.func_77202_a());
        }
        nbt.func_74768_a("element", this.getElement().ordinal());
        nbt.func_74768_a("skin", this.textureIndex);
        nbt.func_74782_a("spells", (NBTBase)WizardryUtilities.listToNBT(this.spells, spell -> new NBTTagInt(spell.id())));
        if (this.towerBlocks != null && this.towerBlocks.size() > 0) {
            nbt.func_74782_a("towerBlocks", (NBTBase)WizardryUtilities.listToNBT(this.towerBlocks, pos -> new NBTTagLong(pos.func_177986_g())));
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("trades")) {
            NBTTagCompound nbttagcompound1 = nbt.func_74775_l("trades");
            this.trades = new WildcardTradeList(nbttagcompound1);
        }
        this.setElement(Element.values()[nbt.func_74762_e("element")]);
        this.textureIndex = nbt.func_74762_e("skin");
        this.spells = (List)WizardryUtilities.NBTToList(nbt.func_150295_c("spells", 3), tag -> Spell.get(tag.func_150287_d()));
        this.towerBlocks = new HashSet<BlockPos>(WizardryUtilities.NBTToList(nbt.func_150295_c("towerBlocks", 4), tag -> BlockPos.func_177969_a((long)tag.func_150291_c())));
    }

    public void func_70933_a(MerchantRecipe merchantrecipe) {
        merchantrecipe.func_77399_f();
        this.field_70757_a = -this.func_70627_aG();
        this.func_184185_a(SoundEvents.field_187915_go, this.func_70599_aP(), this.func_70647_i());
        if (this.func_70931_l_() != null) {
            WizardryAdvancementTriggers.wizard_trade.triggerFor(this.func_70931_l_());
            if (merchantrecipe.func_77397_d().func_77973_b() instanceof ItemSpellBook && Spell.get((int)merchantrecipe.func_77397_d().func_77952_i()).tier == Tier.MASTER) {
                WizardryAdvancementTriggers.buy_master_spell.triggerFor(this.func_70931_l_());
            }
        }
        if (this.field_70146_Z.nextInt(5) > 0) {
            this.timeUntilReset = 40;
            this.updateRecipes = true;
            if (this.func_70931_l_() != null) {
                this.func_70931_l_().func_70005_c_();
            }
        }
    }

    public MerchantRecipeList func_70934_b(EntityPlayer par1EntityPlayer) {
        if (this.trades == null) {
            this.trades = new WildcardTradeList();
            ItemStack anySpellBook = new ItemStack(WizardryItems.spell_book, 1, Short.MAX_VALUE);
            ItemStack crystalStack = new ItemStack(WizardryItems.magic_crystal, 5);
            this.trades.add((Object)new MerchantRecipe(anySpellBook, crystalStack));
            this.addRandomRecipes(3);
        }
        return this.trades;
    }

    private void addRandomRecipes(int numberOfItemsToAdd) {
        MerchantRecipeList merchantrecipelist = new MerchantRecipeList();
        for (int i = 0; i < numberOfItemsToAdd; ++i) {
            ItemStack itemToSell = ItemStack.field_190927_a;
            boolean itemAlreadySold = true;
            Tier tier = Tier.BASIC;
            while (itemAlreadySold) {
                itemAlreadySold = false;
                double tierIncreaseChance = 0.5 + 0.04 * (double)Math.max(this.trades.size() - 4, 0);
                tier = Tier.BASIC;
                if (this.field_70146_Z.nextDouble() < tierIncreaseChance) {
                    tier = Tier.APPRENTICE;
                    if (this.field_70146_Z.nextDouble() < tierIncreaseChance) {
                        tier = Tier.ADVANCED;
                        if (this.field_70146_Z.nextDouble() < tierIncreaseChance * 0.6) {
                            tier = Tier.MASTER;
                        }
                    }
                }
                itemToSell = this.getRandomItemOfTier(tier);
                for (Object recipe : merchantrecipelist) {
                    if (!ItemStack.func_77989_b((ItemStack)((MerchantRecipe)recipe).func_77397_d(), (ItemStack)itemToSell)) continue;
                    itemAlreadySold = true;
                }
                if (this.trades == null) continue;
                for (Object recipe : this.trades) {
                    if (!ItemStack.func_77989_b((ItemStack)((MerchantRecipe)recipe).func_77397_d(), (ItemStack)itemToSell)) continue;
                    itemAlreadySold = true;
                }
            }
            if (itemToSell.func_190926_b()) {
                return;
            }
            merchantrecipelist.add((Object)new MerchantRecipe(this.getRandomPrice(tier), new ItemStack(WizardryItems.magic_crystal, tier.ordinal() * 3 + 1 + this.field_70146_Z.nextInt(4)), itemToSell));
        }
        Collections.shuffle(merchantrecipelist);
        if (this.trades == null) {
            this.trades = new WildcardTradeList();
        }
        for (int j1 = 0; j1 < merchantrecipelist.size(); ++j1) {
            this.trades.add(merchantrecipelist.get(j1));
        }
    }

    private ItemStack getRandomPrice(Tier tier) {
        ItemStack itemstack = ItemStack.field_190927_a;
        switch (this.field_70146_Z.nextInt(3)) {
            case 0: {
                itemstack = new ItemStack(Items.field_151043_k, (tier.ordinal() + 1) * 8 - 1 + this.field_70146_Z.nextInt(6));
                break;
            }
            case 1: {
                itemstack = new ItemStack(Items.field_151045_i, (tier.ordinal() + 1) * 4 - 2 + this.field_70146_Z.nextInt(3));
                break;
            }
            case 2: {
                itemstack = new ItemStack(Items.field_151166_bC, (tier.ordinal() + 1) * 6 - 1 + this.field_70146_Z.nextInt(3));
            }
        }
        return itemstack;
    }

    private ItemStack getRandomItemOfTier(Tier tier) {
        List<Spell> spells = Spell.getSpells(new Spell.TierElementFilter(tier, null));
        List<Spell> specialismSpells = Spell.getSpells(new Spell.TierElementFilter(tier, this.getElement()));
        switch (tier) {
            case BASIC: {
                int randomiser = this.field_70146_Z.nextInt(5);
                if (randomiser < 4 && !spells.isEmpty()) {
                    if (this.getElement() != Element.MAGIC && this.field_70146_Z.nextInt(4) > 0 && !specialismSpells.isEmpty()) {
                        return new ItemStack(WizardryItems.spell_book, 1, specialismSpells.get(this.field_70146_Z.nextInt(specialismSpells.size())).id());
                    }
                    return new ItemStack(WizardryItems.spell_book, 1, spells.get(this.field_70146_Z.nextInt(spells.size())).id());
                }
                if (this.getElement() != Element.MAGIC && this.field_70146_Z.nextInt(4) > 0) {
                    return new ItemStack(WizardryUtilities.getWand(tier, this.getElement()));
                }
                return new ItemStack(WizardryUtilities.getWand(tier, Element.values()[this.field_70146_Z.nextInt(Element.values().length)]));
            }
            case APPRENTICE: {
                int randomiser = this.field_70146_Z.nextInt(Wizardry.settings.discoveryMode ? 12 : 10);
                if (randomiser < 5 && !spells.isEmpty()) {
                    if (this.getElement() != Element.MAGIC && this.field_70146_Z.nextInt(4) > 0 && !specialismSpells.isEmpty()) {
                        return new ItemStack(WizardryItems.spell_book, 1, specialismSpells.get(this.field_70146_Z.nextInt(specialismSpells.size())).id());
                    }
                    return new ItemStack(WizardryItems.spell_book, 1, spells.get(this.field_70146_Z.nextInt(spells.size())).id());
                }
                if (randomiser < 6) {
                    if (this.getElement() != Element.MAGIC && this.field_70146_Z.nextInt(4) > 0) {
                        return new ItemStack(WizardryUtilities.getWand(tier, this.getElement()));
                    }
                    return new ItemStack(WizardryUtilities.getWand(tier, Element.values()[this.field_70146_Z.nextInt(Element.values().length)]));
                }
                if (randomiser < 8) {
                    return new ItemStack(WizardryItems.arcane_tome, 1, 1);
                }
                if (randomiser < 10) {
                    EntityEquipmentSlot slot = WizardryUtilities.ARMOUR_SLOTS[this.field_70146_Z.nextInt(WizardryUtilities.ARMOUR_SLOTS.length)];
                    if (this.getElement() != Element.MAGIC && this.field_70146_Z.nextInt(4) > 0) {
                        return new ItemStack(WizardryUtilities.getArmour(this.getElement(), slot));
                    }
                    return new ItemStack(WizardryUtilities.getArmour(Element.values()[this.field_70146_Z.nextInt(Element.values().length)], slot));
                }
                return new ItemStack(WizardryItems.identification_scroll);
            }
            case ADVANCED: {
                int randomiser = this.field_70146_Z.nextInt(12);
                if (randomiser < 5 && !spells.isEmpty()) {
                    if (this.getElement() != Element.MAGIC && this.field_70146_Z.nextInt(4) > 0 && !specialismSpells.isEmpty()) {
                        return new ItemStack(WizardryItems.spell_book, 1, specialismSpells.get(this.field_70146_Z.nextInt(specialismSpells.size())).id());
                    }
                    return new ItemStack(WizardryItems.spell_book, 1, spells.get(this.field_70146_Z.nextInt(spells.size())).id());
                }
                if (randomiser < 6) {
                    if (this.getElement() != Element.MAGIC && this.field_70146_Z.nextInt(4) > 0) {
                        return new ItemStack(WizardryUtilities.getWand(tier, this.getElement()));
                    }
                    return new ItemStack(WizardryUtilities.getWand(tier, Element.values()[this.field_70146_Z.nextInt(Element.values().length)]));
                }
                if (randomiser < 8) {
                    return new ItemStack(WizardryItems.arcane_tome, 1, 2);
                }
                ArrayList<Item> upgrades = new ArrayList<Item>(WandHelper.getSpecialUpgrades());
                randomiser = this.field_70146_Z.nextInt(upgrades.size());
                return new ItemStack((Item)upgrades.get(randomiser));
            }
            case MASTER: {
                int randomiser;
                int n = randomiser = this.getElement() != Element.MAGIC ? this.field_70146_Z.nextInt(8) : 5 + this.field_70146_Z.nextInt(3);
                if (randomiser < 5 && this.getElement() != Element.MAGIC && !specialismSpells.isEmpty()) {
                    return new ItemStack(WizardryItems.spell_book, 1, specialismSpells.get(this.field_70146_Z.nextInt(specialismSpells.size())).id());
                }
                if (randomiser < 6) {
                    if (this.getElement() != Element.MAGIC && this.field_70146_Z.nextInt(4) > 0) {
                        return new ItemStack(WizardryUtilities.getWand(tier, this.getElement()));
                    }
                    return new ItemStack(WizardryItems.master_wand);
                }
                return new ItemStack(WizardryItems.arcane_tome, 1, 3);
            }
        }
        return new ItemStack(Blocks.field_150348_b);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.textureIndex = this.field_70146_Z.nextInt(6);
        if (this.field_70146_Z.nextBoolean()) {
            this.setElement(Element.values()[this.field_70146_Z.nextInt(Element.values().length - 1) + 1]);
        } else {
            this.setElement(Element.MAGIC);
        }
        Element element = this.getElement();
        for (EntityEquipmentSlot slot : WizardryUtilities.ARMOUR_SLOTS) {
            this.func_184201_a(slot, new ItemStack(WizardryUtilities.getArmour(element, slot)));
        }
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            this.func_184642_a(slot, 0.0f);
        }
        this.spells.add(Spells.magic_missile);
        Tier maxTier = EntityWizard.populateSpells(this.spells, element, 3, this.field_70146_Z);
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(WizardryUtilities.getWand(maxTier, element)));
        return livingdata;
    }

    static Tier populateSpells(List<Spell> spells, Element e, int n, Random random) {
        Tier maxTier = Tier.BASIC;
        List<Spell> npcSpells = Spell.getSpells(Spell.npcSpells);
        for (int i = 0; i < 3; ++i) {
            Element element = e == Element.MAGIC ? Element.values()[random.nextInt(Element.values().length)] : e;
            int randomiser = random.nextInt(20);
            Tier tier = randomiser < 10 ? Tier.BASIC : (randomiser < 16 ? Tier.APPRENTICE : Tier.ADVANCED);
            if (tier.ordinal() > maxTier.ordinal()) {
                maxTier = tier;
            }
            List<Spell> list = Spell.getSpells(new Spell.TierElementFilter(tier, element));
            list.retainAll(npcSpells);
            list.removeAll(spells);
            if (list.isEmpty()) {
                list = npcSpells;
                list.removeAll(spells);
            }
            if (list.isEmpty()) continue;
            spells.add(list.get(random.nextInt(list.size())));
        }
        return maxTier;
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeInt(this.textureIndex);
    }

    public void readSpawnData(ByteBuf data) {
        this.textureIndex = data.readInt();
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source.func_76346_g() instanceof EntityPlayer) {
            WizardryAdvancementTriggers.anger_wizard.triggerFor((EntityPlayer)source.func_76346_g());
        }
        return super.func_70097_a(source, damage);
    }

    public void setTowerBlocks(Set<BlockPos> blocks) {
        this.towerBlocks = blocks;
    }

    public boolean isBlockPartOfTower(BlockPos pos) {
        if (this.towerBlocks == null) {
            return false;
        }
        return this.towerBlocks.contains(pos);
    }

    @SubscribeEvent
    public static void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        List<EntityWizard> wizards;
        if (!(event.getPlayer() instanceof FakePlayer) && !(wizards = WizardryUtilities.getEntitiesWithinRadius(64.0, event.getPos().func_177958_n(), event.getPos().func_177956_o(), event.getPos().func_177952_p(), event.getWorld(), EntityWizard.class)).isEmpty()) {
            for (EntityWizard wizard : wizards) {
                if (!wizard.isBlockPartOfTower(event.getPos())) continue;
                wizard.func_70604_c((EntityLivingBase)event.getPlayer());
                WizardryAdvancementTriggers.anger_wizard.triggerFor(event.getPlayer());
            }
        }
    }

    public static class EntityAITradePlayer
    extends EntityAIBase {
        private final EntityWizard wizard;

        public EntityAITradePlayer(EntityWizard wizard) {
            this.wizard = wizard;
            this.func_75248_a(5);
        }

        public boolean func_75250_a() {
            if (!this.wizard.func_70089_S()) {
                return false;
            }
            if (this.wizard.func_70090_H()) {
                return false;
            }
            if (!this.wizard.field_70122_E) {
                return false;
            }
            if (this.wizard.field_70133_I) {
                return false;
            }
            EntityPlayer entityplayer = this.wizard.func_70931_l_();
            if (entityplayer == null) {
                return false;
            }
            if (this.wizard.func_70068_e((Entity)entityplayer) > 16.0) {
                return false;
            }
            return entityplayer.field_71070_bA != null;
        }

        public void func_75249_e() {
            this.wizard.func_70661_as().func_75499_g();
        }

        public void func_75251_c() {
            this.wizard.func_70932_a_(null);
        }
    }

    public static class EntityAILookAtTradePlayer
    extends EntityAIWatchClosest {
        private final EntityWizard wizard;

        public EntityAILookAtTradePlayer(EntityWizard wizard) {
            super((EntityLiving)wizard, EntityPlayer.class, 8.0f);
            this.wizard = wizard;
        }

        public boolean func_75250_a() {
            if (this.wizard.isTrading()) {
                this.field_75334_a = this.wizard.func_70931_l_();
                return true;
            }
            return false;
        }
    }
}

