/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.entity.projectile;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public abstract class EntityMagicProjectile
extends EntityThrowable
implements IEntityAdditionalSpawnData {
    public float damageMultiplier = 1.0f;

    public EntityMagicProjectile(World world) {
        super(world);
    }

    public EntityMagicProjectile(World world, EntityLivingBase thrower) {
        super(world, thrower);
    }

    public EntityMagicProjectile(World world, EntityLivingBase thrower, float damageMultiplier) {
        super(world, thrower);
        this.func_184538_a((Entity)thrower, thrower.field_70125_A, thrower.field_70177_z, 0.0f, this.getSpeed(), 1.0f);
        this.damageMultiplier = damageMultiplier;
        this.field_184539_c = thrower;
    }

    public EntityMagicProjectile(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    protected float getSpeed() {
        return 1.5f;
    }

    public void directTowards(Entity target, float velocity) {
        double dx = target.field_70165_t - this.field_70165_t;
        double dy = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 2.0f) - (this.field_70163_u + (double)(this.field_70131_O / 2.0f));
        double dz = target.field_70161_v - this.field_70161_v;
        this.field_70159_w = dx / (double)this.func_70032_d(target) * (double)velocity;
        this.field_70181_x = dy / (double)this.func_70032_d(target) * (double)velocity;
        this.field_70179_y = dz / (double)this.func_70032_d(target) * (double)velocity;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.damageMultiplier = nbttagcompound.func_74760_g("damageMultiplier");
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74776_a("damageMultiplier", this.damageMultiplier);
    }

    public void writeSpawnData(ByteBuf data) {
        if (this.func_85052_h() != null) {
            data.writeInt(this.func_85052_h().func_145782_y());
        }
    }

    public void readSpawnData(ByteBuf data) {
        if (data.isReadable()) {
            Entity entity = this.field_70170_p.func_73045_a(data.readInt());
            if (entity instanceof EntityLivingBase) {
                this.field_70192_c = (EntityLivingBase)entity;
            }
            this.field_184539_c = this.field_70192_c;
        }
    }
}

