/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.item.ItemScroll;
import electroblob.wizardry.item.ItemSpellBook;
import electroblob.wizardry.spell.Spell;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import org.apache.commons.lang3.ArrayUtils;

public class RandomSpell
extends LootFunction {
    private final List<Spell> spells;
    private final boolean ignoreWeighting;
    private final List<Tier> tiers;
    private final List<Element> elements;

    protected RandomSpell(LootCondition[] conditions, List<Spell> spells, boolean ignoreWeighting, List<Tier> tiers, List<Element> elements) {
        super(conditions);
        this.spells = spells;
        this.ignoreWeighting = ignoreWeighting;
        this.tiers = tiers;
        this.elements = elements;
    }

    public ItemStack func_186553_a(ItemStack stack, Random random, LootContext context) {
        Element element;
        if (!(stack.func_77973_b() instanceof ItemSpellBook) && !(stack.func_77973_b() instanceof ItemScroll)) {
            Wizardry.logger.warn("Applying the random_spell loot function to an item that isn't a spell book or scroll.");
        }
        Tier tier = this.ignoreWeighting ? (this.tiers == null || this.tiers.isEmpty() ? Tier.values()[random.nextInt(Tier.values().length)] : this.tiers.get(random.nextInt(this.tiers.size()))) : (this.tiers == null || this.tiers.isEmpty() ? Tier.getWeightedRandomTier(random, new Tier[0]) : Tier.getWeightedRandomTier(random, this.tiers.toArray(new Tier[0])));
        if (this.elements == null || this.elements.isEmpty()) {
            if (tier == Tier.BASIC) {
                element = Element.values()[random.nextInt(Element.values().length)];
            } else {
                Element[] elements = (Element[])ArrayUtils.removeElement((Object[])Element.values(), (Object)((Object)Element.MAGIC));
                element = elements[random.nextInt(elements.length)];
            }
        } else {
            element = this.elements.get(random.nextInt(this.elements.size()));
        }
        List<Spell> spellsList = Spell.getSpells(new Spell.TierElementFilter(tier, element));
        if (stack.func_77973_b() instanceof ItemScroll) {
            spellsList.retainAll(Spell.getSpells(Spell.nonContinuousSpells));
        }
        if (this.spells != null && !this.spells.isEmpty()) {
            spellsList.retainAll(this.spells);
        }
        if (spellsList.isEmpty()) {
            Wizardry.logger.warn("Tried to apply the random_spell loot function to an item, but no enabled spellsmatched the criteria specified. Substituting placeholder (metadata 0) item.");
            stack.func_77964_b(0);
        } else {
            stack.func_77964_b(spellsList.get(random.nextInt(spellsList.size())).id());
        }
        return stack;
    }

    public static class Serializer
    extends LootFunction.Serializer<RandomSpell> {
        public Serializer() {
            super(new ResourceLocation("ebwizardry", "random_spell"), RandomSpell.class);
        }

        public void serialize(JsonObject object, RandomSpell function, JsonSerializationContext serializationContext) {
            JsonArray jsonarray;
            if (function.spells != null && !function.spells.isEmpty()) {
                jsonarray = new JsonArray();
                for (Spell spell : function.spells) {
                    jsonarray.add((JsonElement)new JsonPrimitive(spell.getRegistryName().toString()));
                }
                object.add("spells", (JsonElement)jsonarray);
            }
            object.addProperty("ignore_weighting", Boolean.valueOf(function.ignoreWeighting));
            if (function.tiers != null && !function.tiers.isEmpty()) {
                jsonarray = new JsonArray();
                for (Tier tier : function.tiers) {
                    jsonarray.add((JsonElement)new JsonPrimitive(tier.getUnlocalisedName()));
                }
                object.add("tiers", (JsonElement)jsonarray);
            }
            if (function.elements != null && !function.elements.isEmpty()) {
                jsonarray = new JsonArray();
                for (Element element : function.elements) {
                    jsonarray.add((JsonElement)new JsonPrimitive(element.getUnlocalisedName()));
                }
                object.add("elements", (JsonElement)jsonarray);
            }
        }

        public RandomSpell deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootCondition[] conditions) {
            String string;
            ArrayList<Spell> spells = null;
            ArrayList<Tier> tiers = null;
            ArrayList<Element> elements = null;
            if (object.has("spells")) {
                spells = new ArrayList<Spell>();
                for (JsonElement element : JsonUtils.func_151213_a((JsonObject)object, (String)"spells", (JsonArray)new JsonArray())) {
                    String string2 = JsonUtils.func_151206_a((JsonElement)element, (String)"spell");
                    Spell spell = Spell.get(string2);
                    if (spell == null) {
                        throw new JsonSyntaxException("Unknown spell '" + string2 + "'");
                    }
                    spells.add(spell);
                }
            }
            boolean ignoreWeighting = JsonUtils.func_151209_a((JsonObject)object, (String)"ignore_weighting", (boolean)false);
            if (object.has("tiers")) {
                tiers = new ArrayList<Tier>();
                block1: for (JsonElement element : JsonUtils.func_151213_a((JsonObject)object, (String)"tiers", (JsonArray)new JsonArray())) {
                    string = JsonUtils.func_151206_a((JsonElement)element, (String)"tier");
                    for (Enum enum_ : Tier.values()) {
                        if (!((Tier)enum_).getUnlocalisedName().equals(string)) continue;
                        tiers.add((Tier)enum_);
                        continue block1;
                    }
                    throw new JsonSyntaxException("Unknown tier '" + string + "'");
                }
            }
            if (object.has("elements")) {
                elements = new ArrayList<Element>();
                block3: for (JsonElement jelement : JsonUtils.func_151213_a((JsonObject)object, (String)"elements", (JsonArray)new JsonArray())) {
                    string = JsonUtils.func_151206_a((JsonElement)jelement, (String)"element");
                    for (Enum enum_ : Element.values()) {
                        if (!((Element)enum_).getUnlocalisedName().equals(string)) continue;
                        elements.add((Element)enum_);
                        continue block3;
                    }
                    throw new JsonSyntaxException("Unknown element '" + string + "'");
                }
            }
            return new RandomSpell(conditions, spells, ignoreWeighting, tiers, elements);
        }
    }
}

