/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.entity.construct.EntityArrowRain;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class ArrowRain
extends Spell {
    public ArrowRain() {
        super(Tier.MASTER, 75, Element.SORCERY, "arrow_rain", SpellType.ATTACK, 300, EnumAction.NONE, false);
    }

    @Override
    public boolean doesSpellRequirePacket() {
        return false;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        RayTraceResult rayTrace = WizardryUtilities.rayTrace(20.0f * modifiers.get(WizardryItems.range_upgrade), world, (EntityLivingBase)caster, false);
        if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.BLOCK) {
            if (!world.field_72995_K) {
                double x = rayTrace.field_72307_f.field_72450_a;
                double y = rayTrace.field_72307_f.field_72448_b;
                double z = rayTrace.field_72307_f.field_72449_c;
                double dx = caster.field_70165_t - x;
                double dz = caster.field_70161_v - z;
                double distRatio = 3.0 / Math.sqrt(dx * dx + dz * dz);
                EntityArrowRain arrowrain = new EntityArrowRain(world, x += dx * distRatio, y + 5.0, z += dz * distRatio, (EntityLivingBase)caster, (int)(120.0f * modifiers.get(WizardryItems.duration_upgrade)), modifiers.get("damage"));
                arrowrain.field_70177_z = caster.field_70759_as;
                world.func_72838_d((Entity)arrowrain);
            }
            caster.func_184609_a(hand);
            WizardryUtilities.playSoundAtPlayer(caster, WizardrySounds.SPELL_SUMMONING, 1.0f, 1.0f);
            return true;
        }
        return false;
    }
}

