/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryParticleType;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class Banish
extends Spell {
    public Banish() {
        super(Tier.APPRENTICE, 15, Element.NECROMANCY, "banish", SpellType.ATTACK, 40, EnumAction.NONE, false);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        Vec3d look = caster.func_70040_Z();
        RayTraceResult rayTrace = WizardryUtilities.standardEntityRayTrace(world, (EntityLivingBase)caster, 10.0f * modifiers.get(WizardryItems.range_upgrade));
        if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.ENTITY && rayTrace.field_72308_g instanceof EntityLivingBase) {
            EntityLivingBase target = (EntityLivingBase)rayTrace.field_72308_g;
            double radius = (8.0 + world.field_73012_v.nextDouble() * 8.0) * (double)modifiers.get(WizardryItems.range_upgrade);
            double angle = world.field_73012_v.nextDouble() * Math.PI * 2.0;
            int x = MathHelper.func_76128_c((double)(target.field_70165_t + Math.sin(angle) * radius));
            int z = MathHelper.func_76128_c((double)(target.field_70161_v - Math.cos(angle) * radius));
            int y = WizardryUtilities.getNearestFloorLevel(world, new BlockPos(x, (int)caster.func_174813_aQ().field_72338_b, z), (int)radius);
            if (world.field_72995_K) {
                for (int i = 0; i < 10; ++i) {
                    double dx1 = target.field_70165_t;
                    double dy1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O * world.field_73012_v.nextFloat());
                    double dz1 = target.field_70161_v;
                    world.func_175688_a(EnumParticleTypes.PORTAL, dx1, dy1, dz1, world.field_73012_v.nextDouble() - 0.5, world.field_73012_v.nextDouble() - 0.5, world.field_73012_v.nextDouble() - 0.5, new int[0]);
                }
            }
            if (y > -1) {
                if (!world.func_180495_p(new BlockPos(x, y, z)).func_185904_a().func_76230_c()) {
                    --y;
                }
                if (world.func_180495_p(new BlockPos(x, y + 1, z)).func_185904_a().func_76230_c() || world.func_180495_p(new BlockPos(x, y + 2, z)).func_185904_a().func_76230_c()) {
                    return false;
                }
                if (!world.field_72995_K) {
                    target.func_70634_a((double)x + 0.5, (double)(y + 1), (double)z + 0.5);
                }
                target.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
            }
        }
        if (world.field_72995_K) {
            for (int i = 1; i < (int)(25.0f * modifiers.get(WizardryItems.range_upgrade)); i += 2) {
                double x1 = caster.field_70165_t + look.field_72450_a * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                double y1 = WizardryUtilities.getPlayerEyesPos(caster) - (double)0.4f + look.field_72448_b * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                double z1 = caster.field_70161_v + look.field_72449_c * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                world.func_175688_a(EnumParticleTypes.PORTAL, x1, y1 - 0.5, z1, 0.0, 0.0, 0.0, new int[0]);
                Wizardry.proxy.spawnParticle(WizardryParticleType.DARK_MAGIC, world, x1, y1, z1, 0.0, 0.0, 0.0, 0, 0.2f, 0.0f, 0.2f);
            }
        }
        WizardryUtilities.playSoundAtPlayer(caster, SoundEvents.field_187534_aX, 1.0f, 1.0f);
        caster.func_184609_a(hand);
        return true;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        if (target != null) {
            double radius = (8.0 + world.field_73012_v.nextDouble() * 8.0) * (double)modifiers.get(WizardryItems.range_upgrade);
            double angle = world.field_73012_v.nextDouble() * Math.PI * 2.0;
            int x = MathHelper.func_76128_c((double)(target.field_70165_t + Math.sin(angle) * radius));
            int z = MathHelper.func_76128_c((double)(target.field_70161_v - Math.cos(angle) * radius));
            int y = WizardryUtilities.getNearestFloorLevel(world, new BlockPos(x, (int)caster.func_174813_aQ().field_72338_b, z), (int)radius);
            if (world.field_72995_K) {
                int i;
                double dx = (target.field_70165_t - caster.field_70165_t) / (double)caster.func_70032_d((Entity)target);
                double dy = (target.field_70163_u - caster.field_70163_u) / (double)caster.func_70032_d((Entity)target);
                double dz = (target.field_70161_v - caster.field_70161_v) / (double)caster.func_70032_d((Entity)target);
                for (i = 1; i < 25; i += 2) {
                    double x1 = caster.field_70165_t + dx * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                    double y1 = caster.field_70163_u + (double)caster.func_70047_e() - (double)0.4f + dy * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                    double z1 = caster.field_70161_v + dz * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                    world.func_175688_a(EnumParticleTypes.PORTAL, x1, y1 - 0.5, z1, 0.0, 0.0, 0.0, new int[0]);
                    Wizardry.proxy.spawnParticle(WizardryParticleType.DARK_MAGIC, world, x1, y1, z1, 0.0, 0.0, 0.0, 0, 0.2f, 0.0f, 0.2f);
                }
                for (i = 0; i < 10; ++i) {
                    double dx1 = target.field_70165_t;
                    double dy1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O * world.field_73012_v.nextFloat());
                    double dz1 = target.field_70161_v;
                    world.func_175688_a(EnumParticleTypes.PORTAL, dx1, dy1, dz1, world.field_73012_v.nextDouble() - 0.5, world.field_73012_v.nextDouble() - 0.5, world.field_73012_v.nextDouble() - 0.5, new int[0]);
                }
            }
            if (y > -1) {
                if (!world.func_180495_p(new BlockPos(x, y, z)).func_185904_a().func_76230_c()) {
                    --y;
                }
                if (world.func_180495_p(new BlockPos(x, y + 1, z)).func_185904_a().func_76230_c() || world.func_180495_p(new BlockPos(x, y + 2, z)).func_185904_a().func_76230_c()) {
                    return false;
                }
                if (!world.field_72995_K) {
                    target.func_70634_a((double)x + 0.5, (double)(y + 1), (double)z + 0.5);
                }
                target.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
            }
        }
        caster.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        caster.func_184609_a(hand);
        return true;
    }

    @Override
    public boolean canBeCastByNPCs() {
        return true;
    }
}

