/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class Detonate
extends Spell {
    public Detonate() {
        super(Tier.ADVANCED, 45, Element.FIRE, "detonate", SpellType.ATTACK, 50, EnumAction.NONE, false);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        RayTraceResult rayTrace = WizardryUtilities.rayTrace(16.0f * modifiers.get(WizardryItems.range_upgrade), world, (EntityLivingBase)caster, false);
        if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.BLOCK) {
            if (!world.field_72995_K) {
                List<EntityLivingBase> targets = WizardryUtilities.getEntitiesWithinRadius(3.0 * (double)modifiers.get(WizardryItems.blast_upgrade), rayTrace.field_72307_f.field_72450_a + 0.5, rayTrace.field_72307_f.field_72448_b + 0.5, rayTrace.field_72307_f.field_72449_c + 0.5, world);
                for (int i = 0; i < targets.size(); ++i) {
                    targets.get(i).func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, MagicDamage.DamageType.BLAST), Math.max(12.0f - (float)targets.get(i).func_70011_f(rayTrace.field_72307_f.field_72450_a + 0.5, rayTrace.field_72307_f.field_72448_b + 0.5, rayTrace.field_72307_f.field_72449_c + 0.5) * 4.0f, 0.0f) * modifiers.get("damage"));
                }
            }
            if (world.field_72995_K) {
                double dx = rayTrace.field_72307_f.field_72450_a + 0.5 - caster.field_70165_t;
                double dy = rayTrace.field_72307_f.field_72448_b + 0.5 - WizardryUtilities.getPlayerEyesPos(caster);
                double dz = rayTrace.field_72307_f.field_72449_c + 0.5 - caster.field_70161_v;
                world.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, rayTrace.field_72307_f.field_72450_a + 0.5, rayTrace.field_72307_f.field_72448_b + 0.5, rayTrace.field_72307_f.field_72449_c + 0.5, 0.0, 0.0, 0.0, new int[0]);
                for (int i = 1; i < 5; ++i) {
                    world.func_175688_a(EnumParticleTypes.FLAME, caster.field_70165_t + (double)i * (dx / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), WizardryUtilities.getPlayerEyesPos(caster) + (double)i * (dy / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), caster.field_70161_v + (double)i * (dz / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), 0.0, 0.0, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.FLAME, caster.field_70165_t + (double)i * (dx / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), WizardryUtilities.getPlayerEyesPos(caster) + (double)i * (dy / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), caster.field_70161_v + (double)i * (dz / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), 0.0, 0.0, 0.0, new int[0]);
                }
            }
            world.func_184148_a(caster, rayTrace.field_72307_f.field_72450_a + 0.5, rayTrace.field_72307_f.field_72448_b + 0.5, rayTrace.field_72307_f.field_72449_c + 0.5, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            caster.func_184609_a(hand);
            return true;
        }
        return false;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        if (target != null) {
            if (!world.field_72995_K) {
                List<EntityLivingBase> targets = WizardryUtilities.getEntitiesWithinRadius(3.0, target.field_70165_t, target.field_70163_u, target.field_70161_v, world);
                for (int i = 0; i < targets.size(); ++i) {
                    targets.get(i).func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, MagicDamage.DamageType.BLAST), Math.max(12.0f - (float)targets.get(i).func_70011_f(target.field_70165_t, target.field_70163_u, target.field_70161_v) * 4.0f, 0.0f) * modifiers.get("damage"));
                }
            }
            if (world.field_72995_K) {
                double dx = target.field_70165_t - caster.field_70165_t;
                double dy = target.field_70163_u - (caster.field_70163_u + (double)caster.func_70047_e());
                double dz = target.field_70161_v - caster.field_70161_v;
                world.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, target.field_70165_t, target.field_70163_u, target.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
                for (int i = 1; i < 5; ++i) {
                    world.func_175688_a(EnumParticleTypes.FLAME, caster.field_70165_t + (double)i * (dx / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), caster.field_70163_u + (double)caster.func_70047_e() + (double)i * (dy / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), caster.field_70161_v + (double)i * (dz / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), 0.0, 0.0, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.FLAME, caster.field_70165_t + (double)i * (dx / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), caster.field_70163_u + (double)caster.func_70047_e() + (double)i * (dy / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), caster.field_70161_v + (double)i * (dz / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), 0.0, 0.0, 0.0, new int[0]);
                }
            }
            world.func_184148_a(null, target.field_70165_t, target.field_70163_u, target.field_70161_v, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            caster.func_184609_a(hand);
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeCastByNPCs() {
        return true;
    }
}

