/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryParticleType;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class FontOfMana
extends Spell {
    public FontOfMana() {
        super(Tier.MASTER, 100, Element.HEALING, "font_of_mana", SpellType.UTILITY, 250, EnumAction.BOW, false);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        List<EntityPlayer> targets = WizardryUtilities.getEntitiesWithinRadius(5.0f * modifiers.get(WizardryItems.blast_upgrade), caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, world, EntityPlayer.class);
        for (EntityPlayer target : targets) {
            if (!WizardryUtilities.isPlayerAlly(caster, target) && target != caster) continue;
            target.func_70690_d(new PotionEffect(WizardryPotions.font_of_mana, (int)(600.0f * modifiers.get(WizardryItems.duration_upgrade)), modifiers.get("damage") > 1.0f ? 1 : 0));
        }
        if (world.field_72995_K) {
            int i = 0;
            while ((float)i < 100.0f * modifiers.get(WizardryItems.blast_upgrade)) {
                double radius = (1.0 + world.field_73012_v.nextDouble() * 4.0) * (double)modifiers.get(WizardryItems.blast_upgrade);
                double angle = world.field_73012_v.nextDouble() * Math.PI * 2.0;
                float hue = world.field_73012_v.nextFloat() * 0.4f;
                Wizardry.proxy.spawnParticle(WizardryParticleType.SPARKLE, world, caster.field_70165_t + radius * Math.cos(angle), caster.func_174813_aQ().field_72338_b, caster.field_70161_v + radius * Math.sin(angle), 0.0, 0.03, 0.0, 50, 1.0f, 1.0f - hue, 0.6f + hue);
                ++i;
            }
        }
        WizardryUtilities.playSoundAtPlayer(caster, WizardrySounds.SPELL_HEAL, 0.7f, world.field_73012_v.nextFloat() * 0.4f + 1.0f);
        return true;
    }
}

