/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.entity.construct.EntityIceSpike;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class IceSpikes
extends Spell {
    public IceSpikes() {
        super(Tier.ADVANCED, 30, Element.ICE, "ice_spikes", SpellType.ATTACK, 75, EnumAction.NONE, false);
    }

    @Override
    public boolean doesSpellRequirePacket() {
        return false;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        RayTraceResult rayTrace = WizardryUtilities.rayTrace(20.0f * modifiers.get(WizardryItems.range_upgrade), world, (EntityLivingBase)caster, false);
        if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.BLOCK && rayTrace.field_178784_b == EnumFacing.UP) {
            if (!world.field_72995_K) {
                double x = rayTrace.field_72307_f.field_72450_a;
                double y = rayTrace.field_72307_f.field_72448_b;
                double z = rayTrace.field_72307_f.field_72449_c;
                for (int i = 0; i < (int)(18.0f * modifiers.get(WizardryItems.blast_upgrade)); ++i) {
                    float angle = (float)((double)world.field_73012_v.nextFloat() * Math.PI * 2.0);
                    double radius = 0.5 + world.field_73012_v.nextDouble() * 2.0 * (double)modifiers.get(WizardryItems.blast_upgrade);
                    double x1 = x + radius * (double)MathHelper.func_76126_a((float)angle);
                    double z1 = z + radius * (double)MathHelper.func_76134_b((float)angle);
                    double y1 = WizardryUtilities.getNearestFloorLevel(world, new BlockPos(MathHelper.func_76128_c((double)x1), (int)y, MathHelper.func_76128_c((double)z1)), 2) - 1;
                    if (!(y1 > -1.0)) continue;
                    EntityIceSpike icespike = new EntityIceSpike(world, x1, y1, z1, (EntityLivingBase)caster, 30 + world.field_73012_v.nextInt(15), modifiers.get("damage"));
                    world.func_72838_d((Entity)icespike);
                }
            }
            caster.func_184609_a(hand);
            WizardryUtilities.playSoundAtPlayer(caster, WizardrySounds.SPELL_ICE, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        if (target != null) {
            if (!world.field_72995_K) {
                double x = target.field_70165_t;
                double y = target.field_70163_u;
                double z = target.field_70161_v;
                for (int i = 0; i < (int)(18.0f * modifiers.get(WizardryItems.blast_upgrade)); ++i) {
                    float angle = (float)((double)world.field_73012_v.nextFloat() * Math.PI * 2.0);
                    double radius = 0.5 + world.field_73012_v.nextDouble() * 2.0 * (double)modifiers.get(WizardryItems.blast_upgrade);
                    double x1 = x + radius * (double)MathHelper.func_76126_a((float)angle);
                    double z1 = z + radius * (double)MathHelper.func_76134_b((float)angle);
                    double y1 = WizardryUtilities.getNearestFloorLevel(world, new BlockPos(MathHelper.func_76128_c((double)x1), (int)y, MathHelper.func_76128_c((double)z1)), 2) - 1;
                    if (!(y1 > -1.0)) continue;
                    EntityIceSpike icespike = new EntityIceSpike(world, x1, y1, z1, (EntityLivingBase)caster, 30 + world.field_73012_v.nextInt(15), modifiers.get("damage"));
                    world.func_72838_d((Entity)icespike);
                }
            }
            caster.func_184609_a(hand);
            caster.func_184185_a(WizardrySounds.SPELL_ICE, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeCastByNPCs() {
        return true;
    }
}

