/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.tileentity.TileEntityTimer;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class Light
extends Spell {
    public Light() {
        super(Tier.BASIC, 5, Element.SORCERY, "light", SpellType.UTILITY, 15, EnumAction.NONE, false);
    }

    @Override
    public boolean doesSpellRequirePacket() {
        return false;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        RayTraceResult rayTrace = WizardryUtilities.rayTrace(4.0, world, (EntityLivingBase)caster, false);
        if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos = rayTrace.func_178782_a().func_177972_a(rayTrace.field_178784_b);
            if (world.func_175623_d(pos)) {
                if (!world.field_72995_K) {
                    world.func_175656_a(pos, WizardryBlocks.magic_light.func_176223_P());
                    if (world.func_175625_s(pos) instanceof TileEntityTimer) {
                        ((TileEntityTimer)world.func_175625_s(pos)).setLifetime((int)(600.0f * modifiers.get(WizardryItems.duration_upgrade)));
                    }
                }
                caster.func_184609_a(hand);
                WizardryUtilities.playSoundAtPlayer(caster, WizardrySounds.SPELL_CONJURATION, 1.0f, 1.0f);
                return true;
            }
        } else {
            int z;
            int y;
            int x = (int)(Math.floor(caster.field_70165_t) + caster.func_70040_Z().field_72450_a * 4.0);
            BlockPos pos = new BlockPos(x, y = (int)(Math.floor(caster.field_70163_u) + (double)caster.eyeHeight + caster.func_70040_Z().field_72448_b * 4.0), z = (int)(Math.floor(caster.field_70161_v) + caster.func_70040_Z().field_72449_c * 4.0));
            if (world.func_175623_d(pos)) {
                if (!world.field_72995_K) {
                    world.func_175656_a(pos, WizardryBlocks.magic_light.func_176223_P());
                    if (world.func_175625_s(pos) instanceof TileEntityTimer) {
                        ((TileEntityTimer)world.func_175625_s(pos)).setLifetime((int)(600.0f * modifiers.get(WizardryItems.duration_upgrade)));
                    }
                }
                caster.func_184609_a(hand);
                WizardryUtilities.playSoundAtPlayer(caster, WizardrySounds.SPELL_CONJURATION, 1.0f, 1.0f);
                return true;
            }
        }
        return false;
    }
}

