/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.entity.EntityArc;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryParticleType;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class LightningWeb
extends Spell {
    public LightningWeb() {
        super(Tier.MASTER, 15, Element.LIGHTNING, "lightning_web", SpellType.ATTACK, 0, EnumAction.NONE, true);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        RayTraceResult rayTrace = WizardryUtilities.standardEntityRayTrace(world, (EntityLivingBase)caster, 10.0f * modifiers.get(WizardryItems.range_upgrade), 2.0f);
        if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.ENTITY && WizardryUtilities.isLiving(rayTrace.field_72308_g)) {
            Entity target = rayTrace.field_72308_g;
            if (!world.field_72995_K) {
                if (ticksInUse % 2 == 0) {
                    EntityArc arc = new EntityArc(world);
                    arc.setEndpointCoords(caster.field_70165_t, caster.field_70163_u + 1.2, caster.field_70161_v, target.field_70165_t, target.field_70163_u + (double)(target.field_70131_O / 2.0f), target.field_70161_v);
                    arc.lifetime = 1;
                    world.func_72838_d((Entity)arc);
                }
                if (MagicDamage.isEntityImmune(MagicDamage.DamageType.SHOCK, target)) {
                    if (!world.field_72995_K && ticksInUse == 1) {
                        caster.func_145747_a((ITextComponent)new TextComponentTranslation("spell.resist", new Object[]{target.func_70005_c_(), this.getNameForTranslationFormatted()}));
                    }
                } else {
                    double motionX = target.field_70159_w;
                    double motionY = target.field_70181_x;
                    double motionZ = target.field_70179_y;
                    target.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, MagicDamage.DamageType.SHOCK), 5.0f * modifiers.get("damage"));
                    target.field_70159_w = motionX;
                    target.field_70181_x = motionY;
                    target.field_70179_y = motionZ;
                }
            } else {
                for (int i = 0; i < 5; ++i) {
                    Wizardry.proxy.spawnParticle(WizardryParticleType.SPARK, world, target.field_70165_t + (double)world.field_73012_v.nextFloat() - 0.5, target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 2.0f) + (double)(world.field_73012_v.nextFloat() * 2.0f) - 1.0, target.field_70161_v + (double)world.field_73012_v.nextFloat() - 0.5, 0.0, 0.0, 0.0, 3);
                }
            }
            double seekerRange = 5.0;
            List<EntityLivingBase> secondaryTargets = WizardryUtilities.getEntitiesWithinRadius(seekerRange, target.field_70165_t, target.field_70163_u + (double)(target.field_70131_O / 2.0f), target.field_70161_v, world);
            secondaryTargets.remove(target);
            if (secondaryTargets.size() > 5) {
                secondaryTargets = secondaryTargets.subList(0, 5);
            }
            for (EntityLivingBase secondaryTarget : secondaryTargets) {
                if (!WizardryUtilities.isValidTarget((Entity)caster, (Entity)secondaryTarget)) continue;
                if (!world.field_72995_K) {
                    if (ticksInUse % 2 == 0) {
                        EntityArc arc = new EntityArc(world);
                        arc.setEndpointCoords(target.field_70165_t, target.field_70163_u + 1.2, target.field_70161_v, secondaryTarget.field_70165_t, secondaryTarget.field_70163_u + (double)(secondaryTarget.field_70131_O / 2.0f), secondaryTarget.field_70161_v);
                        arc.lifetime = 1;
                        world.func_72838_d((Entity)arc);
                    }
                    if (MagicDamage.isEntityImmune(MagicDamage.DamageType.SHOCK, (Entity)secondaryTarget)) {
                        if (!world.field_72995_K && ticksInUse == 1) {
                            caster.func_145747_a((ITextComponent)new TextComponentTranslation("spell.resist", new Object[]{secondaryTarget.func_70005_c_(), this.getNameForTranslationFormatted()}));
                        }
                    } else {
                        double motionX = secondaryTarget.field_70159_w;
                        double motionY = secondaryTarget.field_70181_x;
                        double motionZ = secondaryTarget.field_70179_y;
                        secondaryTarget.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, MagicDamage.DamageType.SHOCK), 4.0f * modifiers.get("damage"));
                        secondaryTarget.field_70159_w = motionX;
                        secondaryTarget.field_70181_x = motionY;
                        secondaryTarget.field_70179_y = motionZ;
                    }
                } else {
                    for (int i = 0; i < 5; ++i) {
                        Wizardry.proxy.spawnParticle(WizardryParticleType.SPARK, world, secondaryTarget.field_70165_t + (double)world.field_73012_v.nextFloat() - 0.5, secondaryTarget.func_174813_aQ().field_72338_b + (double)(secondaryTarget.field_70131_O / 2.0f) + (double)(world.field_73012_v.nextFloat() * 2.0f) - 1.0, secondaryTarget.field_70161_v + (double)world.field_73012_v.nextFloat() - 0.5, 0.0, 0.0, 0.0, 3);
                    }
                }
                List<EntityLivingBase> tertiaryTargets = WizardryUtilities.getEntitiesWithinRadius(seekerRange, secondaryTarget.field_70165_t, secondaryTarget.field_70163_u + (double)(secondaryTarget.field_70131_O / 2.0f), secondaryTarget.field_70161_v, world);
                tertiaryTargets.remove(target);
                tertiaryTargets.removeAll(secondaryTargets);
                if (tertiaryTargets.size() > 2) {
                    tertiaryTargets = tertiaryTargets.subList(0, 2);
                }
                for (EntityLivingBase tertiaryTarget : tertiaryTargets) {
                    if (!WizardryUtilities.isValidTarget((Entity)caster, (Entity)tertiaryTarget)) continue;
                    if (!world.field_72995_K) {
                        if (ticksInUse % 2 == 0) {
                            EntityArc arc = new EntityArc(world);
                            arc.setEndpointCoords(secondaryTarget.field_70165_t, secondaryTarget.field_70163_u + 1.2, secondaryTarget.field_70161_v, tertiaryTarget.field_70165_t, tertiaryTarget.field_70163_u + (double)(tertiaryTarget.field_70131_O / 2.0f), tertiaryTarget.field_70161_v);
                            arc.lifetime = 1;
                            world.func_72838_d((Entity)arc);
                        }
                        if (MagicDamage.isEntityImmune(MagicDamage.DamageType.SHOCK, (Entity)tertiaryTarget)) {
                            if (world.field_72995_K || ticksInUse != 1) continue;
                            caster.func_145747_a((ITextComponent)new TextComponentTranslation("spell.resist", new Object[]{tertiaryTarget.func_70005_c_(), this.getNameForTranslationFormatted()}));
                            continue;
                        }
                        double motionX = tertiaryTarget.field_70159_w;
                        double motionY = tertiaryTarget.field_70181_x;
                        double motionZ = tertiaryTarget.field_70179_y;
                        tertiaryTarget.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, MagicDamage.DamageType.SHOCK), 3.0f * modifiers.get("damage"));
                        tertiaryTarget.field_70159_w = motionX;
                        tertiaryTarget.field_70181_x = motionY;
                        tertiaryTarget.field_70179_y = motionZ;
                        continue;
                    }
                    for (int i = 0; i < 5; ++i) {
                        Wizardry.proxy.spawnParticle(WizardryParticleType.SPARK, world, tertiaryTarget.field_70165_t + (double)world.field_73012_v.nextFloat() - 0.5, tertiaryTarget.func_174813_aQ().field_72338_b + (double)(tertiaryTarget.field_70131_O / 2.0f) + (double)(world.field_73012_v.nextFloat() * 2.0f) - 1.0, tertiaryTarget.field_70161_v + (double)world.field_73012_v.nextFloat() - 0.5, 0.0, 0.0, 0.0, 3);
                    }
                }
            }
            if (ticksInUse == 1) {
                WizardryUtilities.playSoundAtPlayer(caster, WizardrySounds.SPELL_LIGHTNING, 1.0f, 1.0f);
            } else if (ticksInUse > 0 && ticksInUse % 20 == 0) {
                WizardryUtilities.playSoundAtPlayer(caster, WizardrySounds.SPELL_LOOP_LIGHTNING, 1.0f, 1.0f);
            }
            return true;
        }
        if (!world.field_72995_K && ticksInUse % 2 == 0) {
            EntityArc arc = new EntityArc(world);
            arc.setEndpointCoords(caster.field_70165_t, caster.field_70163_u + 1.2, caster.field_70161_v, caster.field_70165_t + caster.func_70040_Z().field_72450_a * 8.0, caster.field_70163_u + (double)caster.eyeHeight + caster.func_70040_Z().field_72448_b * 8.0, caster.field_70161_v + caster.func_70040_Z().field_72449_c * 8.0);
            arc.lifetime = 1;
            world.func_72838_d((Entity)arc);
        }
        if (ticksInUse == 1) {
            WizardryUtilities.playSoundAtPlayer(caster, WizardrySounds.SPELL_LIGHTNING, 1.0f, 1.0f);
        } else if (ticksInUse > 0 && ticksInUse % 20 == 0) {
            WizardryUtilities.playSoundAtPlayer(caster, WizardrySounds.SPELL_LOOP_LIGHTNING, 1.0f, 1.0f);
        }
        return true;
    }
}

