/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.entity.projectile.EntityMagicMissile;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class MagicMissile
extends Spell {
    public MagicMissile() {
        super(Tier.BASIC, 5, Element.MAGIC, "magic_missile", SpellType.ATTACK, 10, EnumAction.NONE, false);
    }

    @Override
    public boolean doesSpellRequirePacket() {
        return false;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (!world.field_72995_K) {
            EntityMagicMissile magicMissile = new EntityMagicMissile(world, (EntityLivingBase)caster, 2.0f * modifiers.get(WizardryItems.range_upgrade), modifiers.get("damage"));
            world.func_72838_d((Entity)magicMissile);
        }
        caster.func_184609_a(hand);
        WizardryUtilities.playSoundAtPlayer(caster, WizardrySounds.SPELL_MAGIC, 1.0f, world.field_73012_v.nextFloat() * 0.4f + 1.2f);
        return true;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        if (target != null) {
            if (!world.field_72995_K) {
                EntityMagicMissile magicMissile = new EntityMagicMissile(world, (EntityLivingBase)caster, (Entity)target, 2.0f * modifiers.get(WizardryItems.range_upgrade), 4.0f, modifiers.get("damage"));
                world.func_72838_d((Entity)magicMissile);
            }
            caster.func_184609_a(hand);
            caster.func_184185_a(WizardrySounds.SPELL_MAGIC, 1.0f, world.field_73012_v.nextFloat() * 0.4f + 1.2f);
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeCastByNPCs() {
        return true;
    }
}

