/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.tileentity.TileEntityStatue;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryParticleType;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class Petrify
extends Spell {
    private static final int baseDuration = 900;
    public static final String NBT_KEY = "petrified";

    public Petrify() {
        super(Tier.ADVANCED, 40, Element.SORCERY, "petrify", SpellType.ATTACK, 100, EnumAction.NONE, false);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        Vec3d look = caster.func_70040_Z();
        RayTraceResult rayTrace = WizardryUtilities.standardEntityRayTrace(world, (EntityLivingBase)caster, 10.0f * modifiers.get(WizardryItems.range_upgrade));
        if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.ENTITY && rayTrace.field_72308_g instanceof EntityLiving && !world.field_72995_K) {
            EntityLiving target = (EntityLiving)rayTrace.field_72308_g;
            if (target.field_70725_aQ > 0) {
                return false;
            }
            BlockPos pos = new BlockPos((Entity)target);
            target.func_70066_B();
            if (((double)target.field_70131_O < 1.2 || target.func_70631_g_()) && WizardryUtilities.canBlockBeReplaced(world, pos)) {
                world.func_175656_a(pos, WizardryBlocks.petrified_stone.func_176223_P());
                if (world.func_175625_s(pos) instanceof TileEntityStatue) {
                    ((TileEntityStatue)world.func_175625_s(pos)).setCreatureAndPart(target, 1, 1);
                    ((TileEntityStatue)world.func_175625_s(pos)).setLifetime((int)(900.0f * modifiers.get(WizardryItems.duration_upgrade)));
                }
                target.getEntityData().func_74757_a(NBT_KEY, true);
                target.func_70106_y();
            } else if ((double)target.field_70131_O < 2.5 && WizardryUtilities.canBlockBeReplaced(world, pos) && WizardryUtilities.canBlockBeReplaced(world, pos.func_177984_a())) {
                world.func_175656_a(pos, WizardryBlocks.petrified_stone.func_176223_P());
                if (world.func_175625_s(pos) instanceof TileEntityStatue) {
                    ((TileEntityStatue)world.func_175625_s(pos)).setCreatureAndPart(target, 1, 2);
                    ((TileEntityStatue)world.func_175625_s(pos)).setLifetime((int)(900.0f * modifiers.get(WizardryItems.duration_upgrade)));
                }
                world.func_175656_a(pos.func_177984_a(), WizardryBlocks.petrified_stone.func_176223_P());
                if (world.func_175625_s(pos.func_177984_a()) instanceof TileEntityStatue) {
                    ((TileEntityStatue)world.func_175625_s(pos.func_177984_a())).setCreatureAndPart(target, 2, 2);
                }
                target.getEntityData().func_74757_a(NBT_KEY, true);
                target.func_70106_y();
            } else if (WizardryUtilities.canBlockBeReplaced(world, pos) && WizardryUtilities.canBlockBeReplaced(world, pos.func_177984_a()) && WizardryUtilities.canBlockBeReplaced(world, pos.func_177981_b(2))) {
                world.func_175656_a(pos, WizardryBlocks.petrified_stone.func_176223_P());
                if (world.func_175625_s(pos) instanceof TileEntityStatue) {
                    ((TileEntityStatue)world.func_175625_s(pos)).setCreatureAndPart(target, 1, 3);
                    ((TileEntityStatue)world.func_175625_s(pos)).setLifetime((int)(900.0f * modifiers.get(WizardryItems.duration_upgrade)));
                }
                world.func_175656_a(pos.func_177984_a(), WizardryBlocks.petrified_stone.func_176223_P());
                if (world.func_175625_s(pos.func_177984_a()) instanceof TileEntityStatue) {
                    ((TileEntityStatue)world.func_175625_s(pos.func_177984_a())).setCreatureAndPart(target, 2, 3);
                }
                world.func_175656_a(pos.func_177981_b(2), WizardryBlocks.petrified_stone.func_176223_P());
                if (world.func_175625_s(pos.func_177981_b(2)) instanceof TileEntityStatue) {
                    ((TileEntityStatue)world.func_175625_s(pos.func_177981_b(2))).setCreatureAndPart(target, 3, 3);
                }
                target.getEntityData().func_74757_a(NBT_KEY, true);
                target.func_70106_y();
            }
        }
        if (world.field_72995_K) {
            for (int i = 1; i < (int)(25.0f * modifiers.get(WizardryItems.range_upgrade)); i += 2) {
                double x1 = caster.field_70165_t + look.field_72450_a * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                double y1 = WizardryUtilities.getPlayerEyesPos(caster) - (double)0.4f + look.field_72448_b * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                double z1 = caster.field_70161_v + look.field_72449_c * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                Wizardry.proxy.spawnParticle(WizardryParticleType.DARK_MAGIC, world, x1, y1, z1, 0.0, 0.0, 0.0, 0, 0.1f, 0.1f, 0.1f);
                Wizardry.proxy.spawnParticle(WizardryParticleType.SPARKLE, world, x1, y1, z1, 0.0, 0.0, 0.0, 12 + world.field_73012_v.nextInt(8), 0.2f, 0.2f, 0.2f);
            }
        }
        caster.func_184609_a(hand);
        WizardryUtilities.playSoundAtPlayer(caster, SoundEvents.field_187855_gD, 1.0f, world.field_73012_v.nextFloat() * 0.2f + 1.0f);
        return true;
    }
}

