/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryParticleType;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;

public class Shockwave
extends Spell {
    public Shockwave() {
        super(Tier.MASTER, 65, Element.SORCERY, "shockwave", SpellType.ATTACK, 150, EnumAction.BOW, false);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        List<EntityLivingBase> targets = WizardryUtilities.getEntitiesWithinRadius(5.0 * (double)modifiers.get(WizardryItems.blast_upgrade), caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, world);
        for (EntityLivingBase target : targets) {
            if (!WizardryUtilities.isValidTarget((Entity)caster, (Entity)target)) continue;
            float damage = Math.min(8.0f / target.func_70032_d((Entity)caster), 8.0f);
            target.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, MagicDamage.DamageType.BLAST), damage * modifiers.get("damage"));
            if (world.field_72995_K) continue;
            double velocityFactor = Math.min(5.0 / target.func_70068_e((Entity)caster), 3.0);
            double dx = target.field_70165_t - caster.field_70165_t;
            double dy = target.field_70163_u + 1.0 - caster.field_70163_u;
            double dz = target.field_70161_v - caster.field_70161_v;
            target.field_70159_w = velocityFactor * dx;
            target.field_70181_x = velocityFactor * dy;
            target.field_70179_y = velocityFactor * dz;
            if (!(target instanceof EntityPlayerMP)) continue;
            ((EntityPlayerMP)target).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity((Entity)target));
        }
        if (world.field_72995_K) {
            for (int i = 0; i < 40; ++i) {
                double particleX = caster.field_70165_t - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                double particleZ = caster.field_70161_v - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                Wizardry.proxy.spawnParticle(WizardryParticleType.SPARKLE, world, particleX, WizardryUtilities.getPlayerEyesPos(caster) - 1.5, particleZ, particleX - caster.field_70165_t, 0.0, particleZ - caster.field_70161_v, 30, 0.8f, 0.8f, 1.0f);
                particleX = caster.field_70165_t - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                particleZ = caster.field_70161_v - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                Wizardry.proxy.spawnParticle(WizardryParticleType.SPARKLE, world, particleX, WizardryUtilities.getPlayerEyesPos(caster) - 1.5, particleZ, particleX - caster.field_70165_t, 0.0, particleZ - caster.field_70161_v, 30, 0.9f, 0.9f, 0.9f);
                particleX = caster.field_70165_t - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                particleZ = caster.field_70161_v - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                IBlockState block = WizardryUtilities.getBlockEntityIsStandingOn((Entity)caster);
                if (block == null) continue;
                world.func_175688_a(EnumParticleTypes.BLOCK_DUST, particleX, caster.func_174813_aQ().field_72338_b, particleZ, particleX - caster.field_70165_t, 0.0, particleZ - caster.field_70161_v, new int[]{Block.func_176210_f((IBlockState)block)});
            }
            world.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, caster.field_70165_t, caster.func_174813_aQ().field_72338_b + 0.1, caster.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        }
        caster.func_184609_a(hand);
        WizardryUtilities.playSoundAtPlayer(caster, WizardrySounds.SPELL_SHOCKWAVE, 1.0f, 0.7f);
        WizardryUtilities.playSoundAtPlayer(caster, WizardrySounds.SPELL_SHOCKWAVE, 2.0f, 0.3f);
        return true;
    }
}

