/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.tileentity.TileEntityPlayerSave;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryParticleType;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class Snare
extends Spell {
    public Snare() {
        super(Tier.BASIC, 10, Element.EARTH, "snare", SpellType.ATTACK, 10, EnumAction.NONE, false);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        RayTraceResult rayTrace = WizardryUtilities.rayTrace(10.0f * modifiers.get(WizardryItems.range_upgrade), world, (EntityLivingBase)caster, true);
        if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos = rayTrace.func_178782_a();
            if (rayTrace.field_178784_b == EnumFacing.UP && world.isSideSolid(pos, EnumFacing.UP) && WizardryUtilities.canBlockBeReplaced(world, pos.func_177984_a())) {
                if (!world.field_72995_K) {
                    world.func_175656_a(pos.func_177984_a(), WizardryBlocks.snare.func_176223_P());
                    ((TileEntityPlayerSave)world.func_175625_s(pos.func_177984_a())).setCaster((EntityLivingBase)caster);
                }
                double dx = (double)pos.func_177958_n() + 0.5 - caster.field_70165_t;
                double dy = (double)pos.func_177956_o() + 1.5 - (caster.field_70163_u + (double)(caster.field_70131_O / 2.0f));
                double dz = (double)pos.func_177952_p() + 0.5 - caster.field_70161_v;
                if (world.field_72995_K) {
                    for (int i = 1; i < 5; ++i) {
                        float brightness = world.field_73012_v.nextFloat() / 4.0f;
                        Wizardry.proxy.spawnParticle(WizardryParticleType.SPARKLE, world, caster.field_70165_t + (double)i * (dx / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), WizardryUtilities.getPlayerEyesPos(caster) + (double)i * (dy / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), caster.field_70161_v + (double)i * (dz / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), 0.0, 0.0, 0.0, 20 + world.field_73012_v.nextInt(8), brightness, brightness + 0.1f, 0.0f);
                        Wizardry.proxy.spawnParticle(WizardryParticleType.LEAF, world, caster.field_70165_t + (double)i * (dx / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), WizardryUtilities.getPlayerEyesPos(caster) + (double)i * (dy / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), caster.field_70161_v + (double)i * (dz / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), 0.0, -0.01, 0.0, 40 + world.field_73012_v.nextInt(10));
                    }
                }
                caster.func_184609_a(hand);
                WizardryUtilities.playSoundAtPlayer(caster, SoundEvents.field_187577_bU, 1.0f, world.field_73012_v.nextFloat() * 0.4f + 1.2f);
                return true;
            }
        }
        return false;
    }
}

