/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.entity.living.EntitySpiderMinion;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SpiderSwarm
extends Spell {
    public SpiderSwarm() {
        super(Tier.ADVANCED, 45, Element.EARTH, "spider_swarm", SpellType.MINION, 200, EnumAction.BOW, false);
    }

    @Override
    public boolean doesSpellRequirePacket() {
        return false;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (!world.field_72995_K) {
            for (int i = 0; i < 5; ++i) {
                BlockPos pos = WizardryUtilities.findNearbyFloorSpace((Entity)caster, 3, 6);
                if (pos == null) {
                    return false;
                }
                EntitySpiderMinion spider = new EntitySpiderMinion(world, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, (EntityLivingBase)caster, (int)(600.0f * modifiers.get(WizardryItems.duration_upgrade)));
                world.func_72838_d((Entity)spider);
            }
        }
        WizardryUtilities.playSoundAtPlayer(caster, SoundEvents.field_187646_bt, 1.0f, world.field_73012_v.nextFloat() * 0.2f + 1.0f);
        return true;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        if (!world.field_72995_K) {
            for (int i = 0; i < 5; ++i) {
                BlockPos pos = WizardryUtilities.findNearbyFloorSpace((Entity)caster, 3, 6);
                if (pos == null) {
                    return false;
                }
                EntitySpiderMinion spider = new EntitySpiderMinion(world, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, (EntityLivingBase)caster, (int)(600.0f * modifiers.get(WizardryItems.duration_upgrade)));
                world.func_72838_d((Entity)spider);
            }
        }
        caster.func_184185_a(SoundEvents.field_187646_bt, 1.0f, world.field_73012_v.nextFloat() * 0.2f + 1.0f);
        return true;
    }

    @Override
    public boolean canBeCastByNPCs() {
        return true;
    }
}

