/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.util;

import electroblob.wizardry.entity.living.EntityBlazeMinion;
import electroblob.wizardry.entity.living.EntityIceGiant;
import electroblob.wizardry.entity.living.EntityIceWraith;
import electroblob.wizardry.entity.living.EntityLightningWraith;
import electroblob.wizardry.entity.living.EntityPhoenix;
import electroblob.wizardry.entity.living.EntityShadowWraith;
import electroblob.wizardry.entity.living.EntitySkeletonMinion;
import electroblob.wizardry.entity.living.EntitySpiderMinion;
import electroblob.wizardry.entity.living.EntityStormElemental;
import electroblob.wizardry.entity.living.EntityZombieMinion;
import electroblob.wizardry.util.IElementalDamage;
import electroblob.wizardry.util.IndirectMagicDamage;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;

public class MagicDamage
extends EntityDamageSource
implements IElementalDamage {
    public static final String DIRECT_MAGIC_DAMAGE = "wizardry_magic";
    public static final String INDIRECT_MAGIC_DAMAGE = "indirect_wizardry_magic";
    private static final Map<Class<? extends Entity>, DamageType[]> immunityMapping = new HashMap<Class<? extends Entity>, DamageType[]>();
    private final DamageType type;
    private final boolean isRetaliatory;

    public MagicDamage(String name, Entity caster, DamageType type, boolean isRetaliatory) {
        super(name, caster);
        this.type = type;
        this.isRetaliatory = isRetaliatory;
        this.func_82726_p();
        if (type == DamageType.FIRE) {
            this.func_76361_j();
        }
        if (type == DamageType.BLAST) {
            this.func_94540_d();
        }
    }

    public static boolean isEntityImmune(DamageType type, Entity entity) {
        if (type == DamageType.FIRE && entity.func_70045_F()) {
            return true;
        }
        DamageType[] immunities = immunityMapping.get(entity.getClass());
        return immunities != null && Arrays.asList(immunities).contains((Object)type);
    }

    public static void setEntityImmunities(Class<? extends Entity> entityType, DamageType ... immunities) {
        immunityMapping.put(entityType, immunities);
    }

    public static void addEntityImmunity(Class<? extends Entity> entityType, DamageType immunity) {
        List<Object> immunities = Arrays.asList((Object[])immunityMapping.get(entityType));
        immunities.add((Object)immunity);
        immunityMapping.put(entityType, immunities.toArray(new DamageType[0]));
    }

    public static DamageSource causeDirectMagicDamage(Entity caster, DamageType type) {
        return MagicDamage.causeDirectMagicDamage(caster, type, false);
    }

    public static DamageSource causeDirectMagicDamage(Entity caster, DamageType type, boolean isRetaliatory) {
        return new MagicDamage(DIRECT_MAGIC_DAMAGE, caster, type, isRetaliatory);
    }

    public static DamageSource causeIndirectMagicDamage(Entity magic, Entity caster, DamageType type) {
        return MagicDamage.causeIndirectMagicDamage(magic, caster, type, false);
    }

    public static DamageSource causeIndirectMagicDamage(Entity magic, Entity caster, DamageType type, boolean isRetaliatory) {
        return new IndirectMagicDamage(INDIRECT_MAGIC_DAMAGE, magic, caster, type, isRetaliatory);
    }

    @Override
    public DamageType getType() {
        return this.type;
    }

    @Override
    public boolean isRetaliatory() {
        return this.isRetaliatory;
    }

    static {
        MagicDamage.setEntityImmunities(EntityPhoenix.class, DamageType.FIRE);
        MagicDamage.setEntityImmunities(EntityBlaze.class, DamageType.FIRE);
        MagicDamage.setEntityImmunities(EntityBlazeMinion.class, DamageType.FIRE);
        MagicDamage.setEntityImmunities(EntityPigZombie.class, DamageType.FIRE, DamageType.POISON);
        MagicDamage.setEntityImmunities(EntityMagmaCube.class, DamageType.FIRE);
        MagicDamage.setEntityImmunities(EntityGhast.class, DamageType.FIRE);
        MagicDamage.setEntityImmunities(EntityDragon.class, DamageType.FIRE);
        MagicDamage.setEntityImmunities(EntityStormElemental.class, DamageType.FIRE, DamageType.SHOCK);
        MagicDamage.setEntityImmunities(EntityWither.class, DamageType.FIRE, DamageType.WITHER);
        MagicDamage.setEntityImmunities(EntitySnowman.class, DamageType.FROST);
        MagicDamage.setEntityImmunities(EntityIceWraith.class, DamageType.FROST);
        MagicDamage.setEntityImmunities(EntityIceGiant.class, DamageType.FROST);
        MagicDamage.setEntityImmunities(EntityLightningWraith.class, DamageType.SHOCK);
        MagicDamage.setEntityImmunities(EntityShadowWraith.class, DamageType.WITHER);
        MagicDamage.setEntityImmunities(EntityWitherSkeleton.class, DamageType.WITHER);
        MagicDamage.setEntityImmunities(EntitySpider.class, DamageType.POISON);
        MagicDamage.setEntityImmunities(EntitySpiderMinion.class, DamageType.POISON);
        MagicDamage.setEntityImmunities(EntityCaveSpider.class, DamageType.POISON);
        MagicDamage.setEntityImmunities(EntityZombie.class, DamageType.POISON);
        MagicDamage.setEntityImmunities(EntitySkeleton.class, DamageType.POISON);
        MagicDamage.setEntityImmunities(EntityZombieMinion.class, DamageType.POISON);
        MagicDamage.setEntityImmunities(EntitySkeletonMinion.class, DamageType.POISON);
    }

    public static enum DamageType {
        MAGIC,
        FIRE,
        FROST,
        SHOCK,
        WITHER,
        POISON,
        FORCE,
        BLAST,
        RADIANT;

    }
}

