/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.mcef.remote;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Random;
import net.montoyo.mcef.MCEF;
import net.montoyo.mcef.utilities.Log;

public enum Mirror {
    MONTOYO("http://montoyo.net/jcef", "montoyo.net");

    private static Mirror current;
    private final String url;
    private final String name;
    private boolean broken;

    private Mirror(String url, String name) {
        this.url = url;
        this.name = name;
        this.broken = false;
    }

    public boolean isBroken() {
        return this.broken;
    }

    public String getMirrorString() {
        if (MCEF.FORCE_MIRROR == null) {
            return "Mirror kindly provided by " + this.name;
        }
        return "Mirror location was set to " + MCEF.FORCE_MIRROR;
    }

    public HttpURLConnection getResource(String name) throws MalformedURLException, IOException {
        HttpURLConnection ret = (HttpURLConnection)new URL((MCEF.FORCE_MIRROR == null ? this.url : MCEF.FORCE_MIRROR) + '/' + name).openConnection();
        ret.setConnectTimeout(30000);
        ret.setReadTimeout(15000);
        ret.setRequestProperty("User-Agent", "MCEF");
        return ret;
    }

    private static Mirror pickRandom() {
        Mirror[] lst = Mirror.values();
        int idx = new Random().nextInt(lst.length);
        return lst[idx];
    }

    private static Mirror pickWorking() {
        for (Mirror m : Mirror.values()) {
            if (m.broken) continue;
            return m;
        }
        return null;
    }

    public static Mirror markAsBroken() {
        Mirror.current.broken = true;
        Mirror old = current;
        current = Mirror.pickWorking();
        Log.info("Mirror %s marked as broken; using %s", old.url, current == null ? "NULL" : Mirror.current.url);
        return current;
    }

    public static Mirror getCurrent() {
        return current;
    }

    public static Mirror reset() {
        for (Mirror m : Mirror.values()) {
            m.broken = false;
        }
        if (current == null) {
            current = Mirror.pickRandom();
        }
        return current;
    }

    static {
        current = Mirror.pickRandom();
    }
}

