/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.mcef.remote;

import java.io.File;
import net.montoyo.mcef.client.ClientProxy;
import net.montoyo.mcef.utilities.IProgressListener;
import net.montoyo.mcef.utilities.Log;
import net.montoyo.mcef.utilities.Util;

public class Resource {
    private String platform;
    private String name;
    private String sum;
    private boolean shouldExtract = false;

    public Resource(String name, String sum, String platform) {
        this.name = name;
        this.sum = sum.trim();
        this.platform = platform;
    }

    public boolean exists() {
        File f = new File(ClientProxy.ROOT, this.name);
        if (!f.exists()) {
            return false;
        }
        String hash = Util.hash(f);
        if (hash == null) {
            Log.warning("Couldn't hash file %s; assuming it doesn't exist.", f.getAbsolutePath());
            return false;
        }
        return hash.equalsIgnoreCase(this.sum);
    }

    public boolean download(IProgressListener ipl) {
        String end = "";
        if (this.shouldExtract) {
            end = end + ".gz";
        }
        return Util.download("0.9/" + this.platform + '/' + this.name + end, new File(ClientProxy.ROOT, this.name), this.shouldExtract, ipl);
    }

    public boolean extract(IProgressListener ipl) {
        Util.secure(ipl).onTaskChanged("Extracting " + this.name);
        return Util.extract(new File(ClientProxy.ROOT, this.name), new File(ClientProxy.ROOT));
    }

    public void setShouldExtract() {
        this.shouldExtract = true;
        this.name = this.name.substring(0, this.name.length() - 3);
    }

    public String getFileName() {
        return this.name;
    }

    public static File getLocationOf(String resName) {
        return new File(ClientProxy.ROOT, resName);
    }
}

