/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.mcef.utilities;

import net.minecraftforge.fml.common.ProgressManager;
import net.montoyo.mcef.utilities.IProgressListener;
import net.montoyo.mcef.utilities.Util;

public class ForgeProgressListener
implements IProgressListener {
    private ProgressManager.ProgressBar progressBar = null;
    private int lastVal = 0;

    private void stepUntil(int val) {
        while (this.lastVal < val) {
            this.progressBar.step("" + val + "%");
            ++this.lastVal;
        }
    }

    @Override
    public void onProgressed(double d) {
        this.stepUntil((int)Util.clamp(d, 0.0, 100.0));
    }

    @Override
    public void onTaskChanged(String name) {
        if (this.progressBar != null) {
            this.stepUntil(100);
            ProgressManager.pop((ProgressManager.ProgressBar)this.progressBar);
        }
        this.progressBar = ProgressManager.push((String)name, (int)100, (boolean)false);
        this.lastVal = 0;
    }

    @Override
    public void onProgressEnd() {
        if (this.progressBar != null) {
            this.stepUntil(100);
            ProgressManager.pop((ProgressManager.ProgressBar)this.progressBar);
            this.progressBar = null;
        }
    }
}

