/*
 * Decompiled with CFR 0.152.
 */
package org.cef.browser;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.nio.ByteBuffer;
import net.montoyo.mcef.MCEF;
import net.montoyo.mcef.api.IBrowser;
import net.montoyo.mcef.api.IStringVisitor;
import net.montoyo.mcef.client.ClientProxy;
import net.montoyo.mcef.client.StringVisitor;
import net.montoyo.mcef.utilities.Log;
import org.cef.DummyComponent;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefBrowser_N;
import org.cef.browser.CefRenderer;
import org.cef.browser.CefRequestContext;
import org.cef.callback.CefDragData;
import org.cef.handler.CefClientHandler;
import org.cef.handler.CefRenderHandler;
import org.lwjgl.BufferUtils;

public class CefBrowserOsr
extends CefBrowser_N
implements CefRenderHandler,
IBrowser {
    private CefRenderer renderer_;
    private Rectangle browser_rect_ = new Rectangle(0, 0, 1, 1);
    private CefClientHandler clientHandler_;
    private String url_;
    private boolean isTransparent_;
    private CefRequestContext context_;
    private CefBrowserOsr parent_ = null;
    private CefBrowserOsr devTools_ = null;
    private DummyComponent dc_ = new DummyComponent();
    public static boolean CLEANUP = true;
    private final PaintData paintData = new PaintData();

    CefBrowserOsr(CefClientHandler clientHandler, String url, boolean transparent, CefRequestContext context) {
        this(clientHandler, url, transparent, context, null, null);
    }

    private CefBrowserOsr(CefClientHandler clientHandler, String url, boolean transparent, CefRequestContext context, CefBrowserOsr parent, Point inspectAt) {
        this.isTransparent_ = transparent;
        this.renderer_ = new CefRenderer(transparent);
        this.clientHandler_ = clientHandler;
        this.url_ = url;
        this.context_ = context;
        this.parent_ = parent;
        this.createGLCanvas();
    }

    @Override
    public int getTextureID() {
        return this.renderer_.texture_id_[0];
    }

    @Override
    public Component getUIComponent() {
        return this.dc_;
    }

    @Override
    public CefRenderHandler getRenderHandler() {
        return this;
    }

    @Override
    public synchronized void close() {
        if (this.context_ != null) {
            this.context_.dispose();
        }
        if (this.parent_ != null) {
            this.parent_.closeDevTools();
            this.parent_.devTools_ = null;
            this.parent_ = null;
        }
        if (CLEANUP) {
            ((ClientProxy)MCEF.PROXY).removeBrowser(this);
            this.renderer_.cleanup();
        }
        super.close();
    }

    @Override
    public synchronized CefBrowser getDevTools() {
        return this.getDevTools(null);
    }

    @Override
    public synchronized CefBrowser getDevTools(Point inspectAt) {
        if (this.devTools_ == null) {
            this.devTools_ = new CefBrowserOsr(this.clientHandler_, this.url_, this.isTransparent_, this.context_, this, inspectAt);
        }
        return this.devTools_;
    }

    @Override
    public void resize(int width, int height) {
        this.browser_rect_.setBounds(0, 0, width, height);
        this.dc_.setBounds(this.browser_rect_);
        this.dc_.setVisible(true);
        this.wasResized(width, height);
    }

    @Override
    public void draw(double x1, double y1, double x2, double y2) {
        this.renderer_.render(x1, y1, x2, y2);
    }

    private void createGLCanvas() {
        this.createBrowser(this.clientHandler_, 0L, this.url_, this.isTransparent_, null, this.context_);
    }

    @Override
    public Rectangle getViewRect(CefBrowser browser) {
        return this.browser_rect_;
    }

    @Override
    public Point getScreenPoint(CefBrowser browser, Point viewPoint) {
        return viewPoint;
    }

    @Override
    public void onPopupShow(CefBrowser browser, boolean show) {
        if (!show) {
            this.renderer_.clearPopupRects();
            this.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPaint(CefBrowser browser, boolean popup, Rectangle[] dirtyRects, ByteBuffer buffer, int width, int height) {
        if (popup) {
            return;
        }
        int size = width * height << 2;
        PaintData paintData = this.paintData;
        synchronized (paintData) {
            if (buffer.limit() > size) {
                Log.warning("Skipping MCEF browser frame, data is too heavy", new Object[0]);
            } else {
                if (this.paintData.hasFrame) {
                    this.paintData.fullReRender = true;
                }
                if (this.paintData.buffer == null || size != this.paintData.buffer.capacity()) {
                    this.paintData.buffer = BufferUtils.createByteBuffer((int)size);
                }
                this.paintData.buffer.position(0);
                this.paintData.buffer.limit(buffer.limit());
                buffer.position(0);
                this.paintData.buffer.put(buffer);
                this.paintData.buffer.position(0);
                this.paintData.width = width;
                this.paintData.height = height;
                PaintData.access$602(this.paintData, dirtyRects);
                this.paintData.hasFrame = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mcefUpdate() {
        PaintData paintData = this.paintData;
        synchronized (paintData) {
            if (this.paintData.hasFrame) {
                this.renderer_.onPaint(false, this.paintData.dirtyRects, this.paintData.buffer, this.paintData.width, this.paintData.height, this.paintData.fullReRender);
                this.paintData.hasFrame = false;
                this.paintData.fullReRender = false;
            }
        }
    }

    @Override
    public void onPopupSize(CefBrowser browser, Rectangle size) {
        this.renderer_.onPopupSize(size);
    }

    @Override
    public void injectMouseMove(int x, int y, int mods, boolean left) {
        MouseEvent ev = new MouseEvent(this.dc_, left ? 505 : 503, 0L, mods, x, y, 0, false);
        this.sendMouseEvent(ev);
    }

    @Override
    public void injectMouseButton(int x, int y, int mods, int btn, boolean pressed, int ccnt) {
        MouseEvent ev = new MouseEvent(this.dc_, pressed ? 501 : 502, 0L, mods, x, y, ccnt, false, btn);
        this.sendMouseEvent(ev);
    }

    @Override
    public void injectKeyTyped(char c, int mods) {
        KeyEvent ev = new KeyEvent(this.dc_, 400, 0L, mods, 0, c);
        this.sendKeyEvent(ev);
    }

    @Override
    public void injectKeyPressed(char c, int mods) {
        KeyEvent ev = new KeyEvent(this.dc_, 401, 0L, mods, 0, c);
        this.sendKeyEvent(ev);
    }

    @Override
    public void injectKeyReleased(char c, int mods) {
        KeyEvent ev = new KeyEvent(this.dc_, 402, 0L, mods, 0, c);
        this.sendKeyEvent(ev);
    }

    @Override
    public void injectMouseWheel(int x, int y, int mods, int amount, int rot) {
        MouseWheelEvent ev = new MouseWheelEvent((Component)this.dc_, 507, 0L, mods, x, y, 0, false, 0, amount, rot);
        this.sendMouseWheelEvent(ev);
    }

    @Override
    public void onCursorChange(CefBrowser browser, int cursorType) {
    }

    @Override
    public boolean startDragging(CefBrowser browser, CefDragData dragData, int mask, int x, int y) {
        return false;
    }

    @Override
    public void updateDragCursor(CefBrowser browser, int operation) {
    }

    @Override
    public void runJS(String script, String frame) {
        this.executeJavaScript(script, frame, 0);
    }

    @Override
    public void visitSource(IStringVisitor isv) {
        this.getSource(new StringVisitor(isv));
    }

    @Override
    public boolean isPageLoading() {
        return this.isLoading();
    }

    private static class PaintData {
        private ByteBuffer buffer;
        private int width;
        private int height;
        private Rectangle[] dirtyRects;
        private boolean hasFrame;
        private boolean fullReRender;

        private PaintData() {
        }

        static /* synthetic */ Rectangle[] access$602(PaintData x0, Rectangle[] x1) {
            x0.dirtyRects = x1;
            return x1;
        }
    }
}

