/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.IRecipesGui;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.config.Config;
import mezz.jei.config.Constants;
import mezz.jei.config.KeyBindings;
import mezz.jei.gui.Focus;
import mezz.jei.gui.GuiHelper;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.elements.DrawableNineSliceTexture;
import mezz.jei.gui.elements.GuiIconButtonSmall;
import mezz.jei.gui.ingredients.GuiIngredient;
import mezz.jei.gui.overlay.GuiProperties;
import mezz.jei.gui.overlay.IngredientListOverlay;
import mezz.jei.gui.recipes.IRecipeGuiLogic;
import mezz.jei.gui.recipes.IRecipeLogicStateListener;
import mezz.jei.gui.recipes.RecipeCatalysts;
import mezz.jei.gui.recipes.RecipeGuiLogic;
import mezz.jei.gui.recipes.RecipeGuiTabs;
import mezz.jei.gui.recipes.RecipeLayout;
import mezz.jei.gui.recipes.RecipeTransferButton;
import mezz.jei.input.ClickedIngredient;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IShowsRecipeFocuses;
import mezz.jei.input.MouseHelper;
import mezz.jei.runtime.JeiRuntime;
import mezz.jei.transfer.RecipeTransferUtil;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.StringUtil;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraftforge.fml.client.config.HoverChecker;
import org.lwjgl.input.Mouse;

public class RecipesGui
extends GuiScreen
implements IRecipesGui,
IShowsRecipeFocuses,
IRecipeLogicStateListener {
    private static final int borderPadding = 6;
    private static final int innerPadding = 14;
    private static final int buttonWidth = 13;
    private static final int buttonHeight = 13;
    private int headerHeight;
    private final IRecipeGuiLogic logic;
    private final List<RecipeLayout> recipeLayouts = new ArrayList<RecipeLayout>();
    private String pageString = "1/1";
    private String title = "";
    private final DrawableNineSliceTexture background;
    private final RecipeCatalysts recipeCatalysts;
    private final RecipeGuiTabs recipeGuiTabs;
    private HoverChecker titleHoverChecker = new HoverChecker(0, 0, 0, 0, 0);
    private final GuiButton nextRecipeCategory;
    private final GuiButton previousRecipeCategory;
    private final GuiButton nextPage;
    private final GuiButton previousPage;
    @Nullable
    private GuiScreen parentScreen;
    private int xSize;
    private int ySize;
    private int guiLeft;
    private int guiTop;
    private boolean init = false;

    public RecipesGui(IRecipeRegistry recipeRegistry) {
        this.logic = new RecipeGuiLogic(recipeRegistry, this);
        this.recipeCatalysts = new RecipeCatalysts();
        this.recipeGuiTabs = new RecipeGuiTabs(this.logic);
        this.field_146297_k = Minecraft.func_71410_x();
        GuiHelper guiHelper = Internal.getHelpers().getGuiHelper();
        IDrawableStatic arrowNext = guiHelper.getArrowNext();
        IDrawableStatic arrowPrevious = guiHelper.getArrowPrevious();
        this.nextRecipeCategory = new GuiIconButtonSmall(2, 0, 0, 13, 13, arrowNext);
        this.previousRecipeCategory = new GuiIconButtonSmall(3, 0, 0, 13, 13, arrowPrevious);
        this.nextPage = new GuiIconButtonSmall(4, 0, 0, 13, 13, arrowNext);
        this.previousPage = new GuiIconButtonSmall(5, 0, 0, 13, 13, arrowPrevious);
        this.background = new DrawableNineSliceTexture(Constants.RECIPE_BACKGROUND, 0, 0, 64, 64, 16, 16, 16, 16);
    }

    private static void drawCenteredString(FontRenderer fontRenderer, String string, int guiWidth, int xOffset, int yPos, int color, boolean shadow) {
        fontRenderer.func_175065_a(string, (float)((guiWidth - fontRenderer.func_78256_a(string)) / 2 + xOffset), (float)yPos, color, shadow);
    }

    public int getGuiLeft() {
        return this.guiLeft;
    }

    public int getGuiTop() {
        return this.guiTop;
    }

    public int getXSize() {
        return this.xSize;
    }

    public int getYSize() {
        return this.ySize;
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.xSize = 198;
        this.ySize = this.field_146295_m - 68;
        int extraSpace = 0;
        int maxHeight = Config.getMaxRecipeGuiHeight();
        if (this.ySize > maxHeight) {
            extraSpace = this.ySize - maxHeight;
            this.ySize = maxHeight;
        }
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = 45 + extraSpace / 2;
        this.background.setWidth(this.xSize);
        this.background.setHeight(this.ySize);
        int rightButtonX = this.guiLeft + this.xSize - 6 - 13;
        int leftButtonX = this.guiLeft + 6;
        int titleHeight = this.field_146289_q.field_78288_b + 6;
        int recipeClassButtonTop = this.guiTop + titleHeight - 13 + 2;
        this.nextRecipeCategory.field_146128_h = rightButtonX;
        this.nextRecipeCategory.field_146129_i = recipeClassButtonTop;
        this.previousRecipeCategory.field_146128_h = leftButtonX;
        this.previousRecipeCategory.field_146129_i = recipeClassButtonTop;
        int pageButtonTop = recipeClassButtonTop + 13 + 2;
        this.nextPage.field_146128_h = rightButtonX;
        this.nextPage.field_146129_i = pageButtonTop;
        this.previousPage.field_146128_h = leftButtonX;
        this.previousPage.field_146129_i = pageButtonTop;
        this.headerHeight = pageButtonTop + 13 - this.guiTop;
        this.addButtons();
        this.init = true;
        this.updateLayout();
    }

    private void addButtons() {
        this.field_146292_n.add(this.nextRecipeCategory);
        this.field_146292_n.add(this.previousRecipeCategory);
        this.field_146292_n.add(this.nextPage);
        this.field_146292_n.add(this.previousPage);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73735_i = 0.0f;
        this.background.draw(Minecraft.func_71410_x(), this.guiLeft, this.guiTop);
        GlStateManager.func_179084_k();
        RecipesGui.func_73734_a((int)(this.guiLeft + 6 + 13), (int)this.nextRecipeCategory.field_146129_i, (int)(this.guiLeft + this.xSize - 6 - 13), (int)(this.nextRecipeCategory.field_146129_i + 13), (int)0x30000000);
        RecipesGui.func_73734_a((int)(this.guiLeft + 6 + 13), (int)this.nextPage.field_146129_i, (int)(this.guiLeft + this.xSize - 6 - 13), (int)(this.nextPage.field_146129_i + 13), (int)0x30000000);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int textPadding = (13 - this.field_146289_q.field_78288_b) / 2;
        RecipesGui.drawCenteredString(this.field_146289_q, this.title, this.xSize, this.guiLeft, this.nextRecipeCategory.field_146129_i + textPadding, Color.WHITE.getRGB(), true);
        RecipesGui.drawCenteredString(this.field_146289_q, this.pageString, this.xSize, this.guiLeft, this.nextPage.field_146129_i + textPadding, Color.WHITE.getRGB(), true);
        this.nextRecipeCategory.func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
        this.previousRecipeCategory.func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
        this.nextPage.func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
        this.previousPage.func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
        RecipeLayout hoveredLayout = null;
        for (RecipeLayout recipeLayout : this.recipeLayouts) {
            if (recipeLayout.isMouseOver(mouseX, mouseY)) {
                hoveredLayout = recipeLayout;
            }
            recipeLayout.drawRecipe(this.field_146297_k, mouseX, mouseY);
        }
        GuiIngredient hoveredRecipeCatalyst = this.recipeCatalysts.draw(this.field_146297_k, mouseX, mouseY);
        this.recipeGuiTabs.draw(this.field_146297_k, mouseX, mouseY);
        if (hoveredLayout != null) {
            hoveredLayout.drawOverlays(this.field_146297_k, mouseX, mouseY);
        }
        if (hoveredRecipeCatalyst != null) {
            hoveredRecipeCatalyst.drawOverlays(this.field_146297_k, 0, 0, mouseX, mouseY);
        }
        if (this.titleHoverChecker.checkHover(mouseX, mouseY) && !this.logic.hasAllCategories()) {
            String showAllRecipesString = Translator.translateToLocal("jei.tooltip.show.all.recipes");
            TooltipRenderer.drawHoveringText(this.field_146297_k, showAllRecipesString, mouseX, mouseY);
        }
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        if (this.field_146297_k.field_71462_r == this) {
            if (mouseX >= this.guiLeft && mouseY >= this.guiTop && mouseX < this.guiLeft + this.xSize && mouseY < this.guiTop + this.ySize) {
                return true;
            }
            for (RecipeLayout recipeLayout : this.recipeLayouts) {
                if (!recipeLayout.isMouseOver(mouseX, mouseY)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public IClickedIngredient<?> getIngredientUnderMouse(int mouseX, int mouseY) {
        if (this.isOpen()) {
            IClickedIngredient<?> clicked = this.recipeCatalysts.getIngredientUnderMouse(mouseX, mouseY);
            if (clicked != null) {
                return clicked;
            }
            if (this.isMouseOver(mouseX, mouseY)) {
                for (RecipeLayout recipeLayouts : this.recipeLayouts) {
                    Object displayedIngredient;
                    GuiIngredient<?> clicked2 = recipeLayouts.getGuiIngredientUnderMouse(mouseX, mouseY);
                    if (clicked2 == null || (displayedIngredient = clicked2.getDisplayedIngredient()) == null) continue;
                    return ClickedIngredient.create(displayedIngredient, clicked2.getRect());
                }
            }
        }
        return null;
    }

    @Override
    public boolean canSetFocusWithMouse() {
        return true;
    }

    public void func_146274_d() throws IOException {
        int y;
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        if (this.isMouseOver(x, y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1)) {
            int scrollDelta = Mouse.getEventDWheel();
            if (scrollDelta < 0) {
                this.logic.nextPage();
                return;
            }
            if (scrollDelta > 0) {
                this.logic.previousPage();
                return;
            }
        }
        super.func_146274_d();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.isMouseOver(mouseX, mouseY)) {
            if (this.titleHoverChecker.checkHover(mouseX, mouseY)) {
                if (this.logic.setCategoryFocus()) {
                    return;
                }
            } else {
                for (RecipeLayout recipeLayout : this.recipeLayouts) {
                    if (!recipeLayout.handleClick(this.field_146297_k, mouseX, mouseY, mouseButton)) continue;
                    return;
                }
            }
        }
        if (this.recipeGuiTabs.isMouseOver(mouseX, mouseY) && this.recipeGuiTabs.handleMouseClicked(mouseX, mouseY, mouseButton)) {
            return;
        }
        if (this.handleKeybinds(mouseButton - 100)) {
            return;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        if (this.handleKeybinds(keyCode)) {
            this.keyHandled = true;
        }
    }

    private boolean handleKeybinds(int eventKey) {
        IngredientListOverlay itemListOverlay;
        if (KeyBindings.isInventoryCloseKey(eventKey) || KeyBindings.isInventoryToggleKey(eventKey)) {
            this.close();
            return true;
        }
        if (KeyBindings.recipeBack.isActiveAndMatches(eventKey)) {
            this.back();
            return true;
        }
        JeiRuntime runtime = Internal.getRuntime();
        if (runtime != null && !(itemListOverlay = runtime.getIngredientListOverlay()).isMouseOver(MouseHelper.getX(), MouseHelper.getY())) {
            if (KeyBindings.nextPage.isActiveAndMatches(eventKey)) {
                this.logic.nextPage();
                return true;
            }
            if (KeyBindings.previousPage.isActiveAndMatches(eventKey)) {
                this.logic.previousPage();
                return true;
            }
        }
        return false;
    }

    public boolean isOpen() {
        return this.field_146297_k.field_71462_r == this;
    }

    private void open() {
        if (!this.isOpen()) {
            this.parentScreen = this.field_146297_k.field_71462_r;
        }
        this.field_146297_k.func_147108_a((GuiScreen)this);
    }

    public void close() {
        if (this.isOpen()) {
            if (this.parentScreen != null) {
                this.field_146297_k.func_147108_a(this.parentScreen);
                this.parentScreen = null;
            } else {
                EntityPlayerSP player = this.field_146297_k.field_71439_g;
                if (player != null) {
                    player.func_71053_j();
                }
            }
            this.logic.clearHistory();
        }
    }

    @Override
    public <V> void show(IFocus<V> focus) {
        if (this.logic.setFocus(focus = Focus.check(focus))) {
            this.open();
        }
    }

    @Override
    public void showCategories(List<String> recipeCategoryUids) {
        ErrorUtil.checkNotEmpty(recipeCategoryUids, "recipeCategoryUids");
        if (this.logic.setCategoryFocus(recipeCategoryUids)) {
            this.open();
        }
    }

    @Override
    @Nullable
    public Object getIngredientUnderMouse() {
        IClickedIngredient<?> ingredient = this.getIngredientUnderMouse(MouseHelper.getX(), MouseHelper.getY());
        if (ingredient != null) {
            return ingredient.getValue();
        }
        return null;
    }

    public void back() {
        this.logic.back();
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (guibutton.field_146127_k == this.nextPage.field_146127_k) {
            this.logic.nextPage();
        } else if (guibutton.field_146127_k == this.previousPage.field_146127_k) {
            this.logic.previousPage();
        } else if (guibutton.field_146127_k == this.nextRecipeCategory.field_146127_k) {
            this.logic.nextRecipeCategory();
        } else if (guibutton.field_146127_k == this.previousRecipeCategory.field_146127_k) {
            this.logic.previousRecipeCategory();
        } else if (guibutton.field_146127_k >= 100) {
            int recipeIndex = guibutton.field_146127_k - 100;
            RecipeLayout recipeLayout = this.recipeLayouts.get(recipeIndex);
            boolean maxTransfer = GuiScreen.func_146272_n();
            Container container = this.getParentContainer();
            EntityPlayerSP player = this.field_146297_k.field_71439_g;
            if (container != null && player != null && RecipeTransferUtil.transferRecipe(container, recipeLayout, (EntityPlayer)player, maxTransfer)) {
                this.close();
            }
        }
    }

    private void updateLayout() {
        if (!this.init) {
            return;
        }
        int availableHeight = this.ySize - this.headerHeight;
        IRecipeCategory recipeCategory = this.logic.getSelectedRecipeCategory();
        IDrawable recipeBackground = recipeCategory.getBackground();
        int heightPerRecipe = recipeBackground.getHeight() + 14;
        int recipesPerPage = availableHeight / heightPerRecipe;
        if (recipesPerPage == 0) {
            availableHeight = heightPerRecipe;
            recipesPerPage = 1;
        }
        int recipeXOffset = this.guiLeft + (this.xSize - recipeBackground.getWidth()) / 2;
        int recipeSpacing = (availableHeight - recipesPerPage * recipeBackground.getHeight()) / (recipesPerPage + 1);
        this.logic.setRecipesPerPage(recipesPerPage);
        this.title = recipeCategory.getTitle();
        int titleWidth = this.field_146289_q.func_78256_a(this.title);
        int availableTitleWidth = this.nextPage.field_146128_h - (this.previousPage.field_146128_h + this.previousPage.field_146120_f) - 28;
        if (titleWidth > availableTitleWidth) {
            this.title = StringUtil.truncateStringToWidth(this.title, availableTitleWidth, this.field_146289_q);
            titleWidth = this.field_146289_q.func_78256_a(this.title);
        }
        int titleX = this.guiLeft + (this.xSize - titleWidth) / 2;
        int titleY = this.guiTop + 6;
        this.titleHoverChecker = new HoverChecker(titleY, titleY + this.field_146289_q.field_78288_b, titleX, titleX + titleWidth, 0);
        int spacingY = recipeBackground.getHeight() + recipeSpacing;
        this.recipeLayouts.clear();
        this.recipeLayouts.addAll(this.logic.getRecipeLayouts(recipeXOffset, this.guiTop + this.headerHeight + recipeSpacing, spacingY));
        this.addRecipeTransferButtons(this.recipeLayouts);
        this.nextPage.field_146124_l = this.previousPage.field_146124_l = this.logic.hasMultiplePages();
        this.nextRecipeCategory.field_146124_l = this.previousRecipeCategory.field_146124_l = this.logic.hasMultipleCategories();
        this.pageString = this.logic.getPageString();
        List<Object> recipeCatalysts = this.logic.getRecipeCatalysts();
        GuiProperties guiProperties = GuiProperties.create(this);
        this.recipeCatalysts.updateLayout(recipeCatalysts, guiProperties);
        this.recipeGuiTabs.initLayout(guiProperties);
    }

    private void addRecipeTransferButtons(List<RecipeLayout> recipeLayouts) {
        this.field_146292_n.clear();
        this.addButtons();
        EntityPlayerSP player = this.field_146297_k.field_71439_g;
        if (player != null) {
            Container container = this.getParentContainer();
            for (RecipeLayout recipeLayout : recipeLayouts) {
                RecipeTransferButton button = recipeLayout.getRecipeTransferButton();
                if (button == null) continue;
                button.init(container, (EntityPlayer)player);
                this.field_146292_n.add(button);
            }
        }
    }

    @Nullable
    public GuiScreen getParentScreen() {
        return this.parentScreen;
    }

    @Nullable
    private Container getParentContainer() {
        if (this.parentScreen instanceof GuiContainer) {
            return ((GuiContainer)this.parentScreen).field_147002_h;
        }
        return null;
    }

    @Override
    public void onStateChange() {
        this.updateLayout();
    }
}

