/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.model;

import de.matthiasmann.twl.model.FileSystemModel;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ReadableByteChannel;

public class JavaFileSystemModel
implements FileSystemModel {
    private static final JavaFileSystemModel instance = new JavaFileSystemModel();

    public static JavaFileSystemModel getInstance() {
        return instance;
    }

    @Override
    public String getSeparator() {
        return File.separator;
    }

    @Override
    public Object getFile(String path) {
        File file = new File(path);
        return file.exists() ? file : null;
    }

    @Override
    public Object getParent(Object file) {
        return ((File)file).getParentFile();
    }

    @Override
    public boolean isFolder(Object file) {
        return ((File)file).isDirectory();
    }

    @Override
    public boolean isFile(Object file) {
        return ((File)file).isFile();
    }

    @Override
    public boolean isHidden(Object file) {
        return ((File)file).isHidden();
    }

    @Override
    public String getName(Object file) {
        String name = ((File)file).getName();
        if (name.length() == 0) {
            return file.toString();
        }
        return name;
    }

    @Override
    public String getPath(Object file) {
        return ((File)file).getPath();
    }

    @Override
    public String getRelativePath(Object from, Object to) {
        return JavaFileSystemModel.getRelativePath(this, from, to);
    }

    public static String getRelativePath(FileSystemModel fsm, Object from, Object to) {
        int levelFrom = JavaFileSystemModel.countLevel(fsm, from);
        int levelTo = JavaFileSystemModel.countLevel(fsm, to);
        int prefixes = 0;
        StringBuilder sb = new StringBuilder();
        while (!fsm.equals(from, to)) {
            int diff = levelTo - levelFrom;
            if (diff <= 0) {
                ++prefixes;
                --levelFrom;
                from = fsm.getParent(from);
            }
            if (diff < 0) continue;
            sb.insert(0, '/');
            sb.insert(0, fsm.getName(to));
            --levelTo;
            to = fsm.getParent(to);
        }
        while (prefixes-- > 0) {
            sb.insert(0, "../");
        }
        return sb.toString();
    }

    public static int countLevel(FileSystemModel fsm, Object file) {
        int level = 0;
        while (file != null) {
            file = fsm.getParent(file);
            ++level;
        }
        return level;
    }

    public static int countLevel(FileSystemModel fsm, Object parent, Object child) {
        int level = 0;
        while (fsm.equals(child, parent)) {
            if (child == null) {
                return -1;
            }
            child = fsm.getParent(child);
            ++level;
        }
        return level;
    }

    @Override
    public long getLastModified(Object file) {
        try {
            return ((File)file).lastModified();
        }
        catch (Throwable ex) {
            return -1L;
        }
    }

    @Override
    public long getSize(Object file) {
        try {
            return ((File)file).length();
        }
        catch (Throwable ex) {
            return -1L;
        }
    }

    @Override
    public boolean equals(Object file1, Object file2) {
        return file1 != null && file1.equals(file2);
    }

    @Override
    public int find(Object[] list, Object file) {
        if (file == null) {
            return -1;
        }
        for (int i = 0; i < list.length; ++i) {
            if (!file.equals(list[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Object[] listRoots() {
        return File.listRoots();
    }

    @Override
    public Object[] listFolder(Object file, final FileSystemModel.FileFilter filter) {
        try {
            if (filter == null) {
                return ((File)file).listFiles();
            }
            return ((File)file).listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return filter.accept(JavaFileSystemModel.this, pathname);
                }
            });
        }
        catch (Throwable ex) {
            return null;
        }
    }

    @Override
    public Object getSpecialFolder(String key) {
        File file = null;
        if ("user.home".equals(key)) {
            try {
                file = new File(System.getProperty("user.home"));
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (file != null && file.canRead() && file.isDirectory()) {
            return file;
        }
        return null;
    }

    @Override
    public ReadableByteChannel openChannel(Object file) throws IOException {
        return new FileInputStream((File)file).getChannel();
    }

    @Override
    public InputStream openStream(Object file) throws IOException {
        return new FileInputStream((File)file);
    }
}

