/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity;

import com.google.common.base.Optional;
import drzhark.mocreatures.MoCPetData;
import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.IMoCTameable;
import drzhark.mocreatures.entity.MoCEntityAquatic;
import drzhark.mocreatures.init.MoCItems;
import drzhark.mocreatures.init.MoCSoundEvents;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageHeart;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MoCEntityTameableAquatic
extends MoCEntityAquatic
implements IMoCTameable {
    protected static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(MoCEntityTameableAquatic.class, (DataSerializer)DataSerializers.field_187203_m);
    protected static final DataParameter<Integer> PET_ID = EntityDataManager.func_187226_a(MoCEntityTameableAquatic.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Boolean> TAMED = EntityDataManager.func_187226_a(MoCEntityTameableAquatic.class, (DataSerializer)DataSerializers.field_187198_h);
    private boolean hasEaten;
    private int gestationtime;

    public MoCEntityTameableAquatic(World world) {
        super(world);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(PET_ID, (Object)-1);
        this.field_70180_af.func_187214_a(TAMED, (Object)false);
    }

    @Override
    public int getOwnerPetId() {
        return (Integer)this.field_70180_af.func_187225_a(PET_ID);
    }

    @Override
    public void setOwnerPetId(int i) {
        this.field_70180_af.func_187227_b(PET_ID, (Object)i);
    }

    @Override
    @Nullable
    public UUID getOwnerId() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orNull();
    }

    @Override
    public void setOwnerId(@Nullable UUID uniqueId) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, (Object)Optional.fromNullable((Object)uniqueId));
    }

    @Override
    public void setTamed(boolean flag) {
        this.field_70180_af.func_187227_b(TAMED, (Object)flag);
    }

    @Override
    public boolean getIsTamed() {
        return (Boolean)this.field_70180_af.func_187225_a(TAMED);
    }

    @Nullable
    public EntityLivingBase getOwner() {
        try {
            UUID uuid = this.getOwnerId();
            return uuid == null ? null : this.field_70170_p.func_152378_a(uuid);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float i) {
        Entity entity = damagesource.func_76346_g();
        if (this.func_184207_aI() && entity == this.func_184187_bx() || this.func_184187_bx() != null && entity == this.func_184187_bx()) {
            return false;
        }
        if (this.usesNewAI()) {
            return super.func_70097_a(damagesource, i);
        }
        if (MoCreatures.proxy.enableOwnership && this.getOwnerId() != null && entity != null && entity instanceof EntityPlayer && !((EntityPlayer)entity).func_110124_au().equals(this.getOwnerId()) && !MoCTools.isThisPlayerAnOP((EntityPlayer)entity)) {
            return false;
        }
        return super.func_70097_a(damagesource, i);
    }

    private boolean checkOwnership(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!this.getIsTamed() || MoCTools.isThisPlayerAnOP(player)) {
            return true;
        }
        if (this.getIsGhost() && !stack.func_190926_b() && stack.func_77973_b() == MoCItems.petamulet) {
            if (!this.field_70170_p.field_72995_K) {
                ((EntityPlayerMP)player).func_71110_a(player.field_71070_bA, player.field_71070_bA.func_75138_a());
                player.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.RED + "This pet does not belong to you.", new Object[0]));
            }
            return false;
        }
        if (MoCreatures.proxy.enableOwnership && this.getOwnerId() != null && !player.func_110124_au().equals(this.getOwnerId())) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.RED + "This pet does not belong to you.", new Object[0]));
            return false;
        }
        return true;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        Boolean tameResult = this.processTameInteract(player, hand);
        if (tameResult != null) {
            return tameResult;
        }
        return super.func_184645_a(player, hand);
    }

    public Boolean processTameInteract(EntityPlayer player, EnumHand hand) {
        if (!this.checkOwnership(player, hand)) {
            return false;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && this.getIsTamed() && stack.func_77973_b() == MoCItems.scrollOfOwner && MoCreatures.proxy.enableResetOwnership && MoCTools.isThisPlayerAnOP(player)) {
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                player.func_184611_a(hand, ItemStack.field_190927_a);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.getOwnerPetId() != -1) {
                    MoCreatures.instance.mapData.removeOwnerPet(this, this.getOwnerPetId());
                }
                this.setOwnerId(null);
            }
            return true;
        }
        if (MoCreatures.proxy.enableOwnership && this.getOwnerId() != null && !player.func_110124_au().equals(this.getOwnerId()) && !MoCTools.isThisPlayerAnOP(player)) {
            return true;
        }
        if (!(this.field_70170_p.field_72995_K || stack.func_190926_b() || !this.getIsTamed() || stack.func_77973_b() != MoCItems.medallion && stack.func_77973_b() != Items.field_151122_aG && stack.func_77973_b() != Items.field_151057_cb)) {
            if (MoCTools.tameWithName(player, this)) {
                return true;
            }
            return false;
        }
        if (!stack.func_190926_b() && this.getIsTamed() && stack.func_77973_b() == MoCItems.scrollFreedom) {
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                player.func_184611_a(hand, ItemStack.field_190927_a);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.getOwnerPetId() != -1) {
                    MoCreatures.instance.mapData.removeOwnerPet(this, this.getOwnerPetId());
                }
                this.setOwnerId(null);
                this.setPetName("");
                this.dropMyStuff();
                this.setTamed(false);
            }
            return true;
        }
        if (!stack.func_190926_b() && this.getIsTamed() && stack.func_77973_b() == MoCItems.scrollOfSale) {
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                player.func_184611_a(hand, ItemStack.field_190927_a);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.getOwnerPetId() != -1) {
                    MoCreatures.instance.mapData.removeOwnerPet(this, this.getOwnerPetId());
                }
                this.setOwnerId(null);
            }
            return true;
        }
        if (!stack.func_190926_b() && this.getIsTamed() && this.isMyHealFood(stack)) {
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                player.func_184611_a(hand, ItemStack.field_190927_a);
            }
            MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_GENERIC_EATING);
            if (!this.field_70170_p.field_72995_K) {
                this.func_70606_j(this.func_110138_aP());
            }
            return true;
        }
        if (!stack.func_190926_b() && stack.func_77973_b() == MoCItems.fishnet && stack.func_77952_i() == 0 && this.canBeTrappedInNet()) {
            MoCPetData petData;
            if (!this.field_70170_p.field_72995_K && (petData = MoCreatures.instance.mapData.getPetData(this.getOwnerId())) != null) {
                petData.setInAmulet(this.getOwnerPetId(), true);
            }
            player.func_184611_a(hand, ItemStack.field_190927_a);
            if (!this.field_70170_p.field_72995_K) {
                MoCTools.dropAmulet(this, 1, player);
                this.field_70128_L = true;
            }
            return true;
        }
        return null;
    }

    public void func_70106_y() {
        if (!this.field_70170_p.field_72995_K && this.getIsTamed() && this.func_110143_aJ() > 0.0f && !this.riderIsDisconnecting) {
            return;
        }
        super.func_70106_y();
    }

    @Override
    public void playTameEffect(boolean par1) {
        EnumParticleTypes particleType = EnumParticleTypes.HEART;
        if (!par1) {
            particleType = EnumParticleTypes.SMOKE_NORMAL;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(particleType, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74757_a("Tamed", this.getIsTamed());
        if (this.getOwnerId() != null) {
            nbttagcompound.func_74778_a("OwnerUUID", this.getOwnerId().toString());
        }
        if (this.getOwnerPetId() != -1) {
            nbttagcompound.func_74768_a("PetId", this.getOwnerPetId());
        }
        if (this instanceof IMoCTameable && this.getIsTamed() && MoCreatures.instance.mapData != null) {
            MoCreatures.instance.mapData.updateOwnerPet(this);
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setTamed(nbttagcompound.func_74767_n("Tamed"));
        String s = "";
        if (nbttagcompound.func_150297_b("OwnerUUID", 8)) {
            s = nbttagcompound.func_74779_i("OwnerUUID");
        }
        if (!s.isEmpty()) {
            this.setOwnerId(UUID.fromString(s));
        }
        if (nbttagcompound.func_74764_b("PetId")) {
            this.setOwnerPetId(nbttagcompound.func_74762_e("PetId"));
        }
        if (this.getIsTamed() && nbttagcompound.func_74764_b("PetId")) {
            MoCPetData petData = MoCreatures.instance.mapData.getPetData(this.getOwnerId());
            if (petData != null) {
                NBTTagList tag = petData.getOwnerRootNBT().func_150295_c("TamedList", 10);
                for (int i = 0; i < tag.func_74745_c(); ++i) {
                    NBTTagCompound nbt = tag.func_150305_b(i);
                    if (nbt.func_74762_e("PetId") != nbttagcompound.func_74762_e("PetId")) continue;
                    nbt.func_74757_a("InAmulet", false);
                    if (!nbt.func_74764_b("Cloned")) continue;
                    nbt.func_82580_o("Cloned");
                    this.setTamed(false);
                    this.func_70106_y();
                }
            } else {
                this.setOwnerPetId(-1);
            }
        }
    }

    public boolean shouldDismountInWater(Entity rider) {
        return !this.getIsTamed();
    }

    public boolean isBreedingItem(ItemStack par1ItemStack) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte par1) {
        if (par1 == 2) {
            this.field_70721_aZ = 1.5f;
            this.field_70172_ad = this.field_70771_an;
            this.field_70738_aO = 10;
            this.field_70737_aN = 10;
            this.field_70739_aP = 0.0f;
            this.func_184185_a(this.func_184601_bQ(DamageSource.field_76377_j), this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            this.func_70097_a(DamageSource.field_76377_j, 0.0f);
        } else if (par1 == 3) {
            this.func_184185_a(this.func_184615_bR(), this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            this.func_70606_j(0.0f);
            this.func_70645_a(DamageSource.field_76377_j);
        }
    }

    @Override
    public float getPetHealth() {
        return this.func_110143_aJ();
    }

    @Override
    public boolean isRiderDisconnecting() {
        return this.riderIsDisconnecting;
    }

    @Override
    public void setRiderDisconnecting(boolean flag) {
        this.riderIsDisconnecting = flag;
    }

    @Override
    public void spawnHeart() {
        double var2 = this.field_70146_Z.nextGaussian() * 0.02;
        double var4 = this.field_70146_Z.nextGaussian() * 0.02;
        double var6 = this.field_70146_Z.nextGaussian() * 0.02;
        this.field_70170_p.func_175688_a(EnumParticleTypes.HEART, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, var2, var4, var6, new int[0]);
    }

    @Override
    public boolean readytoBreed() {
        return !this.func_184207_aI() && this.func_184187_bx() == null && this.getIsTamed() && this.getHasEaten() && this.getIsAdult();
    }

    @Override
    public String getOffspringClazz(IMoCTameable mate) {
        return "";
    }

    @Override
    public int getOffspringTypeInt(IMoCTameable mate) {
        return 0;
    }

    @Override
    public boolean compatibleMate(Entity mate) {
        return mate instanceof IMoCTameable;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.readytoBreed() && this.field_70146_Z.nextInt(100) == 0) {
            this.doBreeding();
        }
    }

    public boolean func_70094_T() {
        if (this.getIsTamed()) {
            return false;
        }
        return super.func_70094_T();
    }

    protected void doBreeding() {
        int i = 0;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(8.0, 3.0, 8.0));
        for (int j = 0; j < list.size(); ++j) {
            Entity entity = (Entity)list.get(j);
            if (!this.compatibleMate(entity)) continue;
            ++i;
        }
        if (i > 1) {
            return;
        }
        List list1 = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(4.0, 2.0, 4.0));
        for (int k = 0; k < list1.size(); ++k) {
            Entity mate = (Entity)list1.get(k);
            if (!this.compatibleMate(mate) || mate == this) continue;
            if (!this.readytoBreed()) {
                return;
            }
            if (!((IMoCTameable)mate).readytoBreed()) {
                return;
            }
            this.setGestationTime(this.getGestationTime() + 1);
            if (!this.field_70170_p.field_72995_K) {
                MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageHeart(this.func_145782_y()), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
            }
            if (this.getGestationTime() <= 50) continue;
            try {
                String offspringName = this.getOffspringClazz((IMoCTameable)mate);
                EntityLiving offspring = (EntityLiving)EntityList.func_188429_b((ResourceLocation)new ResourceLocation("mocreatures:" + offspringName.toLowerCase()), (World)this.field_70170_p);
                if (offspring != null && offspring instanceof IMoCTameable) {
                    IMoCTameable baby = (IMoCTameable)offspring;
                    ((EntityLiving)baby).func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    this.field_70170_p.func_72838_d((Entity)((EntityLiving)baby));
                    baby.setAdult(false);
                    baby.setEdad(35);
                    baby.setTamed(true);
                    baby.setOwnerId(this.getOwnerId());
                    baby.setType(this.getOffspringTypeInt((IMoCTameable)mate));
                    EntityPlayer entityplayer = this.field_70170_p.func_152378_a(this.getOwnerId());
                    if (entityplayer != null) {
                        MoCTools.tameWithName(entityplayer, baby);
                    }
                }
                MoCTools.playCustomSound((Entity)this, SoundEvents.field_187665_Y);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setHasEaten(false);
            this.setGestationTime(0);
            ((IMoCTameable)mate).setHasEaten(false);
            ((IMoCTameable)mate).setGestationTime(0);
            break;
        }
    }

    @Override
    public void setHasEaten(boolean flag) {
        this.hasEaten = flag;
    }

    @Override
    public boolean getHasEaten() {
        return this.hasEaten;
    }

    @Override
    public void setGestationTime(int time) {
        this.gestationtime = time;
    }

    @Override
    public int getGestationTime() {
        return this.gestationtime;
    }
}

