/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.item;

import drzhark.mocreatures.MoCPetData;
import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.IMoCEntity;
import drzhark.mocreatures.entity.IMoCTameable;
import drzhark.mocreatures.entity.passive.MoCEntityBigCat;
import drzhark.mocreatures.entity.passive.MoCEntityKitty;
import drzhark.mocreatures.init.MoCItems;
import drzhark.mocreatures.item.MoCItem;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAppear;
import drzhark.mocreatures.util.MoCLog;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MoCItemPetAmulet
extends MoCItem {
    private String name;
    private float health;
    private int edad;
    private int creatureType;
    private String spawnClass;
    private String ownerName;
    private UUID ownerUniqueId;
    private int amuletType;
    private boolean adult;
    private int PetId;

    public MoCItemPetAmulet(String name) {
        super(name);
        this.field_77777_bU = 1;
        this.func_77627_a(true);
    }

    public MoCItemPetAmulet(String name, int type) {
        this(name);
        this.amuletType = type;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack;
        block24: {
            stack = player.func_184586_b(hand);
            double dist = 1.0;
            double newPosY = player.field_70163_u;
            double newPosX = player.field_70165_t - dist * Math.cos(MoCTools.realAngle(player.field_70177_z - 90.0f) / 57.29578f);
            double newPosZ = player.field_70161_v - dist * Math.sin(MoCTools.realAngle(player.field_70177_z - 90.0f) / 57.29578f);
            ItemStack emptyAmulet = new ItemStack((Item)MoCItems.fishnet, 1, 0);
            if (this.amuletType == 1) {
                emptyAmulet = new ItemStack((Item)MoCItems.petamulet, 1, 0);
            }
            if (world.field_72995_K) break block24;
            this.initAndReadNBT(stack);
            if (this.spawnClass.isEmpty()) {
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
            try {
                IMoCTameable storedCreature;
                block26: {
                    block25: {
                        int maxCount;
                        MoCPetData newOwner;
                        block27: {
                            EntityLiving tempLiving;
                            this.spawnClass = this.spawnClass.replace("mocreatures:", "").toLowerCase();
                            if (this.spawnClass.equalsIgnoreCase("MoCHorse")) {
                                this.spawnClass = "WildHorse";
                            } else if (this.spawnClass.equalsIgnoreCase("PolarBear")) {
                                this.spawnClass = "WildPolarBear";
                            }
                            if (this.spawnClass.equalsIgnoreCase("Ray")) {
                                switch (this.creatureType) {
                                    case 1: {
                                        this.spawnClass = "MantaRay";
                                        break;
                                    }
                                    case 2: {
                                        this.spawnClass = "StingRay";
                                    }
                                }
                            }
                            if ((tempLiving = (EntityLiving)EntityList.func_188429_b((ResourceLocation)new ResourceLocation("mocreatures:" + this.spawnClass.toLowerCase()), (World)world)) == null || !(tempLiving instanceof IMoCEntity)) break block24;
                            storedCreature = (IMoCTameable)tempLiving;
                            ((EntityLiving)storedCreature).func_70107_b(newPosX, newPosY, newPosZ);
                            storedCreature.setType(this.creatureType);
                            storedCreature.setTamed(true);
                            storedCreature.setPetName(this.name);
                            storedCreature.setOwnerPetId(this.PetId);
                            storedCreature.setOwnerId(player.func_110124_au());
                            this.ownerName = player.func_70005_c_();
                            ((EntityLiving)storedCreature).func_70606_j(this.health);
                            storedCreature.setEdad(this.edad);
                            storedCreature.setAdult(this.adult);
                            if (storedCreature instanceof MoCEntityBigCat) {
                                ((MoCEntityBigCat)storedCreature).setHasAmulet(true);
                            }
                            if (this.spawnClass.equalsIgnoreCase("Kitty")) {
                                ((MoCEntityKitty)storedCreature).setKittyState(3);
                            }
                            if (this.ownerUniqueId != null) break block25;
                            this.ownerUniqueId = player.func_110124_au();
                            if (MoCreatures.instance.mapData == null) break block26;
                            newOwner = MoCreatures.instance.mapData.getPetData(player.func_110124_au());
                            maxCount = MoCreatures.proxy.maxTamed;
                            if (MoCTools.isThisPlayerAnOP(player)) {
                                maxCount = MoCreatures.proxy.maxOPTamed;
                            }
                            if (newOwner != null) break block27;
                            if (maxCount > 0 || !MoCreatures.proxy.enableOwnership) {
                                MoCreatures.instance.mapData.updateOwnerPet(storedCreature);
                            }
                            break block26;
                        }
                        if (newOwner.getTamedList().func_74745_c() >= maxCount && MoCreatures.proxy.enableOwnership) break block26;
                        MoCreatures.instance.mapData.updateOwnerPet(storedCreature);
                        break block26;
                    }
                    if (!this.ownerUniqueId.equals(player.func_110124_au()) && MoCreatures.instance.mapData != null) {
                        MoCPetData oldOwner = MoCreatures.instance.mapData.getPetData(this.ownerUniqueId);
                        MoCPetData newOwner = MoCreatures.instance.mapData.getPetData(player.func_110124_au());
                        int maxCount = MoCreatures.proxy.maxTamed;
                        if (MoCTools.isThisPlayerAnOP(player)) {
                            maxCount = MoCreatures.proxy.maxOPTamed;
                        }
                        if (newOwner != null && newOwner.getTamedList().func_74745_c() < maxCount || newOwner == null && maxCount > 0 || !MoCreatures.proxy.enableOwnership) {
                            MoCreatures.instance.mapData.updateOwnerPet(storedCreature);
                        }
                        if (oldOwner != null) {
                            for (int j = 0; j < oldOwner.getTamedList().func_74745_c(); ++j) {
                                NBTTagCompound petEntry = oldOwner.getTamedList().func_150305_b(j);
                                if (petEntry.func_74762_e("PetId") != this.PetId) continue;
                                oldOwner.getTamedList().func_74744_a(j);
                            }
                        }
                    }
                }
                if (player.func_130014_f_().func_72838_d((Entity)((EntityLiving)storedCreature))) {
                    MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAppear(((EntityLiving)storedCreature).func_145782_y()), new NetworkRegistry.TargetPoint(player.func_130014_f_().field_73011_w.func_186058_p().func_186068_a(), player.field_70165_t, player.field_70163_u, player.field_70161_v, 64.0));
                    if (this.ownerUniqueId == null || this.name.isEmpty()) {
                        MoCTools.tameWithName(player, storedCreature);
                    }
                    player.func_184611_a(hand, emptyAmulet);
                    MoCPetData petData = MoCreatures.instance.mapData.getPetData(storedCreature.getOwnerId());
                    if (petData != null) {
                        petData.setInAmulet(storedCreature.getOwnerPetId(), false);
                    }
                }
            }
            catch (Exception ex) {
                if (!MoCreatures.proxy.debug) break block24;
                MoCLog.logger.warn("Error spawning creature from fishnet/amulet " + ex);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.PetId = nbt.func_74762_e("PetId");
        this.creatureType = nbt.func_74762_e("CreatureType");
        this.health = nbt.func_74760_g("Health");
        this.edad = nbt.func_74762_e("Edad");
        this.name = nbt.func_74779_i("Name");
        this.spawnClass = nbt.func_74779_i("SpawnClass");
        this.adult = nbt.func_74767_n("Adult");
        this.ownerName = nbt.func_74779_i("OwnerName");
        if (nbt.func_186855_b("OwnerUUID")) {
            this.ownerUniqueId = nbt.func_186857_a("OwnerUUID");
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("PetID", this.PetId);
        nbt.func_74768_a("CreatureType", this.creatureType);
        nbt.func_74776_a("Health", this.health);
        nbt.func_74768_a("Edad", this.edad);
        nbt.func_74778_a("Name", this.name);
        nbt.func_74778_a("SpawnClass", this.spawnClass);
        nbt.func_74757_a("Adult", this.adult);
        nbt.func_74778_a("OwnerName", this.ownerName);
        if (this.ownerUniqueId != null) {
            nbt.func_186854_a("OwnerUUID", this.ownerUniqueId);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        this.initAndReadNBT(stack);
        if (this.spawnClass != "") {
            tooltip.add(TextFormatting.AQUA + this.spawnClass);
        }
        if (this.name != "") {
            tooltip.add(TextFormatting.BLUE + this.name);
        }
        if (this.ownerName != "") {
            tooltip.add(TextFormatting.DARK_BLUE + "Owned by " + this.ownerName);
        }
    }

    private void initAndReadNBT(ItemStack itemstack) {
        if (itemstack.func_77978_p() == null) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbtcompound = itemstack.func_77978_p();
        this.readFromNBT(nbtcompound);
    }
}

