/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks;

import com.ferreusveritas.dynamictrees.ModConfigs;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.cells.CellNull;
import com.ferreusveritas.dynamictrees.api.cells.ICell;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.api.treedata.ITreePart;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.MimicProperty;
import com.ferreusveritas.dynamictrees.entities.EntityFallingTree;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.tileentity.TileEntitySpecies;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictrees.util.BranchDestructionData;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockRooty
extends Block
implements ITreePart,
ITileEntityProvider,
MimicProperty.IMimic {
    public static final PropertyInteger LIFE = PropertyInteger.func_177719_a((String)"life", (int)0, (int)15);

    public BlockRooty(String name, Material material, boolean isTileEntity) {
        super(material);
        this.field_149758_A = isTileEntity;
        this.setRegistryName(name);
        this.func_149663_c(this.getRegistryName().toString());
        this.func_149672_a(SoundType.field_185849_b);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)LIFE, (Comparable)Integer.valueOf(15)));
        this.func_149675_a(true);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        if (this.hasTileEntity(state)) {
            worldIn.func_175713_t(pos);
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return this.field_149758_A;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return this.field_149758_A ? new TileEntitySpecies() : null;
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(id, param);
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{LIFE}, new IUnlistedProperty[]{MimicProperty.MIMIC});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)LIFE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)LIFE);
    }

    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random random) {
        if (random.nextInt(ModConfigs.treeGrowthFolding) == 0) {
            this.updateTree(state, world, pos, random, true);
        }
    }

    public EnumFacing getTrunkDirection(IBlockAccess access, BlockPos rootPos) {
        return EnumFacing.UP;
    }

    public void updateTree(IBlockState rootyState, World world, BlockPos rootPos, Random random, boolean natural) {
        if (CoordUtils.isSurroundedByLoadedChunks(world, rootPos)) {
            BlockPos treePos;
            ITreePart treeBase;
            boolean viable = false;
            Species species = this.getSpecies(rootyState, world, rootPos);
            if (species.isValid() && (treeBase = TreeHelper.getTreePart(world.func_180495_p(treePos = rootPos.func_177972_a(this.getTrunkDirection((IBlockAccess)world, rootPos))))) != TreeHelper.nullTreePart) {
                viable = species.update(world, this, rootPos, this.getSoilLife(rootyState, (IBlockAccess)world, rootPos), treeBase, treePos, random, natural);
            }
            if (!viable) {
                world.func_180501_a(rootPos, this.getDecayBlockState((IBlockAccess)world, rootPos), 3);
            }
        }
    }

    public IBlockState getDecayBlockState(IBlockAccess access, BlockPos pos) {
        return Blocks.field_150346_d.func_176223_P();
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)Blocks.field_150346_d);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        IBlockState mimicState = this.getMimic((IBlockAccess)world, pos);
        return new ItemStack(mimicState.func_177230_c(), 1, mimicState.func_177230_c().func_180651_a(mimicState));
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        return 20.0f;
    }

    protected boolean func_149700_E() {
        return false;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        return this.getSoilLife(blockState, (IBlockAccess)world, pos);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        return this.getFamily(state, (IBlockAccess)world, pos).onTreeActivated(world, pos, state, player, hand, heldItem, facing, hitX, hitY, hitZ);
    }

    public void destroyTree(World world, BlockPos rootPos) {
        Optional<BlockBranch> branch = TreeHelper.getBranchOpt(world.func_180495_p(rootPos.func_177984_a()));
        if (branch.isPresent()) {
            BranchDestructionData destroyData = branch.get().destroyBranchFromNode(world, rootPos.func_177984_a(), EnumFacing.DOWN, true);
            EntityFallingTree.dropTree(world, destroyData, new ArrayList<ItemStack>(0), EntityFallingTree.DestroyType.ROOT);
        }
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.destroyTree(world, pos);
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        this.destroyTree(world, pos);
    }

    public int getSoilLife(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos) {
        return (Integer)blockState.func_177229_b((IProperty)LIFE);
    }

    public void setSoilLife(World world, BlockPos rootPos, int life) {
        Species species = this.getSpecies(world.func_180495_p(rootPos), world, rootPos);
        world.func_180501_a(rootPos, this.func_176223_P().func_177226_a((IProperty)LIFE, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)life, (int)0, (int)15))), 3);
        world.func_175685_c(rootPos, (Block)this, false);
        this.setSpecies(world, rootPos, species);
    }

    public boolean fertilize(World world, BlockPos pos, int amount) {
        int soilLife = this.getSoilLife(world.func_180495_p(pos), (IBlockAccess)world, pos);
        if (soilLife == 0 && amount < 0 || soilLife == 15 && amount > 0) {
            return false;
        }
        this.setSoilLife(world, pos, soilLife + amount);
        return true;
    }

    @Override
    public ICell getHydrationCell(IBlockAccess blockAccess, BlockPos pos, IBlockState blockState, EnumFacing dir, ILeavesProperties leavesTree) {
        return CellNull.NULLCELL;
    }

    @Override
    public GrowSignal growSignal(World world, BlockPos pos, GrowSignal signal) {
        return signal;
    }

    @Override
    public int getRadius(IBlockState blockState) {
        return 8;
    }

    @Override
    public int getRadiusForConnection(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, BlockBranch from, EnumFacing side, int fromRadius) {
        return 8;
    }

    @Override
    public int probabilityForBlock(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, BlockBranch from) {
        return 0;
    }

    public MapSignal startAnalysis(World world, BlockPos rootPos, MapSignal signal) {
        EnumFacing dir = this.getTrunkDirection((IBlockAccess)world, rootPos);
        BlockPos treePos = rootPos.func_177972_a(dir);
        IBlockState treeState = world.func_180495_p(treePos);
        TreeHelper.getTreePart(treeState).analyse(treeState, world, treePos, null, signal);
        return signal;
    }

    @Override
    public boolean shouldAnalyse() {
        return true;
    }

    @Override
    public MapSignal analyse(IBlockState blockState, World world, BlockPos pos, EnumFacing fromDir, MapSignal signal) {
        signal.run(blockState, world, pos, fromDir);
        signal.root = pos;
        signal.found = true;
        return signal;
    }

    @Override
    public int branchSupport(IBlockState blockState, IBlockAccess blockAccess, BlockBranch branch, BlockPos pos, EnumFacing dir, int radius) {
        return dir == EnumFacing.DOWN ? BlockBranch.setSupport(1, 1) : 0;
    }

    @Override
    public TreeFamily getFamily(IBlockState rootyState, IBlockAccess blockAccess, BlockPos rootPos) {
        BlockPos treePos = rootPos.func_177972_a(this.getTrunkDirection(blockAccess, rootPos));
        IBlockState treeState = blockAccess.func_180495_p(treePos);
        return TreeHelper.isBranch(treeState) ? TreeHelper.getBranch(treeState).getFamily(treeState, blockAccess, treePos) : TreeFamily.NULLFAMILY;
    }

    private TileEntitySpecies getTileEntitySpecies(World world, BlockPos pos) {
        return (TileEntitySpecies)world.func_175625_s(pos);
    }

    public Species getSpecies(IBlockState blockState, World world, BlockPos rootPos) {
        Species species;
        TileEntitySpecies rootyDirtTE;
        TreeFamily tree = this.getFamily(blockState, (IBlockAccess)world, rootPos);
        if (this.field_149758_A && (rootyDirtTE = this.getTileEntitySpecies(world, rootPos)) instanceof TileEntitySpecies && (species = rootyDirtTE.getSpecies()).getFamily() == tree) {
            return rootyDirtTE.getSpecies();
        }
        return tree.getSpeciesForLocation(world, rootPos.func_177972_a(this.getTrunkDirection((IBlockAccess)world, rootPos)));
    }

    public void setSpecies(World world, BlockPos rootPos, Species species) {
        TileEntitySpecies rootyDirtTE;
        if (this.field_149758_A && (rootyDirtTE = this.getTileEntitySpecies(world, rootPos)) instanceof TileEntitySpecies) {
            rootyDirtTE.setSpecies(species);
        }
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.BLOCK;
    }

    @Override
    public final ITreePart.TreePartType getTreePartType() {
        return ITreePart.TreePartType.ROOT;
    }

    @Override
    public final boolean isRootNode() {
        return true;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess access, BlockPos pos) {
        return state instanceof IExtendedBlockState ? ((IExtendedBlockState)state).withProperty((IUnlistedProperty)MimicProperty.MIMIC, (Object)this.getMimic(access, pos)) : state;
    }

    @Override
    public IBlockState getMimic(IBlockAccess access, BlockPos pos) {
        return Blocks.field_150346_d.func_176223_P();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        IBlockState state = world.func_180495_p(pos);
        IBlockState mimicState = (IBlockState)((IExtendedBlockState)this.getExtendedState(state, (IBlockAccess)world, pos)).getValue((IUnlistedProperty)MimicProperty.MIMIC);
        manager.func_180533_a(pos, mimicState);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager manager) {
        BlockPos pos = target.func_178782_a();
        IBlockState mimicState = (IBlockState)((IExtendedBlockState)this.getExtendedState(state, (IBlockAccess)world, pos)).getValue((IUnlistedProperty)MimicProperty.MIMIC);
        Random rand = world.field_73012_v;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        AxisAlignedBB axisalignedbb = state.func_185900_c((IBlockAccess)world, pos);
        double d0 = (double)x + rand.nextDouble() * (axisalignedbb.field_72336_d - axisalignedbb.field_72340_a - 0.2) + 0.1 + axisalignedbb.field_72340_a;
        double d1 = (double)y + rand.nextDouble() * (axisalignedbb.field_72337_e - axisalignedbb.field_72338_b - 0.2) + 0.1 + axisalignedbb.field_72338_b;
        double d2 = (double)z + rand.nextDouble() * (axisalignedbb.field_72334_f - axisalignedbb.field_72339_c - 0.2) + 0.1 + axisalignedbb.field_72339_c;
        switch (target.field_178784_b) {
            case DOWN: {
                d1 = (double)y + axisalignedbb.field_72338_b - 0.1;
                break;
            }
            case UP: {
                d1 = (double)y + axisalignedbb.field_72337_e + 0.1;
                break;
            }
            case NORTH: {
                d2 = (double)z + axisalignedbb.field_72339_c - 0.1;
                break;
            }
            case SOUTH: {
                d2 = (double)z + axisalignedbb.field_72334_f + 0.1;
                break;
            }
            case WEST: {
                d0 = (double)x + axisalignedbb.field_72340_a - 0.1;
                break;
            }
            case EAST: {
                d0 = (double)x + axisalignedbb.field_72336_d + 0.1;
            }
        }
        ParticleDigging particle = (ParticleDigging)manager.func_178927_a(EnumParticleTypes.BLOCK_CRACK.func_179348_c(), d0, d1, d2, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)mimicState)});
        if (particle != null) {
            particle.func_174846_a(pos).func_70543_e(0.2f).func_70541_f(0.6f);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int rootColor(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        return this.getFamily(state, blockAccess, pos).getRootColor(state, blockAccess, pos);
    }
}

