/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.entities;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.ModConfigs;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.entities.animation.AnimationHandlerData;
import com.ferreusveritas.dynamictrees.entities.animation.AnimationHandlers;
import com.ferreusveritas.dynamictrees.entities.animation.IAnimationHandler;
import com.ferreusveritas.dynamictrees.models.IModelTracker;
import com.ferreusveritas.dynamictrees.models.ModelTrackerCacheEntityFallingTree;
import com.ferreusveritas.dynamictrees.util.BlockBounds;
import com.ferreusveritas.dynamictrees.util.BranchDestructionData;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityFallingTree
extends Entity
implements IModelTracker {
    public static final DataParameter<NBTTagCompound> voxelDataParameter = EntityDataManager.func_187226_a(EntityFallingTree.class, (DataSerializer)DataSerializers.field_192734_n);
    protected List<ItemStack> payload = new ArrayList<ItemStack>(0);
    protected BranchDestructionData destroyData = new BranchDestructionData();
    protected Vec3d geomCenter = Vec3d.field_186680_a;
    protected Vec3d massCenter = Vec3d.field_186680_a;
    protected AxisAlignedBB normAABB = new AxisAlignedBB(BlockPos.field_177992_a);
    protected boolean clientBuilt = false;
    protected boolean field_70148_d = true;
    public boolean landed = false;
    public DestroyType destroyType = DestroyType.HARVEST;
    public boolean onFire = false;
    public static IAnimationHandler AnimHandlerFall = AnimationHandlers.falloverAnimationHandler;
    public static IAnimationHandler AnimHandlerDrop = AnimationHandlers.defaultAnimationHandler;
    public static IAnimationHandler AnimHandlerBurn = AnimationHandlers.defaultAnimationHandler;
    public static IAnimationHandler AnimHandlerFling = AnimationHandlers.defaultAnimationHandler;
    public static IAnimationHandler AnimHandlerBlast = AnimationHandlers.blastAnimationHandler;
    public IAnimationHandler currentAnimationHandler = AnimationHandlers.voidAnimationHandler;
    public AnimationHandlerData animationHandlerData = null;

    public EntityFallingTree(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 1.0f);
    }

    public boolean isClientBuilt() {
        return this.clientBuilt;
    }

    public EntityFallingTree setData(BranchDestructionData destroyData, List<ItemStack> payload, DestroyType destroyType) {
        this.destroyData = destroyData;
        if (destroyData.getNumBranches() == 0) {
            System.err.println("Warning: Tried to create a EntityFallingTree with no branch blocks. This shouldn't be possible.");
            new Exception().printStackTrace();
            this.func_70106_y();
            return this;
        }
        BlockPos cutPos = destroyData.cutPos;
        this.payload = payload;
        this.destroyType = destroyType;
        this.onFire = destroyType == DestroyType.FIRE;
        this.field_70165_t = (double)cutPos.func_177958_n() + 0.5;
        this.field_70163_u = cutPos.func_177956_o();
        this.field_70161_v = (double)cutPos.func_177952_p() + 0.5;
        int numBlocks = destroyData.getNumBranches();
        this.geomCenter = new Vec3d(0.0, 0.0, 0.0);
        double totalMass = 0.0;
        for (int index = 0; index < destroyData.getNumBranches(); ++index) {
            BlockPos relPos = destroyData.getBranchRelPos(index);
            int radius = destroyData.getBranchRadius(index);
            float mass = (float)(radius * radius * 64) / 4096.0f;
            totalMass += (double)mass;
            Vec3d relVec = new Vec3d((double)relPos.func_177958_n(), (double)relPos.func_177956_o(), (double)relPos.func_177952_p());
            this.geomCenter = this.geomCenter.func_178787_e(relVec);
            this.massCenter = this.massCenter.func_178787_e(relVec.func_186678_a((double)mass));
        }
        this.geomCenter = this.geomCenter.func_186678_a(1.0 / (double)numBlocks);
        this.massCenter = this.massCenter.func_186678_a(1.0 / totalMass);
        this.func_174826_a(this.buildAABBFromDestroyData(destroyData).func_72317_d(this.field_70165_t, this.field_70163_u, this.field_70161_v));
        this.setVoxelData(this.buildVoxelData(destroyData));
        return this;
    }

    public NBTTagCompound buildVoxelData(BranchDestructionData destroyData) {
        NBTTagCompound tag = new NBTTagCompound();
        destroyData.writeToNBT(tag);
        tag.func_74780_a("geomx", this.geomCenter.field_72450_a);
        tag.func_74780_a("geomy", this.geomCenter.field_72448_b);
        tag.func_74780_a("geomz", this.geomCenter.field_72449_c);
        tag.func_74780_a("massx", this.massCenter.field_72450_a);
        tag.func_74780_a("massy", this.massCenter.field_72448_b);
        tag.func_74780_a("massz", this.massCenter.field_72449_c);
        tag.func_74768_a("destroytype", this.destroyType.ordinal());
        tag.func_74757_a("onfire", this.onFire);
        return tag;
    }

    public void buildClient() {
        NBTTagCompound tag = this.getVoxelData();
        if (tag.func_74764_b("species")) {
            this.destroyData = new BranchDestructionData(tag);
            if (this.destroyData.getNumBranches() == 0) {
                this.func_70106_y();
            }
            this.destroyType = DestroyType.values()[tag.func_74762_e("destroytype")];
            this.geomCenter = new Vec3d(tag.func_74769_h("geomx"), tag.func_74769_h("geomy"), tag.func_74769_h("geomz"));
            this.massCenter = new Vec3d(tag.func_74769_h("massx"), tag.func_74769_h("massy"), tag.func_74769_h("massz"));
            this.buildAABBFromDestroyData(this.destroyData);
            this.func_174826_a(this.normAABB.func_72317_d(this.field_70165_t, this.field_70163_u, this.field_70161_v));
            this.onFire = tag.func_74767_n("onfire");
            this.clientBuilt = true;
        } else {
            System.out.println("Error: No species tag has been set");
        }
        BlockBounds renderBounds = new BlockBounds(this.destroyData.cutPos);
        for (BlockPos absPos : Iterables.concat(this.destroyData.getPositions(BranchDestructionData.PosType.BRANCHES), this.destroyData.getPositions(BranchDestructionData.PosType.LEAVES))) {
            this.field_70170_p.func_180501_a(absPos, ModBlocks.blockStates.air, 0);
            renderBounds.union(absPos);
        }
        this.cleanupShellBlocks(this.destroyData);
        this.field_70170_p.func_175704_b(renderBounds.getMin(), renderBounds.getMax());
    }

    protected void cleanupShellBlocks(BranchDestructionData destroyData) {
        BlockPos cutPos = destroyData.cutPos;
        for (int i = 0; i < destroyData.getNumBranches(); ++i) {
            if (destroyData.getBranchRadius(i) <= 8) continue;
            BlockPos pos = destroyData.getBranchRelPos(i).func_177971_a((Vec3i)cutPos);
            for (CoordUtils.Surround dir : CoordUtils.Surround.values()) {
                BlockPos dPos = pos.func_177971_a(dir.getOffset());
                if (this.field_70170_p.func_180495_p(dPos).func_177230_c() != ModBlocks.blockTrunkShell) continue;
                this.field_70170_p.func_175698_g(dPos);
            }
        }
    }

    public AxisAlignedBB buildAABBFromDestroyData(BranchDestructionData destroyData) {
        this.normAABB = new AxisAlignedBB(BlockPos.field_177992_a);
        for (BlockPos relPos : destroyData.getPositions(BranchDestructionData.PosType.BRANCHES, false)) {
            this.normAABB = this.normAABB.func_111270_a(new AxisAlignedBB(relPos));
        }
        double height = this.normAABB.field_72337_e - this.normAABB.field_72338_b;
        double width = MathHelper.func_76132_a((double)(this.normAABB.field_72336_d - this.normAABB.field_72340_a), (double)(this.normAABB.field_72334_f - this.normAABB.field_72339_c));
        double grow = Math.max(0.0, height - width / 2.0) + 2.0;
        this.normAABB = this.normAABB.func_72314_b(grow + 4.0, 4.0, grow + 4.0);
        return this.normAABB;
    }

    public BranchDestructionData getDestroyData() {
        return this.destroyData;
    }

    public List<ItemStack> getPayload() {
        return this.payload;
    }

    public Vec3d getGeomCenter() {
        return this.geomCenter;
    }

    public Vec3d getMassCenter() {
        return this.massCenter;
    }

    public void func_70107_b(double x, double y, double z) {
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        this.func_174826_a(this.normAABB != null ? this.normAABB.func_72317_d(this.field_70165_t, this.field_70163_u, this.field_70161_v) : new AxisAlignedBB(BlockPos.field_177992_a));
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.field_70170_p.field_72995_K && !this.clientBuilt) {
            this.buildClient();
            if (this.field_70128_L) {
                return;
            }
        }
        if (!this.field_70170_p.field_72995_K && this.field_70148_d) {
            this.updateNeighbors();
        }
        this.handleMotion();
        this.func_174826_a(this.normAABB.func_72317_d(this.field_70165_t, this.field_70163_u, this.field_70161_v));
        if (this.shouldDie()) {
            this.dropPayLoad();
            this.func_70106_y();
            this.modelCleanup();
        }
        this.field_70148_d = false;
    }

    protected void updateNeighbors() {
        HashSet destroyed = new HashSet();
        HashSet<BlockPos> toUpdate = new HashSet<BlockPos>();
        Iterables.concat(this.destroyData.getPositions(BranchDestructionData.PosType.BRANCHES), this.destroyData.getPositions(BranchDestructionData.PosType.LEAVES)).forEach(pos -> destroyed.add(pos));
        for (BlockPos d : destroyed) {
            for (EnumFacing dir : EnumFacing.values()) {
                BlockPos dPos = d.func_177972_a(dir);
                if (destroyed.contains(dPos)) continue;
                toUpdate.add(dPos);
            }
        }
        toUpdate.forEach(pos -> this.field_70170_p.func_190524_a(pos, Blocks.field_150350_a, pos));
    }

    protected IAnimationHandler selectAnimationHandler() {
        return ModConfigs.enableFallingTrees ? this.destroyData.species.selectAnimationHandler(this) : AnimationHandlers.voidAnimationHandler;
    }

    public IAnimationHandler defaultAnimationHandler() {
        if (this.destroyType == DestroyType.VOID || this.destroyType == DestroyType.ROOT) {
            return AnimationHandlers.voidAnimationHandler;
        }
        if (this.destroyType == DestroyType.BLAST) {
            return AnimHandlerBlast;
        }
        if (this.destroyType == DestroyType.FIRE) {
            return AnimHandlerBurn;
        }
        if (this.getDestroyData().cutDir == EnumFacing.DOWN) {
            if (this.getMassCenter().field_72448_b >= 1.0) {
                return AnimHandlerFall;
            }
            return AnimHandlerFling;
        }
        return AnimHandlerDrop;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void modelCleanup() {
        ModelTrackerCacheEntityFallingTree.cleanupModels(this.field_70170_p, this);
    }

    public void handleMotion() {
        if (this.field_70148_d) {
            this.currentAnimationHandler = this.selectAnimationHandler();
            this.currentAnimationHandler.initMotion(this);
        } else {
            this.currentAnimationHandler.handleMotion(this);
        }
    }

    public void dropPayLoad() {
        if (!this.field_70170_p.field_72995_K) {
            this.currentAnimationHandler.dropPayload(this);
        }
    }

    public boolean shouldDie() {
        return this.field_70173_aa > 20 && this.currentAnimationHandler.shouldDie(this);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldRender() {
        return this.currentAnimationHandler.shouldRender(this);
    }

    public static void standardDropLogsPayload(EntityFallingTree entity) {
        World world = entity.field_70170_p;
        if (!world.field_72995_K) {
            BlockPos cutPos = entity.getDestroyData().cutPos;
            entity.getPayload().forEach(i -> EntityFallingTree.spawnItemAsEntity(world, cutPos, i));
        }
    }

    public static void standardDropLeavesPayLoad(EntityFallingTree entity) {
        World world = entity.field_70170_p;
        if (!world.field_72995_K) {
            BlockPos cutPos = entity.getDestroyData().cutPos;
            entity.getDestroyData().leavesDrops.forEach(bis -> Block.func_180635_a((World)world, (BlockPos)cutPos.func_177971_a((Vec3i)bis.pos), (ItemStack)bis.stack));
        }
    }

    public static void spawnItemAsEntity(World worldIn, BlockPos pos, ItemStack stack) {
        if (!worldIn.field_72995_K && !stack.func_190926_b() && worldIn.func_82736_K().func_82766_b("doTileDrops") && !worldIn.restoringBlockSnapshots) {
            EntityItem entityitem = new EntityItem(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack);
            entityitem.field_70159_w = 0.0;
            entityitem.field_70181_x = 0.0;
            entityitem.field_70179_y = 0.0;
            entityitem.func_174869_p();
            worldIn.func_72838_d((Entity)entityitem);
        }
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(voxelDataParameter, (Object)new NBTTagCompound());
    }

    public void cleanupRootyDirt() {
        BlockPos rootPos;
        IBlockState belowState;
        if (!this.field_70170_p.field_72995_K && TreeHelper.isRooty(belowState = this.field_70170_p.func_180495_p(rootPos = this.getDestroyData().cutPos.func_177977_b()))) {
            Random rand = new Random(){

                @Override
                public int nextInt(int bound) {
                    return 0;
                }
            };
            belowState.func_177230_c().func_180645_a(this.field_70170_p, this.getDestroyData().cutPos.func_177977_b(), belowState, rand);
            belowState = this.field_70170_p.func_180495_p(rootPos);
            IBlockState biomeState = this.field_70170_p.func_180494_b((BlockPos)rootPos).field_76752_A;
            Material belowMaterial = belowState.func_185904_a();
            Material biomeMaterial = biomeState.func_185904_a();
            if (biomeMaterial == Material.field_151577_b) {
                biomeMaterial = Material.field_151578_c;
            }
            if (belowMaterial == Material.field_151577_b) {
                belowMaterial = Material.field_151578_c;
            }
            if (biomeMaterial == belowMaterial && this.getDestroyData().species.getAcceptableSoils().contains(biomeState.func_177230_c())) {
                for (EnumFacing dir : EnumFacing.field_176754_o) {
                    BlockPos dPos = rootPos.func_177972_a(dir);
                    IBlockState findState = this.field_70170_p.func_180495_p(dPos);
                    if (findState != biomeState) continue;
                    this.field_70170_p.func_175656_a(rootPos, this.field_70170_p.func_180494_b((BlockPos)rootPos).field_76752_A);
                    return;
                }
            }
        }
    }

    public void setVoxelData(NBTTagCompound tag) {
        this.func_184212_Q().func_187227_b(voxelDataParameter, (Object)tag);
    }

    public NBTTagCompound getVoxelData() {
        return (NBTTagCompound)this.func_184212_Q().func_187225_a(voxelDataParameter);
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.func_70106_y();
    }

    protected void func_70014_b(NBTTagCompound compound) {
    }

    public static EntityFallingTree dropTree(World world, BranchDestructionData destroyData, List<ItemStack> woodDropList, DestroyType destroyType) {
        if (!world.field_72995_K) {
            EntityFallingTree entity = new EntityFallingTree(world).setData(destroyData, woodDropList, destroyType);
            if (entity.func_70089_S()) {
                world.func_72838_d((Entity)entity);
            }
            return entity;
        }
        return null;
    }

    public static enum DestroyType {
        VOID,
        HARVEST,
        BLAST,
        FIRE,
        ROOT;

    }
}

