/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.items;

import com.ferreusveritas.dynamictrees.ModTabs;
import com.ferreusveritas.dynamictrees.ModTrees;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.substances.IEmptiable;
import com.ferreusveritas.dynamictrees.api.substances.ISubstanceEffect;
import com.ferreusveritas.dynamictrees.api.substances.ISubstanceEffectProvider;
import com.ferreusveritas.dynamictrees.systems.substances.SubstanceDeplete;
import com.ferreusveritas.dynamictrees.systems.substances.SubstanceDisease;
import com.ferreusveritas.dynamictrees.systems.substances.SubstanceFertilize;
import com.ferreusveritas.dynamictrees.systems.substances.SubstanceFreeze;
import com.ferreusveritas.dynamictrees.systems.substances.SubstanceGrowth;
import com.ferreusveritas.dynamictrees.systems.substances.SubstanceTransform;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.registries.IForgeRegistry;

public class DendroPotion
extends Item
implements ISubstanceEffectProvider,
IEmptiable {
    public static final String name = "dendropotion";

    public DendroPotion() {
        this(name);
    }

    public DendroPotion(String name) {
        this.setRegistryName(name);
        this.func_77655_b(this.getRegistryName().toString());
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77637_a(ModTabs.dynamicTreesTab);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            for (DendroPotionType type : DendroPotionType.values()) {
                subItems.add((Object)new ItemStack((Item)this, 1, type.getIndex()));
            }
        }
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "." + this.getPotionType(stack).getName();
    }

    public DendroPotionType getPotionTypeForDamage(int damage) {
        return DendroPotionType.values()[damage % DendroPotionType.values().length];
    }

    public DendroPotionType getPotionType(ItemStack stack) {
        return this.getPotionTypeForDamage(stack.func_77952_i());
    }

    @Override
    public ISubstanceEffect getSubstanceEffect(ItemStack itemStack) {
        switch (this.getPotionType(itemStack)) {
            default: {
                return null;
            }
            case BURGEONING: {
                return new SubstanceGrowth();
            }
            case DEFOLIANCE: {
                return new SubstanceDisease();
            }
            case DEPLETION: {
                return new SubstanceDeplete().setAmount(15);
            }
            case FERTILITY: {
                return new SubstanceFertilize().setAmount(15);
            }
            case PERSISTANCE: {
                return new SubstanceFreeze();
            }
            case TRANSFORM: 
        }
        return new SubstanceTransform(this.getTargetSpecies(itemStack));
    }

    public Species getTargetSpecies(ItemStack itemStack) {
        String targetTree;
        NBTTagCompound nbtTag;
        if (itemStack.func_77942_o() && (nbtTag = itemStack.func_77978_p()).func_74764_b("target") && !(targetTree = nbtTag.func_74779_i("target")).equals("")) {
            return TreeRegistry.findSpecies(new ResourceLocation(targetTree));
        }
        return null;
    }

    public ItemStack setTargetTree(ItemStack itemStack, TreeFamily tree) {
        NBTTagCompound nbtTag = itemStack.func_77942_o() ? itemStack.func_77978_p() : new NBTTagCompound();
        nbtTag.func_74778_a("target", tree.getCommonSpecies().getRegistryName().toString());
        itemStack.func_77982_d(nbtTag);
        return itemStack;
    }

    public DendroPotion registerRecipes(IForgeRegistry<IRecipe> registry) {
        PotionType awkward = (PotionType)PotionType.field_185176_a.func_82594_a((Object)new ResourceLocation("awkward"));
        BrewingRecipeRegistry.addRecipe((ItemStack)PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)awkward), (ItemStack)new ItemStack(Items.field_151044_h, 1, 1), (ItemStack)new ItemStack((Item)this, 1, DendroPotionType.BIOCHAR.getIndex()));
        BrewingRecipeRegistry.addRecipe((ItemStack)new ItemStack((Item)this, 1, DendroPotionType.BIOCHAR.getIndex()), (ItemStack)new ItemStack(Items.field_151123_aH), (ItemStack)new ItemStack((Item)this, 1, DendroPotionType.DEPLETION.getIndex()));
        BrewingRecipeRegistry.addRecipe((ItemStack)new ItemStack((Item)this, 1, DendroPotionType.BIOCHAR.getIndex()), (ItemStack)new ItemStack(Items.field_151080_bb), (ItemStack)new ItemStack((Item)this, 1, DendroPotionType.DEFOLIANCE.getIndex()));
        BrewingRecipeRegistry.addRecipe((ItemStack)new ItemStack((Item)this, 1, DendroPotionType.BIOCHAR.getIndex()), (ItemStack)new ItemStack(Items.field_151073_bk), (ItemStack)new ItemStack((Item)this, 1, DendroPotionType.BURGEONING.getIndex()));
        BrewingRecipeRegistry.addRecipe((ItemStack)new ItemStack((Item)this, 1, DendroPotionType.BIOCHAR.getIndex()), (ItemStack)new ItemStack(Items.field_151115_aP), (ItemStack)new ItemStack((Item)this, 1, DendroPotionType.FERTILITY.getIndex()));
        BrewingRecipeRegistry.addRecipe((ItemStack)new ItemStack((Item)this, 1, DendroPotionType.BIOCHAR.getIndex()), (ItemStack)new ItemStack((Block)Blocks.field_150328_O, 1, 1), (ItemStack)new ItemStack((Item)this, 1, DendroPotionType.PERSISTANCE.getIndex()));
        BrewingRecipeRegistry.addRecipe((ItemStack)new ItemStack((Item)this, 1, DendroPotionType.BIOCHAR.getIndex()), (ItemStack)new ItemStack(Items.field_179563_cD), (ItemStack)new ItemStack((Item)this, 1, DendroPotionType.TRANSFORM.getIndex()));
        for (TreeFamily treeFamily : ModTrees.baseFamilies) {
            ItemStack outputStack = this.setTargetTree(new ItemStack((Item)this, 1, DendroPotionType.TRANSFORM.getIndex()), treeFamily);
            BrewingRecipeRegistry.addRecipe((ItemStack)new ItemStack((Item)this, 1, DendroPotionType.TRANSFORM.getIndex()), (ItemStack)treeFamily.getCommonSpecies().getSeedStack(1), (ItemStack)outputStack);
        }
        return this;
    }

    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag tooltipFlag) {
        super.func_77624_a(stack, world, tooltip, tooltipFlag);
        DendroPotionType potionType = this.getPotionType(stack);
        if (potionType == DendroPotionType.TRANSFORM) {
            Species species = this.getTargetSpecies(stack);
            if (species == null) {
                tooltip.add(this.getPotionType(stack).getLore());
            } else {
                tooltip.add("Transform a tree into a " + species.getRegistryName().func_110623_a() + " tree");
            }
        } else {
            tooltip.add(this.getPotionType(stack).getLore());
        }
    }

    public int getColor(ItemStack stack, int tint) {
        return tint == 0 ? this.getPotionType(stack).getColor() : -1;
    }

    @Override
    public ItemStack getEmptyContainer() {
        return new ItemStack(Items.field_151069_bo);
    }

    public static enum DendroPotionType {
        BIOCHAR(0, "biochar", 2564892, "Base tree potion for brewing"),
        DEPLETION(1, "depletion", 7781997, "Destroys tree soil fertility"),
        DEFOLIANCE(2, "defoliance", 14913565, "Slowly destroy a tree"),
        BURGEONING(3, "burgeoning", 11124414, "Quickly grow a tree"),
        FERTILITY(4, "fertility", 4903936, "Fully fertilizes tree soil"),
        PERSISTANCE(5, "persistance", 3709695, "Stops tree from changing"),
        TRANSFORM(6, "transform", 8370340, "Base tree potion for brewing transformations");

        private final int index;
        private final String name;
        private final int color;
        private final String lore;
        ItemPotion p;

        private DendroPotionType(int index, String name, int color, String lore) {
            this.index = index;
            this.name = name;
            this.color = color;
            this.lore = lore;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public int getColor() {
            return this.color;
        }

        public String getLore() {
            return this.lore;
        }
    }
}

