/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.trees;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.ModConfigs;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.systems.dropcreators.DropCreatorApple;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenFruit;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenVine;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.SpeciesRare;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictrees.trees.TreeFamilyVanilla;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class TreeOak
extends TreeFamilyVanilla {
    Species swampSpecies;
    Species appleSpecies;

    public TreeOak() {
        super(BlockPlanks.EnumType.OAK);
        this.hasConiferVariants = true;
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() instanceof BlockOldLeaf && state.func_177229_b((IProperty)BlockOldLeaf.field_176239_P) == BlockPlanks.EnumType.OAK);
    }

    @Override
    public void createSpecies() {
        this.setCommonSpecies(new SpeciesOak((TreeFamily)this));
        this.swampSpecies = new SpeciesSwampOak((TreeFamily)this);
        this.appleSpecies = new SpeciesAppleOak((TreeFamily)this);
    }

    @Override
    public void registerSpecies(IForgeRegistry<Species> speciesRegistry) {
        super.registerSpecies(speciesRegistry);
        speciesRegistry.register((IForgeRegistryEntry)this.swampSpecies);
        speciesRegistry.register((IForgeRegistryEntry)this.appleSpecies);
    }

    @Override
    public List<Item> getRegisterableItems(List<Item> itemList) {
        itemList.add(this.appleSpecies.getSeed());
        return super.getRegisterableItems(itemList);
    }

    @Override
    public Species getSpeciesForLocation(World world, BlockPos trunkPos) {
        if (BiomeDictionary.hasType((Biome)world.func_180494_b(trunkPos), (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
            return this.swampSpecies;
        }
        return super.getSpeciesForLocation(world, trunkPos);
    }

    @Override
    public boolean isThick() {
        return true;
    }

    @Override
    public boolean autoCreateBranch() {
        return true;
    }

    public class SpeciesAppleOak
    extends SpeciesRare {
        private static final String speciesName = "apple";

        public SpeciesAppleOak(TreeFamily treeFamily) {
            super(new ResourceLocation(treeFamily.getName().func_110624_b(), speciesName), treeFamily);
            this.setBasicGrowingParameters(0.4f, 10.0f, 1, 4, 0.7f);
            this.envFactor(BiomeDictionary.Type.COLD, 0.75f);
            this.envFactor(BiomeDictionary.Type.HOT, 0.75f);
            this.envFactor(BiomeDictionary.Type.DRY, 0.25f);
            this.generateSeed();
            this.addGenFeature(new FeatureGenFruit(ModBlocks.blockApple).setRayDistance(4.0f));
        }

        @Override
        public boolean isBiomePerfect(Biome biome) {
            return biome == Biomes.field_76772_c;
        }
    }

    public class SpeciesSwampOak
    extends Species {
        SpeciesSwampOak(TreeFamily treeFamily) {
            super(new ResourceLocation(treeFamily.getName().func_110624_b(), treeFamily.getName().func_110623_a() + "swamp"), treeFamily);
            this.setBasicGrowingParameters(0.3f, 12.0f, this.upProbability, this.lowestBranchHeight, 0.8f);
            this.envFactor(BiomeDictionary.Type.COLD, 0.5f);
            this.envFactor(BiomeDictionary.Type.DRY, 0.5f);
            this.setupStandardSeedDropping();
            this.addGenFeature(new FeatureGenVine().setMaxLength(7).setVerSpread(30.0f).setRayDistance(6.0f).setQuantity(24));
        }

        @Override
        public boolean isBiomePerfect(Biome biome) {
            return SpeciesSwampOak.isOneOfBiomes(biome, Biomes.field_76780_h);
        }

        @Override
        public boolean isAcceptableSoilForWorldgen(World world, BlockPos pos, IBlockState soilBlockState) {
            BlockPos down;
            Biome biome;
            if (soilBlockState.func_177230_c() == Blocks.field_150355_j && BiomeDictionary.hasType((Biome)(biome = world.func_180494_b(pos)), (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP) && this.isAcceptableSoil(world, down = pos.func_177977_b(), world.func_180495_p(down))) {
                return true;
            }
            return super.isAcceptableSoilForWorldgen(world, pos, soilBlockState);
        }

        @Override
        public ItemStack getSeedStack(int qty) {
            return TreeOak.this.getCommonSpecies().getSeedStack(qty);
        }

        @Override
        public Seed getSeed() {
            return TreeOak.this.getCommonSpecies().getSeed();
        }

        @Override
        public boolean rot(World world, BlockPos pos, int neighborCount, int radius, Random random, boolean rapid) {
            if (super.rot(world, pos, neighborCount, radius, random, rapid)) {
                if (radius > 4 && TreeHelper.isRooty(world.func_180495_p(pos.func_177977_b())) && world.func_175642_b(EnumSkyBlock.SKY, pos) < 4) {
                    world.func_175656_a(pos, random.nextInt(3) == 0 ? ModBlocks.blockStates.redMushroom : ModBlocks.blockStates.brownMushroom);
                    world.func_175656_a(pos.func_177977_b(), ModBlocks.blockStates.podzol);
                }
                return true;
            }
            return false;
        }
    }

    public class SpeciesOak
    extends Species {
        SpeciesOak(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily);
            this.setBasicGrowingParameters(0.3f, 12.0f, this.upProbability, this.lowestBranchHeight, 0.8f);
            this.envFactor(BiomeDictionary.Type.COLD, 0.75f);
            this.envFactor(BiomeDictionary.Type.HOT, 0.5f);
            this.envFactor(BiomeDictionary.Type.DRY, 0.5f);
            this.envFactor(BiomeDictionary.Type.FOREST, 1.05f);
            if (ModConfigs.worldGen && !ModConfigs.enableAppleTrees) {
                this.addDropCreator(new DropCreatorApple());
            }
            this.setupStandardSeedDropping();
        }

        @Override
        public boolean isBiomePerfect(Biome biome) {
            return SpeciesOak.isOneOfBiomes(biome, Biomes.field_76767_f, Biomes.field_76785_t);
        }

        @Override
        public boolean rot(World world, BlockPos pos, int neighborCount, int radius, Random random, boolean rapid) {
            if (super.rot(world, pos, neighborCount, radius, random, rapid)) {
                if (radius > 4 && TreeHelper.isRooty(world.func_180495_p(pos.func_177977_b())) && world.func_175642_b(EnumSkyBlock.SKY, pos) < 4) {
                    world.func_175656_a(pos, random.nextInt(3) == 0 ? ModBlocks.blockStates.redMushroom : ModBlocks.blockStates.brownMushroom);
                    world.func_175656_a(pos.func_177977_b(), ModBlocks.blockStates.podzol);
                }
                return true;
            }
            return false;
        }
    }
}

