/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.gui;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.stream.IntStream;
import javax.imageio.ImageIO;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.montoyo.wd.utilities.Log;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderRecipe
extends GuiScreen {
    private static final ResourceLocation CRAFTING_TABLE_GUI_TEXTURES = new ResourceLocation("textures/gui/container/crafting_table.png");
    private static final int SIZE_X = 176;
    private static final int SIZE_Y = 166;
    private int x;
    private int y;
    private RenderItem renderItem;
    private final ItemStack[] recipe = new ItemStack[9];
    private ItemStack recipeResult;
    private String recipeName;
    private final ArrayList<NameRecipePair> recipes = new ArrayList();
    private IntBuffer buffer;
    private int[] array;

    public void func_73866_w_() {
        this.x = (this.field_146294_l - 176) / 2;
        this.y = (this.field_146295_m - 166) / 2;
        this.renderItem = this.field_146297_k.func_175599_af();
        for (IRecipe recipe : CraftingManager.field_193380_a) {
            ResourceLocation regName = recipe.getRegistryName();
            if (regName == null || !regName.func_110624_b().equals("webdisplays")) continue;
            if (recipe instanceof ShapedRecipes) {
                this.recipes.add(new NameRecipePair(regName.func_110623_a(), (ShapedRecipes)recipe));
                continue;
            }
            Log.warning("Found non-shaped recipe %s", regName.toString());
        }
        Log.info("Loaded %d recipes", this.recipes.size());
        this.nextRecipe();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(CRAFTING_TABLE_GUI_TEXTURES);
        this.func_73729_b(this.x, this.y, 0, 0, 176, 166);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.crafting", (Object[])new Object[0]), this.x + 28, this.y + 6, 0x404040);
        RenderHelper.func_74520_c();
        GlStateManager.func_179140_f();
        for (int sy = 0; sy < 3; ++sy) {
            for (int sx = 0; sx < 3; ++sx) {
                ItemStack is = this.recipe[sy * 3 + sx];
                if (is == null) continue;
                int x = this.x + 30 + sx * 18;
                int y = this.y + 17 + sy * 18;
                this.renderItem.func_184391_a((EntityLivingBase)this.field_146297_k.field_71439_g, is, x, y);
                this.renderItem.func_180453_a(this.field_146289_q, is, x, y, null);
            }
        }
        if (this.recipeResult != null) {
            this.renderItem.func_184391_a((EntityLivingBase)this.field_146297_k.field_71439_g, this.recipeResult, this.x + 124, this.y + 35);
            this.renderItem.func_180453_a(this.field_146289_q, this.recipeResult, this.x + 124, this.y + 35, null);
        }
        GlStateManager.func_179145_e();
        RenderHelper.func_74518_a();
    }

    private void setRecipe(ShapedRecipes recipe) {
        IntStream.range(0, this.recipe.length).forEach(i -> {
            this.recipe[i] = null;
        });
        NonNullList ingredients = recipe.func_192400_c();
        int pos = 0;
        for (int y = 0; y < recipe.getRecipeHeight(); ++y) {
            for (int x = 0; x < recipe.getRecipeWidth(); ++x) {
                ItemStack[] stacks;
                if ((stacks = ((Ingredient)ingredients.get(pos++)).func_193365_a()).length <= 0) continue;
                this.recipe[y * 3 + x] = stacks[0];
            }
        }
        this.recipeResult = recipe.func_77571_b();
    }

    private void nextRecipe() {
        if (this.recipes.isEmpty()) {
            this.field_146297_k.func_147108_a(null);
        } else {
            NameRecipePair pair = this.recipes.remove(0);
            this.setRecipe(pair.recipe);
            this.recipeName = pair.name;
        }
    }

    private int screen2DisplayX(int x) {
        double ret = (double)x / (double)this.field_146294_l * (double)this.field_146297_k.field_71443_c;
        return (int)ret;
    }

    private int screen2DisplayY(int y) {
        double ret = (double)y / (double)this.field_146295_m * (double)this.field_146297_k.field_71440_d;
        return (int)ret;
    }

    private void takeScreenshot() throws Throwable {
        int x = this.screen2DisplayX(this.x + 27);
        int y = this.field_146297_k.field_71440_d - this.screen2DisplayY(this.y + 4);
        int w = this.screen2DisplayX(120);
        int h = this.screen2DisplayY(68);
        y -= h;
        if (this.buffer == null) {
            this.buffer = BufferUtils.createIntBuffer((int)(w * h));
        }
        int oldPack = GL11.glGetInteger((int)3333);
        GL11.glPixelStorei((int)3333, (int)1);
        this.buffer.clear();
        GL11.glReadPixels((int)x, (int)y, (int)w, (int)h, (int)32993, (int)5121, (IntBuffer)this.buffer);
        GL11.glPixelStorei((int)3333, (int)oldPack);
        if (this.array == null) {
            this.array = new int[w * h];
        }
        this.buffer.clear();
        this.buffer.get(this.array);
        TextureUtil.func_147953_a((int[])this.array, (int)w, (int)h);
        File f = new File(this.field_146297_k.field_71412_D, "wd_recipes");
        if (!f.exists()) {
            f.mkdir();
        }
        f = new File(f, this.recipeName + ".png");
        BufferedImage bi = new BufferedImage(w, h, 1);
        bi.setRGB(0, 0, w, h, this.array, 0, w);
        ImageIO.write((RenderedImage)bi, "PNG", f);
    }

    public void func_73876_c() {
        if (this.recipeName != null) {
            try {
                this.takeScreenshot();
                this.nextRecipe();
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.field_146297_k.func_147108_a(null);
            }
        }
    }

    private static class NameRecipePair {
        private final String name;
        private final ShapedRecipes recipe;

        private NameRecipePair(String n, ShapedRecipes r) {
            this.name = n;
            this.recipe = r;
        }
    }
}

