/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.gui.controls;

import java.util.ArrayList;
import net.minecraft.client.shader.Framebuffer;
import net.montoyo.wd.client.gui.controls.BasicControl;
import net.montoyo.wd.client.gui.controls.Event;
import net.montoyo.wd.client.gui.loading.JsonOWrapper;
import org.lwjgl.opengl.GL11;

public class List
extends BasicControl {
    private int width;
    private int height;
    private final ArrayList<Entry> content = new ArrayList();
    private Framebuffer fbo;
    private int selected = -1;
    private boolean update;
    private int selColor = -16744193;
    private int contentH = 0;
    private int scrollSize;
    private int scrollPos = 0;
    private boolean scrolling = false;
    private int scrollGrab;

    public List() {
    }

    public List(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
        this.scrollSize = h - 2;
        this.createFBO();
    }

    private int getYOffset() {
        double amount = (double)this.scrollPos / (double)(this.height - 2 - this.scrollSize) * (double)(this.contentH - this.height);
        return (int)amount;
    }

    private boolean isInScrollbar(int mouseX, int mouseY) {
        return mouseX >= this.x + this.width - 5 && mouseX <= this.x + this.width - 1 && mouseY >= this.y + 1 + this.scrollPos && mouseY <= this.y + 1 + this.scrollPos + this.scrollSize;
    }

    private void createFBO() {
        if (this.fbo != null) {
            this.fbo.func_147608_a();
        }
        this.fbo = new Framebuffer(this.parent.screen2DisplayX(this.width), this.parent.screen2DisplayY(this.height), false);
        this.fbo.func_147607_a(9728);
        this.fbo.func_147610_a(false);
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glClear((int)16384);
        this.fbo.func_147609_e();
        this.update = true;
    }

    private void renderToFBO() {
        this.beginFramebuffer(this.fbo, this.width, this.height);
        this.fillRect(0, 0, this.width, this.height, -16777216);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int offset = 4 - this.getYOffset();
        for (int i = 0; i < this.content.size(); ++i) {
            int pos = i * 12 + offset;
            if (pos + 12 < 1) continue;
            if (pos >= this.height - 1) break;
            int color = i == this.selected ? this.selColor : -1;
            this.font.func_78276_b(this.content.get((int)i).text, 4, i * 12 + offset, color);
        }
        this.drawBorder(0, 0, this.width, this.height, -8355712);
        this.endFramebuffer(this.fbo);
    }

    @Override
    public void destroy() {
        if (this.fbo != null) {
            this.fbo.func_147608_a();
        }
    }

    public void setSize(int w, int h) {
        this.width = w;
        this.height = h;
        this.createFBO();
    }

    public void setWidth(int width) {
        this.width = width;
        this.createFBO();
    }

    public void setHeight(int height) {
        this.height = height;
        this.createFBO();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void updateContent() {
        this.contentH = this.content.size() * 12 + 4;
        int h2 = this.height - 2;
        if (this.contentH <= h2) {
            this.scrollSize = h2;
            this.scrollPos = 0;
        } else {
            this.scrollSize = h2 * h2 / this.contentH;
            if (this.scrollSize < 4) {
                this.scrollSize = 4;
            }
        }
        this.update = true;
    }

    public int addElement(String str) {
        return this.addElement(str, null);
    }

    public int addElement(String str, Object ud) {
        this.content.add(new Entry(str, ud));
        this.updateContent();
        return this.content.size() - 1;
    }

    public int addElementRaw(String str) {
        return this.addElement(str, null);
    }

    public int addElementRaw(String str, Object ud) {
        this.content.add(new Entry(str, ud));
        return this.content.size() - 1;
    }

    @Override
    public void setDisabled(boolean dis) {
        this.disabled = dis;
        if (dis) {
            this.selected = -1;
            this.update = true;
        }
    }

    @Override
    public void disable() {
        this.disabled = true;
        this.selected = -1;
        this.update = true;
    }

    @Override
    public void mouseMove(int mouseX, int mouseY) {
        int offset;
        int sel = -1;
        if (!(this.disabled || mouseX < this.x + 1 || mouseX > this.x + this.width - 6 || mouseY < this.y + 2 || mouseY > this.y + this.height - 2 || (sel = (mouseY - (offset = this.y + 4 - this.getYOffset())) / 12) >= 0 && sel < this.content.size())) {
            sel = -1;
        }
        if (this.selected != sel) {
            this.selected = sel;
            this.update = true;
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (!this.disabled && mouseButton == 0) {
            if (this.isInScrollbar(mouseX, mouseY)) {
                this.scrolling = true;
                this.scrollGrab = mouseY - (this.y + 1 + this.scrollPos);
            } else if (this.selected >= 0) {
                this.parent.actionPerformed(new EntryClick(this));
            }
        }
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY, int state) {
        if (!this.disabled && this.scrolling) {
            this.scrolling = false;
        }
    }

    @Override
    public void mouseScroll(int mouseX, int mouseY, int amount) {
        if (!this.disabled && !this.scrolling && mouseX >= this.x && mouseX <= this.x + this.width && mouseY >= this.y && mouseY <= this.y + this.height) {
            double disp = 12.0 * (double)(this.height - 2 - this.scrollSize) / (double)(this.contentH - this.height);
            int sp = this.scrollPos;
            sp = amount < 0 ? (sp += (int)disp) : (sp -= (int)disp);
            if (sp < 0) {
                sp = 0;
            } else if (sp > this.height - 2 - this.scrollSize) {
                sp = this.height - 2 - this.scrollSize;
            }
            if (sp != this.scrollPos) {
                this.scrollPos = sp;
                this.update = true;
            }
        }
    }

    @Override
    public void mouseClickMove(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        if (!this.disabled && this.scrolling) {
            int sp = mouseY - this.scrollGrab - this.y - 1;
            if (sp < 0) {
                sp = 0;
            } else if (sp > this.height - 2 - this.scrollSize) {
                sp = this.height - 2 - this.scrollSize;
            }
            if (this.scrollPos != sp) {
                this.scrollPos = sp;
                this.update = true;
            }
        }
    }

    @Override
    public void draw(int mouseX, int mouseY, float ptt) {
        if (this.visible) {
            if (this.update) {
                this.renderToFBO();
                this.update = false;
            }
            this.fbo.func_147612_c();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.fillTexturedRect(this.x, this.y, this.width, this.height, 0.0, 1.0, 1.0, 0.0);
            this.fbo.func_147606_d();
            this.fillRect(this.x + this.width - 5, this.y + 1 + this.scrollPos, 4, this.scrollSize, this.scrolling || this.isInScrollbar(mouseX, mouseY) ? -14671840 : -12566464);
        }
    }

    public String getEntryLabel(int id) {
        return this.content.get((int)id).text;
    }

    public Object getEntryUserdata(int id) {
        return this.content.get((int)id).userdata;
    }

    public int findEntryByLabel(String label) {
        for (int i = 0; i < this.content.size(); ++i) {
            if (!this.content.get((int)i).text.equals(label)) continue;
            return i;
        }
        return -1;
    }

    public int findEntryByUserdata(Object o) {
        if (o == null) {
            for (int i = 0; i < this.content.size(); ++i) {
                if (this.content.get((int)i).userdata != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.content.size(); ++i) {
                if (this.content.get((int)i).userdata == null || !this.content.get((int)i).userdata.equals(o)) continue;
                return i;
            }
        }
        return -1;
    }

    public void setSelectionColor(int selColor) {
        this.selColor = selColor;
    }

    public int getSelectionColor() {
        return this.selColor;
    }

    public int getElementCount() {
        return this.content.size();
    }

    public void removeElement(int id) {
        if (this.selected != -1 && id == this.content.size() - 1) {
            this.selected = -1;
        }
        this.content.remove(id);
        this.updateContent();
    }

    public void removeElementRaw(int id) {
        if (this.selected != -1 && id == this.content.size() - 1) {
            this.selected = -1;
        }
        this.content.remove(id);
    }

    public void clear() {
        this.content.clear();
        this.scrollPos = 0;
        this.scrolling = false;
        this.scrollSize = this.height - 2;
        this.selected = -1;
        this.update = true;
    }

    public void clearRaw() {
        this.content.clear();
        this.scrollPos = 0;
        this.scrolling = false;
        this.selected = -1;
    }

    @Override
    public void load(JsonOWrapper json) {
        super.load(json);
        this.width = json.getInt("width", 100);
        this.height = json.getInt("height", 100);
        this.selColor = json.getColor("selectionColor", -16744193);
        this.createFBO();
    }

    public static class EntryClick
    extends Event<List> {
        private final int id;
        private final Entry entry;

        private EntryClick(List lst) {
            this.source = lst;
            this.id = lst.selected;
            this.entry = (Entry)lst.content.get(lst.selected);
        }

        public int getId() {
            return this.id;
        }

        public String getLabel() {
            return this.entry.text;
        }

        public Object getUserdata() {
            return this.entry.userdata;
        }
    }

    private static class Entry {
        public final String text;
        public final Object userdata;

        public Entry(String t, Object o) {
            this.text = t;
            this.userdata = o;
        }
    }
}

