/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.miniserv.client;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.UUID;
import net.montoyo.wd.miniserv.OutgoingPacket;
import net.montoyo.wd.miniserv.PacketID;
import net.montoyo.wd.miniserv.client.ClientTask;

public class ClientTaskCheckFile
extends ClientTask<ClientTaskCheckFile> {
    private final UUID uuid;
    private final String fname;
    private int status = 3;

    public ClientTaskCheckFile(UUID id, String name) {
        this.uuid = id;
        this.fname = name;
        this.runCallbackOnMcThread = true;
    }

    @Override
    public void start() {
        OutgoingPacket pkt = new OutgoingPacket();
        pkt.writeByte(PacketID.GET_FILE.ordinal());
        pkt.writeLong(this.uuid.getMostSignificantBits());
        pkt.writeLong(this.uuid.getLeastSignificantBits());
        pkt.writeString(this.fname);
        pkt.writeBoolean(false);
        this.client.sendPacket(pkt);
    }

    @Override
    public void abort() {
    }

    public void onStatus(int s) {
        this.status = s;
        this.client.nextTask();
    }

    public int getStatus() {
        return this.status;
    }

    public String getURL() {
        try {
            return "wd://" + this.uuid.toString() + '/' + URLEncoder.encode(this.fname, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            return "hi";
        }
    }
}

