/*
 * Decompiled with CFR 0.152.
 */
package team.thegoldenhoe.cameraobscura.client;

import com.google.common.collect.Maps;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Map;
import javax.imageio.ImageIO;

public enum ClientPhotoCache {
    INSTANCE;

    private Map<String, BufferedImage> cache = Maps.newHashMap();
    private Map<String, byte[]> recvCache = Maps.newHashMap();
    private Map<String, Integer> recvCacheIndex = Maps.newHashMap();

    public BufferedImage getImage(String name) {
        return this.cache.get(name);
    }

    public void addBytes(String name, byte[] data, boolean isFinal, int fullSize) {
        byte[] bytes = this.recvCache.computeIfAbsent(name, k -> new byte[fullSize]);
        int index = this.recvCacheIndex.computeIfAbsent(name, k -> 0);
        System.arraycopy(data, 0, bytes, index, data.length);
        this.recvCacheIndex.put(name, index + data.length);
        if (isFinal) {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.recvCache.get(name));
            try {
                BufferedImage img = ImageIO.read(bais);
                this.cache.put(name, img);
                this.recvCache.remove(name);
                this.recvCacheIndex.remove(name);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

