/*
 * Decompiled with CFR 0.152.
 */
package team.thegoldenhoe.cameraobscura.client;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.RescaleOp;
import java.awt.image.WritableRaster;
import team.thegoldenhoe.cameraobscura.client.PhotoFilter;

public class PhotoFilters {
    public static final PhotoFilter BLACK_AND_WHITE = new PhotoFilter(){

        @Override
        public BufferedImage getFilteredImage(BufferedImage src) {
            ColorConvertOp op = new ColorConvertOp(ColorSpace.getInstance(1003), null);
            return op.filter(src, null);
        }
    };
    public static final PhotoFilter SEPIA = new PhotoFilter(){

        @Override
        public BufferedImage getFilteredImage(BufferedImage src) {
            int sepiaDepth = 20;
            int sepiaIntensity = 35;
            int w = src.getWidth();
            int h = src.getHeight();
            WritableRaster raster = src.getRaster();
            int[] pixels = new int[w * h * 3];
            raster.getPixels(0, 0, w, h, pixels);
            for (int i = 0; i < pixels.length; i += 3) {
                int gray;
                int r = pixels[i];
                int g = pixels[i + 1];
                int b = pixels[i + 2];
                g = b = (gray = (r + g + b) / 3);
                r = b;
                g += sepiaDepth;
                if ((r += sepiaDepth * 2) > 255) {
                    r = 255;
                }
                if (g > 255) {
                    g = 255;
                }
                if (b > 255) {
                    b = 255;
                }
                if ((b -= sepiaIntensity) < 0) {
                    b = 0;
                }
                if (b > 255) {
                    b = 255;
                }
                pixels[i] = r;
                pixels[i + 1] = g;
                pixels[i + 2] = b;
            }
            raster.setPixels(0, 0, w, h, pixels);
            return src;
        }
    };
    public static final PhotoFilter BLUR = new PhotoFilter(){

        @Override
        public BufferedImage getFilteredImage(BufferedImage src) {
            int radius = 3;
            int size = radius * 2 + 1;
            float weight = 1.0f / (float)(size * size);
            float[] data = new float[size * size];
            for (int i = 0; i < data.length; ++i) {
                data[i] = weight;
            }
            ConvolveOp op = new ConvolveOp(new Kernel(size, size, data), 1, null);
            return op.filter(src, null);
        }
    };
    public static final PhotoFilter BRIGHT_AND_HAPPY = new PhotoFilter(){

        @Override
        public BufferedImage getFilteredImage(BufferedImage src) {
            RescaleOp op = new RescaleOp(1.4f, 15.0f, null);
            op.filter(src, src);
            return src;
        }
    };
    public static final PhotoFilter HIGH_CONTRAST = new PhotoFilter(){

        @Override
        public BufferedImage getFilteredImage(BufferedImage src) {
            RescaleOp op = new RescaleOp(2.4f, 55.0f, null);
            op.filter(src, src);
            return src;
        }
    };
    public static final PhotoFilter LOW_SOBEL = new PhotoFilter(){

        @Override
        public BufferedImage getFilteredImage(BufferedImage src) {
            return PhotoFilters.getSobel(src, 30);
        }
    };
    public static final PhotoFilter HIGH_SOBEL = new PhotoFilter(){

        @Override
        public BufferedImage getFilteredImage(BufferedImage src) {
            return PhotoFilters.getSobel(src, 60);
        }
    };
    public static final PhotoFilter VINTAGE = new PhotoFilter(){

        @Override
        public BufferedImage getFilteredImage(BufferedImage src) {
            int w = src.getWidth();
            int h = src.getHeight();
            WritableRaster raster = src.getRaster();
            int[] pixels = new int[w * h * 3];
            raster.getPixels(0, 0, w, h, pixels);
            this.adjustChannels(pixels);
            raster.setPixels(0, 0, w, h, pixels);
            return src;
        }

        private void adjustChannels(int[] pixels) {
            for (int i = 0; i < pixels.length; ++i) {
                int blue;
                int green;
                int red = pixels[i] >> 16 & 0xFF;
                if ((red = (int)((double)red * 0.9)) > 240) {
                    red = 240;
                }
                if (red < 0) {
                    red = 0;
                }
                if ((green = pixels[i] >> 8 & 0xFF) > 123) {
                    green = (int)((double)green * 1.05);
                }
                if (green > 255) {
                    green = 255;
                }
                if (green < 0) {
                    green = 0;
                }
                if ((blue = pixels[i] & 0xFF) < 125) {
                    blue = (int)((double)blue * 1.15);
                } else if (blue >= 125) {
                    blue = (int)((double)blue * 0.85);
                }
                if (blue > 255) {
                    blue = 255;
                }
                if (blue < 0) {
                    blue = 0;
                }
                int rgb = red;
                rgb = (rgb << 8) + green;
                pixels[i] = rgb = (rgb << 8) + blue;
            }
        }
    };

    private static BufferedImage getSobel(BufferedImage src, int threshold) {
        int w = src.getWidth();
        int h = src.getHeight();
        BufferedImage out = new BufferedImage(w, h, 12);
        int blackRgb = Color.BLACK.getRGB();
        int whiteRgb = Color.WHITE.getRGB();
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int b;
                int g;
                int rgb = src.getRGB(x, y);
                int r = rgb >> 16 & 0xFF;
                int gray = (int)(0.2126 * (double)r + 0.7152 * (double)(g = rgb >> 8 & 0xFF) + 0.0722 * (double)(b = rgb & 0xFF));
                if (gray >= threshold) {
                    out.setRGB(x, y, whiteRgb);
                    continue;
                }
                out.setRGB(x, y, blackRgb);
            }
        }
        return out;
    }
}

