/*
 * Decompiled with CFR 0.152.
 */
package team.thegoldenhoe.cameraobscura.common.capability;

import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.INBTSerializable;
import team.thegoldenhoe.cameraobscura.common.item.ItemRegistry;

public interface ICameraStorageNBT
extends INBTSerializable<NBTTagCompound> {
    public ArrayList<String> getSavedImagePaths();

    public void setSavedImagePaths(ArrayList<String> var1);

    public int getMaxSaves();

    public void saveImage(String var1, EntityPlayer var2);

    public boolean canSave();

    default public NBTTagCompound serializeNBT() {
        NBTTagCompound ret = new NBTTagCompound();
        NBTTagList paths = new NBTTagList();
        ArrayList<String> pathsList = this.getSavedImagePaths();
        for (int i = 0; i < pathsList.size(); ++i) {
            String path = pathsList.get(i);
            if (path == null) continue;
            NBTTagCompound pathNBT = new NBTTagCompound();
            pathNBT.func_74778_a("save" + i, path);
            paths.func_74742_a((NBTBase)pathNBT);
        }
        ret.func_74782_a("Paths", (NBTBase)paths);
        return ret;
    }

    default public void deserializeNBT(NBTTagCompound nbt) {
        NBTTagList paths = nbt.func_150295_c("Paths", 10);
        ArrayList<String> ret = new ArrayList<String>(this.getMaxSaves());
        for (int i = 0; i < paths.func_74745_c(); ++i) {
            NBTTagCompound pathNBT = paths.func_150305_b(i);
            ret.add(pathNBT.func_74779_i("save" + i));
        }
        this.setSavedImagePaths(ret);
    }

    public static class VintageStorage
    implements ICameraStorageNBT {
        private ArrayList<String> paths = new ArrayList(this.getMaxSaves());

        @Override
        public ArrayList<String> getSavedImagePaths() {
            return this.paths;
        }

        @Override
        public void setSavedImagePaths(ArrayList<String> paths) {
            this.paths = paths;
        }

        @Override
        public int getMaxSaves() {
            return 1;
        }

        @Override
        public void saveImage(String path, EntityPlayer player) {
            this.paths.add(path);
            ItemStack singlePhoto = new ItemStack(ItemRegistry.vintagePhoto);
            singlePhoto.func_77982_d(new NBTTagCompound());
            singlePhoto.func_77978_p().func_74778_a("Photo", path);
            player.func_191521_c(singlePhoto);
        }

        @Override
        public boolean canSave() {
            return this.paths.size() < this.getMaxSaves();
        }
    }

    public static class PolaroidStackStorage
    implements ICameraStorageNBT {
        private ArrayList<String> paths = new ArrayList(this.getMaxSaves());
        public static final int MAX_SAVES = 6;

        @Override
        public ArrayList<String> getSavedImagePaths() {
            return this.paths;
        }

        @Override
        public void setSavedImagePaths(ArrayList<String> paths) {
            this.paths = paths;
        }

        @Override
        public int getMaxSaves() {
            return 6;
        }

        @Override
        public void saveImage(String path, EntityPlayer player) {
            this.paths.add(path);
        }

        @Override
        public boolean canSave() {
            return this.paths.size() < this.getMaxSaves();
        }
    }

    public static class SDCardStorage
    implements ICameraStorageNBT {
        private ArrayList<String> paths = new ArrayList(this.getMaxSaves());
        public static final int MAX_SAVES = 32;

        @Override
        public ArrayList<String> getSavedImagePaths() {
            return this.paths;
        }

        @Override
        public void setSavedImagePaths(ArrayList<String> paths) {
            this.paths = paths;
        }

        @Override
        public int getMaxSaves() {
            return 32;
        }

        @Override
        public void saveImage(String path, EntityPlayer player) {
            this.paths.add(path);
        }

        @Override
        public boolean canSave() {
            return this.paths.size() < this.getMaxSaves();
        }
    }
}

