/*
 * Decompiled with CFR 0.152.
 */
package team.thegoldenhoe.cameraobscura.common.item;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import team.thegoldenhoe.cameraobscura.common.capability.CameraCapabilities;
import team.thegoldenhoe.cameraobscura.common.capability.ICameraStorageNBT;
import team.thegoldenhoe.cameraobscura.common.item.ItemRegistry;

public class ItemPolaroidStack
extends Item {
    public ItemPolaroidStack() {
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
        ICameraStorageNBT.PolaroidStackStorage storage;
        int numPrintsRemaining = 6;
        if (stack.func_77978_p() == null) {
            tooltip.add("Empty");
        }
        if ((storage = (ICameraStorageNBT.PolaroidStackStorage)stack.getCapability(CameraCapabilities.getPolaroidStackCapability(), null)) != null) {
            ArrayList<String> paths = storage.getSavedImagePaths();
            numPrintsRemaining = storage.getMaxSaves() - paths.size();
            tooltip.add(TextFormatting.AQUA.toString() + TextFormatting.BOLD + "Prints Remaining: " + numPrintsRemaining);
            tooltip.add(TextFormatting.DARK_PURPLE.toString() + TextFormatting.ITALIC + "Usable in polaroid camera");
            if (!storage.canSave()) {
                tooltip.add(TextFormatting.ITALIC + "Contains Photo");
            }
        }
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, NBTTagCompound nbt) {
        return CameraCapabilities.getProvider(CameraCapabilities.getPolaroidStackCapability(), () -> {
            ICameraStorageNBT.PolaroidStackStorage ret = new ICameraStorageNBT.PolaroidStackStorage(){

                @Override
                public void saveImage(String path, EntityPlayer player) {
                    super.saveImage(path, player);
                    stack.func_77982_d(this.serializeNBT());
                    if (!player.field_70170_p.field_72995_K) {
                        ItemStack polaroidPhoto = new ItemStack(ItemRegistry.polaroidSingle);
                        polaroidPhoto.func_77982_d(new NBTTagCompound());
                        polaroidPhoto.func_77978_p().func_74778_a("Photo", path);
                        player.func_191521_c(polaroidPhoto);
                    }
                }
            };
            if (stack.func_77942_o()) {
                ret.deserializeNBT(stack.func_77978_p());
            }
            return ret;
        });
    }
}

