/*
 * Decompiled with CFR 0.152.
 */
package team.thegoldenhoe.cameraobscura.common.network;

import io.netty.buffer.ByteBuf;
import java.util.Comparator;
import java.util.UUID;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import team.thegoldenhoe.cameraobscura.common.network.PhotoDataHandler;

public class MessagePhotoDataToServer
implements IMessage {
    public String name;
    public byte[] data;
    public short order;
    public int uuid;
    public int length;
    public String playerUUID;
    public static final Comparator<MessagePhotoDataToServer> COMPARATOR = new Comparator<MessagePhotoDataToServer>(){

        @Override
        public int compare(MessagePhotoDataToServer m1, MessagePhotoDataToServer m2) {
            return m1.order - m2.order;
        }
    };

    public MessagePhotoDataToServer() {
    }

    public MessagePhotoDataToServer(int uuid, String name, byte[] data, short order, int length, UUID playerUUID) {
        this.name = name;
        this.data = data;
        this.uuid = uuid;
        this.order = order;
        this.length = length;
        this.playerUUID = playerUUID.toString();
    }

    public void fromBytes(ByteBuf buf) {
        this.uuid = buf.readInt();
        this.order = buf.readShort();
        this.length = buf.readInt();
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.playerUUID = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.data = new byte[buf.readableBytes()];
        buf.readBytes(this.data);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.uuid);
        buf.writeShort((int)this.order);
        buf.writeInt(this.length);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.playerUUID);
        buf.writeBytes(this.data);
    }

    public static final class Handler
    implements IMessageHandler<MessagePhotoDataToServer, IMessage> {
        public IMessage onMessage(MessagePhotoDataToServer message, MessageContext ctx) {
            PhotoDataHandler.bufferMessage(message);
            return null;
        }
    }
}

