/*
 * Decompiled with CFR 0.152.
 */
package com.attributestudios.wolfarmor;

import com.attributestudios.wolfarmor.WolfArmorMod;
import java.io.File;
import javax.annotation.Nonnull;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

public final class WolfArmorConfiguration {
    private Configuration config;
    private boolean isWolfChestEnabled = DEFAULT_WOLF_CHEST_ENABLED;
    private boolean isWolfArmorRenderEnabled = true;
    private boolean isWolfChestRenderEnabled = true;
    private boolean isWolfHealthDisplayEnabled = true;
    private boolean isWolfArmorDisplayEnabled = true;
    private boolean areHowlingUntamedWolvesEnabled = false;
    private boolean shouldWolvesEatWhenDamaged = true;
    private static final String SETTING_WOLF_CHEST_ENABLED = "config.wolfarmor.general.enableChests";
    private static final Boolean DEFAULT_WOLF_CHEST_ENABLED = true;
    private static final String SETTING_WOLF_ARMOR_RENDER_ENABLED = "config.wolfarmor.client.enableWolfArmorRender";
    private static final String SETTING_WOLF_CHEST_RENDER_ENABLED = "config.wolfarmor.client.enableWolfChestRender";
    private static final String SETTING_WOLF_ARMOR_DISPLAY_ENABLED = "config.wolfarmor.client.enableWolfArmorDisplay";
    private static final String SETTING_WOLF_HEALTH_DISPLAY_ENABLED = "config.wolfarmor.client.enableWolfHealthDisplay";
    private static final boolean DEFAULT_WOLF_ARMOR_RENDER_ENABLED = true;
    private static final boolean DEFAULT_WOLF_CHEST_RENDER_ENABLED = true;
    private static final boolean DEFAULT_WOLF_ARMOR_DISPLAY_ENABLED = true;
    private static final boolean DEFAULT_WOLF_HEALTH_DISPLAY_ENABLED = true;
    private static final String CATEGORY_BEHAVIOR = "behavior";
    private static final String SETTING_HOWLING_UNTAMED_WOLVES_ENABLED = "config.wolfarmor.behavior.enableHowlingUntamedWolves";
    private static final String SETTING_WOLVES_EAT_FOOD_IN_INVENTORY = "config.wolfarmor.behavior.shouldWolvesEatWhenDamaged";
    private static final boolean DEFAULT_HOWLING_UNTAMED_WOLVES_ENABLED = false;
    private static final boolean DEFAULT_WOLVES_EAT_FOOD_IN_INVENTORY = true;

    public WolfArmorConfiguration(@Nonnull FMLPreInitializationEvent preInitializationEvent) {
        this.config = new Configuration(WolfArmorConfiguration.getConfigurationFile(preInitializationEvent));
        WolfArmorMod.getLogger().debug("Loading mod configuration...");
        this.config.load();
        WolfArmorMod.getLogger().debug("Mod configuration loaded.");
        this.syncConfig(preInitializationEvent.getSide() == Side.CLIENT);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onConfigChanged(@Nonnull ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.getModID().equals("wolfarmor")) {
            this.syncConfig(FMLCommonHandler.instance().getSide() == Side.CLIENT);
        }
    }

    private void syncIsWolfChestEnabled() {
        this.isWolfChestEnabled = this.getSettingWolfChestsEnabled().getBoolean();
    }

    private void syncIsWolfArmorRenderEnabled() {
        this.isWolfArmorRenderEnabled = this.getSettingWolfArmorRenderEnabled().getBoolean();
    }

    private void syncIsWolfChestRenderEnabled() {
        this.isWolfChestRenderEnabled = this.getSettingWolfChestRenderEnabled().getBoolean();
    }

    private void syncIsWolfArmorDisplayEnabled() {
        this.isWolfArmorDisplayEnabled = this.getSettingWolfArmorDisplayEnabled().getBoolean();
    }

    private void syncIsWolfHealthDisplayEnabled() {
        this.isWolfHealthDisplayEnabled = this.getSettingWolfHealthDisplayEnabled().getBoolean();
    }

    private void syncAreHowlingUntamedWolvesEnabled() {
        this.areHowlingUntamedWolvesEnabled = this.getSettingHowlingUntamedWolvesEnabled().getBoolean();
    }

    private void syncShouldWolvesEatWhenDamaged() {
        this.shouldWolvesEatWhenDamaged = this.getSettingWolvesEatWhenDamaged().getBoolean();
    }

    private void syncConfig(boolean isClientSide) {
        this.syncIsWolfChestEnabled();
        if (isClientSide) {
            this.syncIsWolfArmorRenderEnabled();
            this.syncIsWolfChestRenderEnabled();
            this.syncIsWolfArmorDisplayEnabled();
            this.syncIsWolfHealthDisplayEnabled();
        }
        this.syncAreHowlingUntamedWolvesEnabled();
        this.syncShouldWolvesEatWhenDamaged();
        if (this.config.hasChanged()) {
            WolfArmorMod.getLogger().debug("Saving configuration...");
            this.config.save();
            WolfArmorMod.getLogger().debug("Mod configuration saved.");
        }
    }

    @Nonnull
    private static File getConfigurationFile(@Nonnull FMLPreInitializationEvent preInitializationEvent) {
        File mainConfig;
        WolfArmorMod.getLogger().debug("Retrieving config file...");
        File configDir = new File(preInitializationEvent.getModConfigurationDirectory() + "/attributestudios");
        if (!configDir.exists()) {
            WolfArmorMod.getLogger().debug("Creating new top-level mod config directory...");
            configDir.mkdirs();
        }
        if (!(mainConfig = new File(configDir.getPath() + "/" + "wolfarmor" + ".cfg")).exists()) {
            WolfArmorMod.getLogger().debug("Configuration file not found. A new configuration file will be created.");
        }
        return mainConfig;
    }

    public boolean getIsWolfChestEnabled() {
        return this.isWolfChestEnabled;
    }

    public boolean getIsWolfArmorRenderEnabled() {
        return this.isWolfArmorRenderEnabled;
    }

    public boolean getIsWolfChestRenderEnabled() {
        return this.isWolfChestRenderEnabled;
    }

    public boolean getIsWolfArmorDisplayEnabled() {
        return this.isWolfArmorDisplayEnabled;
    }

    public boolean getIsWolfHealthDisplayEnabled() {
        return this.isWolfHealthDisplayEnabled;
    }

    public boolean getAreHowlingUntamedWolvesEnabled() {
        return this.areHowlingUntamedWolvesEnabled;
    }

    public boolean getShouldWolvesEatWhenDamaged() {
        return this.shouldWolvesEatWhenDamaged;
    }

    @Nonnull
    public Property getSettingWolfChestsEnabled() {
        return this.config.get("general", SETTING_WOLF_CHEST_ENABLED, DEFAULT_WOLF_CHEST_ENABLED.booleanValue(), "Enables or disables wolf backpacks.");
    }

    @Nonnull
    public Property getSettingWolfArmorRenderEnabled() {
        return this.config.get("client", SETTING_WOLF_ARMOR_RENDER_ENABLED, true, "Enables or disables rendering of wolf armor.");
    }

    @Nonnull
    public Property getSettingWolfChestRenderEnabled() {
        return this.config.get("client", SETTING_WOLF_CHEST_RENDER_ENABLED, true, "Enables or disables rendering of wolf backpacks.");
    }

    @Nonnull
    public Property getSettingWolfArmorDisplayEnabled() {
        return this.config.get("client", SETTING_WOLF_ARMOR_DISPLAY_ENABLED, true, "Enables or disables displaying a wolf's armor value in the wolf inventory screen.");
    }

    @Nonnull
    public Property getSettingWolfHealthDisplayEnabled() {
        return this.config.get("client", SETTING_WOLF_HEALTH_DISPLAY_ENABLED, true, "Enables or disables displaying a wolf's health value in the wolf inventory screen.");
    }

    @Nonnull
    public Property getSettingHowlingUntamedWolvesEnabled() {
        return this.config.get(CATEGORY_BEHAVIOR, SETTING_HOWLING_UNTAMED_WOLVES_ENABLED, false, "Enables or disables untamed wolves howling at the full moon.");
    }

    @Nonnull
    public Property getSettingWolvesEatWhenDamaged() {
        return this.config.get(CATEGORY_BEHAVIOR, SETTING_WOLVES_EAT_FOOD_IN_INVENTORY, true, "Enables or disables wolves eating food in their inventories when their health is low.");
    }
}

