/*
 * Decompiled with CFR 0.152.
 */
package com.attributestudios.wolfarmor.advancements;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.critereon.AbstractCriterionInstance;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;

public class WolfArmorTrigger
implements ICriterionTrigger<Instance> {
    private final Map<PlayerAdvancements, Listeners> listeners = Maps.newHashMap();
    private final ResourceLocation id;

    public WolfArmorTrigger(ResourceLocation id) {
        this.id = id;
    }

    @Nonnull
    public ResourceLocation func_192163_a() {
        return this.id;
    }

    public void func_192165_a(@Nonnull PlayerAdvancements playerAdvancementsIn, @Nonnull ICriterionTrigger.Listener<Instance> listener) {
        Listeners listeners = this.listeners.get(playerAdvancementsIn);
        if (listeners == null) {
            listeners = new Listeners(playerAdvancementsIn);
            this.listeners.put(playerAdvancementsIn, listeners);
        }
        listeners.add(listener);
    }

    public void func_192164_b(@Nonnull PlayerAdvancements playerAdvancementsIn, @Nonnull ICriterionTrigger.Listener<Instance> listener) {
        Listeners listeners = this.listeners.get(playerAdvancementsIn);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this.listeners.remove(playerAdvancementsIn);
            }
        }
    }

    public void func_192167_a(@Nonnull PlayerAdvancements playerAdvancementsIn) {
        this.listeners.remove(playerAdvancementsIn);
    }

    @Nonnull
    public Instance deserializeInstance(@Nonnull JsonObject json, @Nonnull JsonDeserializationContext context) {
        return new Instance(this.id, EntityPredicate.func_192481_a((JsonElement)json.get("entity")));
    }

    public void trigger(EntityPlayerMP player, Entity entity) {
        Listeners listeners = this.listeners.get(player.func_192039_O());
        if (listeners != null) {
            listeners.trigger(player, entity);
        }
    }

    static final class Listeners {
        private final PlayerAdvancements playerAdvancements;
        private final Set<ICriterionTrigger.Listener<Instance>> listeners = Sets.newHashSet();

        Listeners(@Nonnull PlayerAdvancements playerAdvancements) {
            this.playerAdvancements = playerAdvancements;
        }

        boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        void add(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.add(listener);
        }

        void remove(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.remove(listener);
        }

        public void trigger(EntityPlayerMP player, Entity entity) {
            List list = null;
            for (ICriterionTrigger.Listener<Instance> listener : this.listeners) {
                if (!((Instance)listener.func_192158_a()).test(player, entity)) continue;
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(listener);
            }
            if (list != null) {
                for (ICriterionTrigger.Listener listener : list) {
                    listener.func_192159_a(this.playerAdvancements);
                }
            }
        }
    }

    static final class Instance
    extends AbstractCriterionInstance {
        private EntityPredicate target;

        Instance(ResourceLocation criterion, EntityPredicate target) {
            super(criterion);
            this.target = target;
        }

        boolean test(EntityPlayerMP player, Entity entity) {
            return this.target.func_192482_a(player, entity);
        }
    }
}

