/*
 * Decompiled with CFR 0.152.
 */
package com.attributestudios.wolfarmor.client;

import com.attributestudios.wolfarmor.api.client.RenderLayerFactory;
import com.attributestudios.wolfarmor.api.util.Items;
import com.attributestudios.wolfarmor.client.renderer.entity.layer.LayerWolfArmor;
import com.attributestudios.wolfarmor.client.renderer.entity.layer.LayerWolfBackpack;
import com.attributestudios.wolfarmor.common.CommonProxy;
import com.attributestudios.wolfarmor.item.ItemWolfArmor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderWolf;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    @Override
    public void registerEntityRenderingHandlers() {
        RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        RenderWolf renderWolf = (RenderWolf)renderManager.field_78729_o.get(EntityWolf.class);
        LayerWolfArmor armor = (LayerWolfArmor)RenderLayerFactory.createArmorLayer((RenderLiving)renderWolf);
        LayerWolfBackpack backpack = (LayerWolfBackpack)RenderLayerFactory.createBackpackLayer((RenderLiving)renderWolf);
        if (armor == null || backpack == null) {
            throw new RuntimeException("Armor layer factory failed initialization!");
        }
        renderWolf.func_177094_a((LayerRenderer)armor);
        renderWolf.func_177094_a((LayerRenderer)backpack);
    }

    @Override
    public void registerItemRenders(@Nonnull FMLInitializationEvent initializationEvent) {
        ClientProxy.registerItemModel(Items.LEATHER_WOLF_ARMOR);
        ClientProxy.registerItemModel(Items.CHAINMAIL_WOLF_ARMOR);
        ClientProxy.registerItemModel(Items.IRON_WOLF_ARMOR);
        ClientProxy.registerItemModel(Items.GOLD_WOLF_ARMOR);
        ClientProxy.registerItemModel(Items.DIAMOND_WOLF_ARMOR);
    }

    @Override
    public void registerItemColorHandlers(@Nonnull FMLInitializationEvent initializationEvent) {
        Minecraft.func_71410_x().getItemColors().func_186730_a(new IItemColor(){

            public int func_186726_a(@Nonnull ItemStack stack, int tintIndex) {
                return tintIndex > 0 ? -1 : ((ItemWolfArmor)stack.func_77973_b()).getColor(stack);
            }
        }, new Item[]{Items.LEATHER_WOLF_ARMOR});
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerItemModel(@Nullable Item item) {
        if (item != null && item.getRegistryName() != null) {
            ModelResourceLocation resource = new ModelResourceLocation(item.getRegistryName().toString(), "inventory");
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{item.getRegistryName()});
            Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(item, 0, resource);
        }
    }

    @Override
    public IThreadListener getThreadFromContext(MessageContext context) {
        return context.side.isClient() ? Minecraft.func_71410_x() : super.getThreadFromContext(context);
    }

    @Override
    public EntityPlayer getPlayerFromContext(MessageContext context) {
        return context.side.isClient() ? Minecraft.func_71410_x().field_71439_g : super.getPlayerFromContext(context);
    }

    @Override
    public Side getCurrentSide() {
        return Side.CLIENT;
    }
}

